/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class CheckNotDataStreamWriteIndexStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-not-write-index";
    private static final Logger logger = LogManager.getLogger(CheckNotDataStreamWriteIndexStep.class);

    CheckNotDataStreamWriteIndexStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ProjectState currentState) {
        boolean isFailureStoreWriteIndex;
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        String indexName = index.getName();
        if (indexMetadata == null) {
            String errorMessage = Strings.format("[%s] lifecycle action for index [%s] executed but index no longer exists", this.getKey().action(), indexName);
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(indexName);
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + indexName + "] was not found";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null && ((isFailureStoreWriteIndex = index.equals(dataStream.getWriteFailureIndex())) || dataStream.getWriteIndex().equals(index))) {
            String errorMessage = Strings.format("index [%s] is the%s write index for data stream [%s], pausing ILM execution of lifecycle [%s] until this index is no longer the write index for the data stream via manual or automated rollover", indexName, isFailureStoreWriteIndex ? " failure store" : "", dataStream.getName(), policyName);
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
        }
        return new ClusterStateWaitStep.Result(true, null);
    }
}

