/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class DataStreamLifecycleFeatureSetUsage
extends XPackFeatureUsage {
    public static final DataStreamLifecycleFeatureSetUsage DISABLED = new DataStreamLifecycleFeatureSetUsage();
    final LifecycleStats lifecycleStats;

    public DataStreamLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.lifecycleStats = LifecycleStats.read(input);
    }

    private DataStreamLifecycleFeatureSetUsage() {
        super("data_lifecycle", true, false);
        this.lifecycleStats = LifecycleStats.INITIAL;
    }

    public DataStreamLifecycleFeatureSetUsage(LifecycleStats stats) {
        super("data_lifecycle", true, true);
        this.lifecycleStats = stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.lifecycleStats.writeTo(out);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            this.lifecycleStats.toXContent(builder, params);
        }
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.lifecycleStats);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamLifecycleFeatureSetUsage other = (DataStreamLifecycleFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && Objects.equals(this.lifecycleStats, other.lifecycleStats);
    }

    public static class LifecycleStats
    implements Writeable,
    ToXContentFragment {
        public static final LifecycleStats INITIAL = new LifecycleStats(0L, true, RetentionStats.NO_DATA, RetentionStats.NO_DATA, Map.of());
        public static final String DEFAULT_RETENTION_FIELD_NAME = "default";
        public static final String MAX_RETENTION_FIELD_NAME = "max";
        final long dataStreamsWithLifecyclesCount;
        final boolean defaultRolloverUsed;
        final RetentionStats dataRetentionStats;
        final RetentionStats effectiveRetentionStats;
        final Map<String, GlobalRetentionStats> globalRetentionStats;

        public LifecycleStats(long dataStreamsWithLifecyclesCount, boolean defaultRolloverUsed, RetentionStats dataRetentionStats, RetentionStats effectiveRetentionStats, Map<String, GlobalRetentionStats> globalRetentionStats) {
            this.dataStreamsWithLifecyclesCount = dataStreamsWithLifecyclesCount;
            this.defaultRolloverUsed = defaultRolloverUsed;
            this.dataRetentionStats = dataRetentionStats;
            this.effectiveRetentionStats = effectiveRetentionStats;
            this.globalRetentionStats = globalRetentionStats;
        }

        public static LifecycleStats read(StreamInput in) throws IOException {
            return new LifecycleStats(in.readVLong(), in.readBoolean(), RetentionStats.read(in), RetentionStats.read(in), in.readMap(GlobalRetentionStats::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamsWithLifecyclesCount);
            out.writeBoolean(this.defaultRolloverUsed);
            this.dataRetentionStats.writeTo(out);
            this.effectiveRetentionStats.writeTo(out);
            out.writeMap(this.globalRetentionStats, (o, v) -> v.writeTo(o));
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamsWithLifecyclesCount, this.defaultRolloverUsed, this.dataRetentionStats, this.effectiveRetentionStats, this.globalRetentionStats);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecycleStats other = (LifecycleStats)obj;
            return this.dataStreamsWithLifecyclesCount == other.dataStreamsWithLifecyclesCount && this.defaultRolloverUsed == other.defaultRolloverUsed && Objects.equals(this.dataRetentionStats, other.dataRetentionStats) && Objects.equals(this.effectiveRetentionStats, other.effectiveRetentionStats) && Objects.equals(this.globalRetentionStats, other.globalRetentionStats);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.dataStreamsWithLifecyclesCount);
            builder.field("default_rollover_used", this.defaultRolloverUsed);
            RetentionStats.toXContentFragment(builder, this.dataRetentionStats, false);
            RetentionStats.toXContentFragment(builder, this.effectiveRetentionStats, true);
            builder.startObject("global_retention");
            GlobalRetentionStats.toXContentFragment(builder, DEFAULT_RETENTION_FIELD_NAME, this.globalRetentionStats.get(DEFAULT_RETENTION_FIELD_NAME));
            GlobalRetentionStats.toXContentFragment(builder, MAX_RETENTION_FIELD_NAME, this.globalRetentionStats.get(MAX_RETENTION_FIELD_NAME));
            builder.endObject();
            return builder;
        }
    }

    public record GlobalRetentionStats(long dataStreamCount, long retention) implements Writeable
    {
        public GlobalRetentionStats(long dataStreamCount, TimeValue retention) {
            this(dataStreamCount, retention.getMillis());
        }

        public GlobalRetentionStats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong());
        }

        public static Map<String, GlobalRetentionStats> getGlobalRetentionStats(DataStreamGlobalRetention globalRetention, long dataStreamsWithDefaultRetention, long dataStreamsWithMaxRetention) {
            if (globalRetention == null) {
                return Map.of();
            }
            HashMap<String, GlobalRetentionStats> globalRetentionStats = new HashMap<String, GlobalRetentionStats>();
            if (globalRetention.defaultRetention() != null) {
                globalRetentionStats.put("default", new GlobalRetentionStats(dataStreamsWithDefaultRetention, globalRetention.defaultRetention()));
            }
            if (globalRetention.maxRetention() != null) {
                globalRetentionStats.put("max", new GlobalRetentionStats(dataStreamsWithMaxRetention, globalRetention.maxRetention()));
            }
            return globalRetentionStats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamCount);
            out.writeVLong(this.retention);
        }

        static void toXContentFragment(XContentBuilder builder, String retentionType, GlobalRetentionStats stats) throws IOException {
            builder.startObject(retentionType);
            builder.field("defined", stats != null);
            if (stats != null) {
                builder.field("affected_data_streams", stats.dataStreamCount());
                builder.field("retention_millis", stats.retention());
            }
            builder.endObject();
        }
    }

    public record RetentionStats(long dataStreamCount, Double avgMillis, Long minMillis, Long maxMillis) implements Writeable
    {
        static final RetentionStats NO_DATA = new RetentionStats(0L, null, null, null);

        public static RetentionStats create(LongSummaryStatistics statistics) {
            if (statistics.getCount() == 0L) {
                return NO_DATA;
            }
            return new RetentionStats(statistics.getCount(), statistics.getAverage(), statistics.getMin(), statistics.getMax());
        }

        public static RetentionStats read(StreamInput in) throws IOException {
            long dataStreamCount = in.readVLong();
            if (dataStreamCount == 0L) {
                return NO_DATA;
            }
            double avgMillis = in.readDouble();
            long minMillis = in.readVLong();
            long maxMillis = in.readVLong();
            return new RetentionStats(dataStreamCount, avgMillis, minMillis, maxMillis);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamCount);
            if (this.dataStreamCount > 0L) {
                out.writeDouble(this.avgMillis);
                out.writeVLong(this.minMillis);
                out.writeVLong(this.maxMillis);
            }
        }

        static void toXContentFragment(XContentBuilder builder, RetentionStats stats, boolean isEffectiveRetention) throws IOException {
            builder.startObject(isEffectiveRetention ? "effective_retention" : "data_retention");
            builder.field(isEffectiveRetention ? "retained_data_streams" : "configured_data_streams", stats.dataStreamCount());
            if (stats.dataStreamCount() > 0L) {
                builder.field("minimum_millis", stats.minMillis);
                builder.field("maximum_millis", stats.maxMillis);
                builder.field("average_millis", stats.avgMillis);
            }
            builder.endObject();
        }
    }
}

