/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;

public class DataStreamFeatureSetUsage
extends XPackFeatureUsage {
    private final DataStreamStats streamStats;

    public DataStreamFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.streamStats = new DataStreamStats(input);
    }

    public DataStreamFeatureSetUsage(DataStreamStats stats) {
        super("data_streams", true, true);
        this.streamStats = stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.streamStats.writeTo(out);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    public DataStreamStats getStats() {
        return this.streamStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("data_streams", this.streamStats.totalDataStreamCount);
        builder.field("indices_count", this.streamStats.indicesBehindDataStream);
        builder.startObject("failure_store");
        builder.field("explicitly_enabled_count", this.streamStats.failureStoreExplicitlyEnabledDataStreamCount);
        builder.field("effectively_enabled_count", this.streamStats.failureStoreEffectivelyEnabledDataStreamCount);
        builder.field("failure_indices_count", this.streamStats.failureStoreIndicesCount);
        builder.startObject("lifecycle");
        builder.field("explicitly_enabled_count", this.streamStats.failuresLifecycleExplicitlyEnabledCount);
        builder.field("effectively_enabled_count", this.streamStats.failuresLifecycleEffectivelyEnabledCount);
        DataStreamLifecycleFeatureSetUsage.RetentionStats.toXContentFragment(builder, this.streamStats.failuresLifecycleDataRetentionStats, false);
        DataStreamLifecycleFeatureSetUsage.RetentionStats.toXContentFragment(builder, this.streamStats.failuresLifecycleEffectiveRetentionStats, true);
        builder.startObject("global_retention");
        DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats.toXContentFragment(builder, "default", this.streamStats.globalRetentionStats.get("default"));
        DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats.toXContentFragment(builder, "max", this.streamStats.globalRetentionStats.get("max"));
        builder.endObject();
        builder.endObject();
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public int hashCode() {
        return this.streamStats.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamFeatureSetUsage other = (DataStreamFeatureSetUsage)obj;
        return Objects.equals(this.streamStats, other.streamStats);
    }

    public record DataStreamStats(long totalDataStreamCount, long indicesBehindDataStream, long failureStoreExplicitlyEnabledDataStreamCount, long failureStoreEffectivelyEnabledDataStreamCount, long failureStoreIndicesCount, long failuresLifecycleExplicitlyEnabledCount, long failuresLifecycleEffectivelyEnabledCount, DataStreamLifecycleFeatureSetUsage.RetentionStats failuresLifecycleDataRetentionStats, DataStreamLifecycleFeatureSetUsage.RetentionStats failuresLifecycleEffectiveRetentionStats, Map<String, DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats> globalRetentionStats) implements Writeable
    {
        private static final TransportVersion INTRODUCE_FAILURES_LIFECYCLE = TransportVersion.fromName("introduce_failures_lifecycle");

        public DataStreamStats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? in.readVLong() : 0L, in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? in.readVLong() : 0L, in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? DataStreamLifecycleFeatureSetUsage.RetentionStats.read(in) : DataStreamLifecycleFeatureSetUsage.RetentionStats.NO_DATA, in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? DataStreamLifecycleFeatureSetUsage.RetentionStats.read(in) : DataStreamLifecycleFeatureSetUsage.RetentionStats.NO_DATA, in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? in.readMap(DataStreamLifecycleFeatureSetUsage.GlobalRetentionStats::new) : Map.of());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.totalDataStreamCount);
            out.writeVLong(this.indicesBehindDataStream);
            out.writeVLong(this.failureStoreExplicitlyEnabledDataStreamCount);
            out.writeVLong(this.failureStoreEffectivelyEnabledDataStreamCount);
            out.writeVLong(this.failureStoreIndicesCount);
            if (out.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE)) {
                out.writeVLong(this.failuresLifecycleExplicitlyEnabledCount);
                out.writeVLong(this.failuresLifecycleEffectivelyEnabledCount);
                this.failuresLifecycleDataRetentionStats.writeTo(out);
                this.failuresLifecycleEffectiveRetentionStats.writeTo(out);
                out.writeMap(this.globalRetentionStats, (o, v) -> v.writeTo(o));
            }
        }
    }
}

