/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public class ImmutableFollowParameters
implements Writeable {
    private final Integer maxReadRequestOperationCount;
    private final Integer maxWriteRequestOperationCount;
    private final Integer maxOutstandingReadRequests;
    private final Integer maxOutstandingWriteRequests;
    private final ByteSizeValue maxReadRequestSize;
    private final ByteSizeValue maxWriteRequestSize;
    private final Integer maxWriteBufferCount;
    private final ByteSizeValue maxWriteBufferSize;
    private final TimeValue maxRetryDelay;
    private final TimeValue readPollTimeout;

    public ImmutableFollowParameters(Integer maxReadRequestOperationCount, Integer maxWriteRequestOperationCount, Integer maxOutstandingReadRequests, Integer maxOutstandingWriteRequests, ByteSizeValue maxReadRequestSize, ByteSizeValue maxWriteRequestSize, Integer maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue readPollTimeout) {
        this.maxReadRequestOperationCount = maxReadRequestOperationCount;
        this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
        this.maxOutstandingReadRequests = maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = maxOutstandingWriteRequests;
        this.maxReadRequestSize = maxReadRequestSize;
        this.maxWriteRequestSize = maxWriteRequestSize;
        this.maxWriteBufferCount = maxWriteBufferCount;
        this.maxWriteBufferSize = maxWriteBufferSize;
        this.maxRetryDelay = maxRetryDelay;
        this.readPollTimeout = readPollTimeout;
    }

    public Integer getMaxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    public ByteSizeValue getMaxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    public Integer getMaxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    public Integer getMaxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    public ByteSizeValue getMaxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    public Integer getMaxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    public Integer getMaxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    public ByteSizeValue getMaxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    public TimeValue getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public TimeValue getReadPollTimeout() {
        return this.readPollTimeout;
    }

    public ImmutableFollowParameters(StreamInput in) throws IOException {
        this.maxReadRequestOperationCount = in.readOptionalVInt();
        this.maxReadRequestSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.maxOutstandingReadRequests = in.readOptionalVInt();
        this.maxWriteRequestOperationCount = in.readOptionalVInt();
        this.maxWriteRequestSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.maxOutstandingWriteRequests = in.readOptionalVInt();
        this.maxWriteBufferCount = in.readOptionalVInt();
        this.maxWriteBufferSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.maxRetryDelay = in.readOptionalTimeValue();
        this.readPollTimeout = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.maxReadRequestOperationCount);
        out.writeOptionalWriteable(this.maxReadRequestSize);
        out.writeOptionalVInt(this.maxOutstandingReadRequests);
        out.writeOptionalVInt(this.maxWriteRequestOperationCount);
        out.writeOptionalWriteable(this.maxWriteRequestSize);
        out.writeOptionalVInt(this.maxOutstandingWriteRequests);
        out.writeOptionalVInt(this.maxWriteBufferCount);
        out.writeOptionalWriteable(this.maxWriteBufferSize);
        out.writeOptionalTimeValue(this.maxRetryDelay);
        out.writeOptionalTimeValue(this.readPollTimeout);
    }

    protected XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        if (this.maxReadRequestOperationCount != null) {
            builder.field(FollowParameters.MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
        }
        if (this.maxWriteRequestOperationCount != null) {
            builder.field(FollowParameters.MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
        }
        if (this.maxOutstandingReadRequests != null) {
            builder.field(FollowParameters.MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxOutstandingReadRequests);
        }
        if (this.maxOutstandingWriteRequests != null) {
            builder.field(FollowParameters.MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxOutstandingWriteRequests);
        }
        if (this.maxReadRequestSize != null) {
            builder.field(FollowParameters.MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
        }
        if (this.maxWriteRequestSize != null) {
            builder.field(FollowParameters.MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
        }
        if (this.maxWriteBufferCount != null) {
            builder.field(FollowParameters.MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
        }
        if (this.maxWriteBufferSize != null) {
            builder.field(FollowParameters.MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
        }
        if (this.maxRetryDelay != null) {
            builder.field(FollowParameters.MAX_RETRY_DELAY.getPreferredName(), this.maxRetryDelay.getStringRep());
        }
        if (this.readPollTimeout != null) {
            builder.field(FollowParameters.READ_POLL_TIMEOUT.getPreferredName(), this.readPollTimeout.getStringRep());
        }
        return builder;
    }

    public static <P extends ImmutableFollowParameters> void initParser(ConstructingObjectParser<P, ?> parser) {
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), FollowParameters.MAX_READ_REQUEST_OPERATION_COUNT);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), FollowParameters.MAX_WRITE_REQUEST_OPERATION_COUNT);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), FollowParameters.MAX_OUTSTANDING_READ_REQUESTS);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), FollowParameters.MAX_OUTSTANDING_WRITE_REQUESTS);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), FollowParameters.MAX_READ_REQUEST_SIZE.getPreferredName()), FollowParameters.MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), FollowParameters.MAX_WRITE_REQUEST_SIZE.getPreferredName()), FollowParameters.MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), FollowParameters.MAX_WRITE_BUFFER_COUNT);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), FollowParameters.MAX_WRITE_BUFFER_SIZE.getPreferredName()), FollowParameters.MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), FollowParameters.MAX_RETRY_DELAY.getPreferredName()), FollowParameters.MAX_RETRY_DELAY, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), FollowParameters.READ_POLL_TIMEOUT.getPreferredName()), FollowParameters.READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableFollowParameters)) {
            return false;
        }
        ImmutableFollowParameters that = (ImmutableFollowParameters)o;
        return Objects.equals(this.maxReadRequestOperationCount, that.maxReadRequestOperationCount) && Objects.equals(this.maxWriteRequestOperationCount, that.maxWriteRequestOperationCount) && Objects.equals(this.maxOutstandingReadRequests, that.maxOutstandingReadRequests) && Objects.equals(this.maxOutstandingWriteRequests, that.maxOutstandingWriteRequests) && Objects.equals(this.maxReadRequestSize, that.maxReadRequestSize) && Objects.equals(this.maxWriteRequestSize, that.maxWriteRequestSize) && Objects.equals(this.maxWriteBufferCount, that.maxWriteBufferCount) && Objects.equals(this.maxWriteBufferSize, that.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, that.maxRetryDelay) && Objects.equals(this.readPollTimeout, that.readPollTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.maxReadRequestOperationCount, this.maxWriteRequestOperationCount, this.maxOutstandingReadRequests, this.maxOutstandingWriteRequests, this.maxReadRequestSize, this.maxWriteRequestSize, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.readPollTimeout);
    }
}

