/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;

public class AsyncSearchSecurity {
    private static final FetchSourceContext FETCH_HEADERS_FIELD_CONTEXT = FetchSourceContext.of(true, new String[]{"headers"}, Strings.EMPTY_ARRAY);
    private final String indexName;
    private final SecurityContext securityContext;
    private final Client client;
    private final OriginSettingClient clientWithOrigin;

    public AsyncSearchSecurity(String indexName, SecurityContext securityContext, Client client, String origin) {
        this.securityContext = securityContext;
        this.client = client;
        this.clientWithOrigin = new OriginSettingClient(client, origin);
        this.indexName = indexName;
    }

    public void currentUserHasCancelTaskPrivilege(Consumer<Boolean> consumer) {
        this.hasClusterPrivilege(ClusterPrivilegeResolver.CANCEL_TASK.name(), ActionListener.wrap(consumer::accept, ex -> consumer.accept(false)));
    }

    public void currentUserCanSeeStatusOfAllSearches(ActionListener<Boolean> listener) {
        this.hasClusterPrivilege("cluster:monitor/async_search/status", listener);
    }

    private void hasClusterPrivilege(String privilegeName, ActionListener<Boolean> listener) {
        Authentication current = this.securityContext.getAuthentication();
        if (current != null) {
            HasPrivilegesRequest req = new HasPrivilegesRequest();
            req.username(current.getEffectiveSubject().getUser().principal());
            req.clusterPrivileges(privilegeName);
            req.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
            req.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            try {
                this.client.execute(HasPrivilegesAction.INSTANCE, req, listener.map(resp -> resp.isCompleteMatch()));
            }
            catch (Exception exc) {
                listener.onFailure(exc);
            }
        } else {
            listener.onResponse(false);
        }
    }

    public boolean currentUserHasAccessToTask(AsyncTask asyncTask) throws IOException {
        Objects.requireNonNull(asyncTask, "Task cannot be null");
        return this.currentUserHasAccessToTaskWithHeaders(asyncTask.getOriginHeaders());
    }

    public boolean currentUserHasAccessToTaskWithHeaders(Map<String, String> headers) throws IOException {
        return this.securityContext.canIAccessResourcesCreatedWithHeaders(headers);
    }

    void ensureAuthenticatedUserCanDeleteFromIndex(AsyncExecutionId executionId, ActionListener<Void> listener) {
        this.getTaskHeadersFromIndex(executionId, listener.map(headers -> {
            if (this.currentUserHasAccessToTaskWithHeaders((Map<String, String>)headers)) {
                return null;
            }
            throw new ResourceNotFoundException(executionId.getEncoded(), new Object[0]);
        }));
    }

    private void getTaskHeadersFromIndex(AsyncExecutionId executionId, ActionListener<Map<String, String>> listener) {
        GetRequest internalGet = new GetRequest(this.indexName).preference(executionId.getEncoded()).id(executionId.getDocId()).fetchSourceContext(FETCH_HEADERS_FIELD_CONTEXT);
        this.clientWithOrigin.get(internalGet, ActionListener.wrap(get -> {
            if (!get.isExists()) {
                listener.onFailure(new ResourceNotFoundException(executionId.getEncoded(), new Object[0]));
                return;
            }
            Map headers = (Map)get.getSource().get("headers");
            listener.onResponse(headers);
        }, exc -> listener.onFailure(new ResourceNotFoundException(executionId.getEncoded(), new Object[0]))));
    }
}

