/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class XPackFeatureUsage
implements ToXContentObject,
VersionedNamedWriteable {
    private static final String AVAILABLE_XFIELD = "available";
    private static final String ENABLED_XFIELD = "enabled";
    protected final String name;
    protected final boolean available;
    protected final boolean enabled;

    public XPackFeatureUsage(StreamInput input) throws IOException {
        this(input.readString(), input.readBoolean(), input.readBoolean());
    }

    public XPackFeatureUsage(String name, boolean available, boolean enabled) {
        Objects.requireNonNull(name);
        this.name = name;
        this.available = available;
        this.enabled = enabled;
    }

    public String name() {
        return this.name;
    }

    public boolean available() {
        return this.available;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String getWriteableName() {
        return this.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.available);
        out.writeBoolean(this.enabled);
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXContent(builder, params);
        return builder.endObject();
    }

    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(AVAILABLE_XFIELD, this.available);
        builder.field(ENABLED_XFIELD, this.enabled);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPackFeatureUsage that = (XPackFeatureUsage)o;
        return this.available == that.available && this.enabled == that.enabled && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.available, this.enabled);
    }
}

