/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.HealthApiFeatureSetUsage;
import org.elasticsearch.xpack.core.RemoteClusterFeatureSetUsage;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.aggregatemetric.AggregateMetricFeatureSetUsage;
import org.elasticsearch.xpack.core.analytics.AnalyticsFeatureSetUsage;
import org.elasticsearch.xpack.core.application.EnterpriseSearchFeatureSetUsage;
import org.elasticsearch.xpack.core.application.LogsDBFeatureSetUsage;
import org.elasticsearch.xpack.core.application.ProfilingUsage;
import org.elasticsearch.xpack.core.archive.ArchiveFeatureSetUsage;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.datastreams.DataStreamFeatureSetUsage;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.datatiers.DataTiersFeatureSetUsage;
import org.elasticsearch.xpack.core.downsample.DownsampleShardStatus;
import org.elasticsearch.xpack.core.enrich.EnrichFeatureSetUsage;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.core.eql.EqlFeatureSetUsage;
import org.elasticsearch.xpack.core.esql.EsqlFeatureSetUsage;
import org.elasticsearch.xpack.core.frozen.FrozenIndicesFeatureSetUsage;
import org.elasticsearch.xpack.core.graph.GraphFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.DownsampleAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.FreezeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotAction;
import org.elasticsearch.xpack.core.inference.InferenceFeatureSetUsage;
import org.elasticsearch.xpack.core.inference.chunking.NoneChunkingSettings;
import org.elasticsearch.xpack.core.inference.chunking.RecursiveChunkingSettings;
import org.elasticsearch.xpack.core.inference.chunking.SentenceBoundaryChunkingSettings;
import org.elasticsearch.xpack.core.inference.chunking.WordBoundaryChunkingSettings;
import org.elasticsearch.xpack.core.logstash.LogstashFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.search.SparseVectorQueryBuilder;
import org.elasticsearch.xpack.core.ml.search.TextExpansionQueryBuilder;
import org.elasticsearch.xpack.core.ml.search.WeightedTokensQueryBuilder;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.core.rollup.RollupFeatureSetUsage;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotFeatureSetUsage;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.authc.TokenMetadata;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AllExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AnyExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExceptExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissionGroup;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.support.SecurityMigrationTaskParams;
import org.elasticsearch.xpack.core.slm.SLMFeatureSetUsage;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.spatial.SpatialFeatureSetUsage;
import org.elasticsearch.xpack.core.sql.SqlFeatureSetUsage;
import org.elasticsearch.xpack.core.transform.TransformFeatureSetUsage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.transforms.NullRetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TimeRetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.votingonly.VotingOnlyNodeFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;

public class XPackClientPlugin
extends Plugin
implements ActionPlugin,
SearchPlugin,
NetworkPlugin {
    @Override
    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.groupSetting("license.", Setting.Property.NodeScope));
        settings.addAll(XPackSettings.getAllSettings());
        settings.add(Setting.simpleString("index.xpack.version", Setting.Property.IndexScope));
        return settings;
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Stream.concat(Stream.of(new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "graph", GraphFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "logstash", LogstashFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "ml", MachineLearningFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "inference", InferenceFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "monitoring", MonitoringFeatureSetUsage::new), new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "security_tokens", TokenMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "security_tokens", TokenMetadata::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "security", SecurityFeatureSetUsage::new), new NamedWriteableRegistry.Entry(ConfigurableClusterPrivilege.class, "manage-application-privileges", ConfigurableClusterPrivileges.ManageApplicationPrivileges::createFrom), new NamedWriteableRegistry.Entry(ConfigurableClusterPrivilege.class, "write-profile-data-privileges", ConfigurableClusterPrivileges.WriteProfileDataPrivileges::createFrom), new NamedWriteableRegistry.Entry(ConfigurableClusterPrivilege.class, "manage-roles-privilege", ConfigurableClusterPrivileges.ManageRolesPrivilege::createFrom), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "role_mappings", RoleMappingMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "role_mappings", RoleMappingMetadata::readDiffFrom), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "all", AllExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "any", AnyExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "field", FieldExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "except", ExceptExpression::new), new NamedWriteableRegistry.Entry(RemoteClusterPermissions.class, "remote_cluster_permissions", RemoteClusterPermissions::new), new NamedWriteableRegistry.Entry(RemoteClusterPermissionGroup.class, "remote_cluster_permission_group", RemoteClusterPermissionGroup::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "eql", EqlFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "esql", EsqlFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "sql", SqlFeatureSetUsage::new), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "watcher", WatcherMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "watcher", WatcherMetadata::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "watcher", WatcherFeatureSetUsage::new), new NamedWriteableRegistry.Entry(Metadata.ClusterCustom.class, "licenses", LicensesMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetadata::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "rollup", RollupFeatureSetUsage::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/rollup/job", RollupJob::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/rollup/job", RollupJobStatus::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/rollup/job", RollupJobStatus::new), new NamedWriteableRegistry.Entry(Task.Status.class, "rollup-index-shard", DownsampleShardStatus::new), new NamedWriteableRegistry.Entry(AutoFollowMetadata.class, "ccr_auto_follow", AutoFollowMetadata::new), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "ccr_auto_follow", AutoFollowMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "ccr_auto_follow", in -> AutoFollowMetadata.readDiffFrom(Metadata.ProjectCustom.class, "ccr_auto_follow", in)), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "ilm", IndexLifecycleFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "slm", SLMFeatureSetUsage::new), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "index_lifecycle", IndexLifecycleMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "index_lifecycle", IndexLifecycleMetadata.IndexLifecycleMetadataDiff::new), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "lifecycle_operation", LifecycleOperationMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "lifecycle_operation", LifecycleOperationMetadata.LifecycleOperationMetadataDiff::new), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "snapshot_lifecycle", SnapshotLifecycleMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "snapshot_lifecycle", SnapshotLifecycleMetadata.SnapshotLifecycleMetadataDiff::new), new NamedWriteableRegistry.Entry(LifecycleType.class, "timeseries", in -> TimeseriesLifecycleType.INSTANCE), new NamedWriteableRegistry.Entry(LifecycleAction.class, "allocate", AllocateAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "forcemerge", ForceMergeAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "readonly", ReadOnlyAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "rollover", RolloverAction::read), new NamedWriteableRegistry.Entry(LifecycleAction.class, "shrink", ShrinkAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "delete", DeleteAction::readFrom), new NamedWriteableRegistry.Entry(LifecycleAction.class, "freeze", in -> FreezeAction.INSTANCE), new NamedWriteableRegistry.Entry(LifecycleAction.class, "set_priority", SetPriorityAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "unfollow", in -> UnfollowAction.INSTANCE), new NamedWriteableRegistry.Entry(LifecycleAction.class, "wait_for_snapshot", WaitForSnapshotAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "searchable_snapshot", SearchableSnapshotAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "migrate", MigrateAction::readFrom), new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "transform", TransformMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "transform", TransformMetadata.TransformMetadataDiff::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "transform", TransformFeatureSetUsage::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "data_frame/transforms", TransformTaskParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "data_frame/transforms", TransformState::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "data_frame/transforms", TransformState::new), new NamedWriteableRegistry.Entry(SyncConfig.class, TransformField.TIME.getPreferredName(), TimeSyncConfig::new), new NamedWriteableRegistry.Entry(RetentionPolicyConfig.class, TransformField.TIME.getPreferredName(), TimeRetentionPolicyConfig::new), new NamedWriteableRegistry.Entry(RetentionPolicyConfig.class, NullRetentionPolicyConfig.NAME.getPreferredName(), i -> NullRetentionPolicyConfig.INSTANCE), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "voting_only", VotingOnlyNodeFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "frozen_indices", FrozenIndicesFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "spatial", SpatialFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "analytics", AnalyticsFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "aggregate_metric", AggregateMetricFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "enrich", EnrichFeatureSetUsage::new), new NamedWriteableRegistry.Entry(Task.Status.class, "enrich-policy-execution", ExecuteEnrichPolicyStatus::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "searchable_snapshots", SearchableSnapshotFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "data_streams", DataStreamFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "data_lifecycle", DataStreamLifecycleFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "data_tiers", DataTiersFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "archive", ArchiveFeatureSetUsage::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "downsample", DownsampleAction::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "health_api", HealthApiFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "remote_clusters", RemoteClusterFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "enterprise_search", EnterpriseSearchFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "universal_profiling", ProfilingUsage::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "security-migration", SecurityMigrationTaskParams::new), new NamedWriteableRegistry.Entry(XPackFeatureUsage.class, "logsdb", LogsDBFeatureSetUsage::new)), XPackClientPlugin.getChunkingSettingsNamedWriteables().stream()).filter(Objects::nonNull).toList();
    }

    public static List<NamedWriteableRegistry.Entry> getChunkingSettingsNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ChunkingSettings.class, "NoneChunkingSettings", in -> NoneChunkingSettings.INSTANCE), new NamedWriteableRegistry.Entry(ChunkingSettings.class, "WordBoundaryChunkingSettings", WordBoundaryChunkingSettings::new), new NamedWriteableRegistry.Entry(ChunkingSettings.class, "SentenceBoundaryChunkingSettings", SentenceBoundaryChunkingSettings::new), new NamedWriteableRegistry.Entry(ChunkingSettings.class, "RecursiveChunkingSettings", RecursiveChunkingSettings::new));
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("ml", new String[0]), parser -> MlMetadata.LENIENT_PARSER.parse((XContentParser)parser, (Void)null).build()), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/datafeed", new String[0]), StartDatafeedAction.DatafeedParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/job", new String[0]), OpenJobAction.JobParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/data_frame/analytics", new String[0]), StartDataFrameAnalyticsAction.TaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/job/snapshot/upgrade", new String[0]), SnapshotUpgradeTaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/datafeed", new String[0]), DatafeedState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/job", new String[0]), JobTaskState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/data_frame/analytics", new String[0]), DataFrameAnalyticsTaskState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/job/snapshot/upgrade", new String[0]), SnapshotUpgradeTaskState::fromXContent), new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("watcher", new String[0]), WatcherMetadata::fromXContent), new NamedXContentRegistry.Entry(Metadata.ClusterCustom.class, new ParseField("licenses", new String[0]), LicensesMetadata::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/rollup/job", new String[0]), RollupJob::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/rollup/job", new String[0]), RollupJobStatus::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/rollup/job", new String[0]), RollupJobStatus::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("data_frame/transforms", new String[0]), TransformTaskParams::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("data_frame/transforms", new String[0]), TransformState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("data_frame/transforms", new String[0]), TransformState::fromXContent), new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("transform", new String[0]), parser -> TransformMetadata.LENIENT_PARSER.parse((XContentParser)parser, (Void)null).build()), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("security-migration", new String[0]), SecurityMigrationTaskParams::fromXContent), new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("role_mappings", new String[0]), RoleMappingMetadata::fromXContent));
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return List.of(new SearchPlugin.QuerySpec<SparseVectorQueryBuilder>("sparse_vector", SparseVectorQueryBuilder::new, SparseVectorQueryBuilder::fromXContent), new SearchPlugin.QuerySpec<QueryBuilder>("text_expansion", TextExpansionQueryBuilder::new, TextExpansionQueryBuilder::fromXContent), new SearchPlugin.QuerySpec<QueryBuilder>("weighted_tokens", WeightedTokensQueryBuilder::new, WeightedTokensQueryBuilder::fromXContent));
    }
}

