/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.node.Node;
import org.elasticsearch.transport.LinkedProjectConfigService;

public abstract class RemoteClusterAware
implements LinkedProjectConfigService.LinkedProjectConfigListener {
    public static final char REMOTE_CLUSTER_INDEX_SEPARATOR = ':';
    public static final String LOCAL_CLUSTER_GROUP_KEY = "";
    protected final Settings settings;
    private final String nodeName;
    private final boolean isRemoteClusterClientEnabled;

    protected RemoteClusterAware(Settings settings) {
        this.settings = settings;
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.isRemoteClusterClientEnabled = DiscoveryNode.isRemoteClusterClient(settings);
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    public static boolean isRemoteIndexName(String indexExpression) {
        if (indexExpression.isEmpty() || indexExpression.charAt(0) == '<' || indexExpression.startsWith("-<")) {
            return false;
        }
        int idx = indexExpression.indexOf(58);
        boolean isSelector = indexExpression.startsWith("::", idx);
        return idx > 0 && !isSelector;
    }

    public static List<String> getRemoteIndexExpressions(String ... expressions) {
        ArrayList<String> crossClusterIndices = new ArrayList<String>();
        for (int i = 0; i < expressions.length; ++i) {
            if (!RemoteClusterAware.isRemoteIndexName(expressions[i])) continue;
            crossClusterIndices.add(expressions[i]);
        }
        return crossClusterIndices;
    }

    public static String parseClusterAlias(String indexExpression) {
        assert (indexExpression != null) : "Must not pass null indexExpression";
        return RemoteClusterAware.getClusterAlias(RemoteClusterAware.splitIndexName(indexExpression.trim()));
    }

    public static String getClusterAlias(String[] split) {
        return split[0] == null ? LOCAL_CLUSTER_GROUP_KEY : split[0];
    }

    public static String getLocalIndexName(String[] split) {
        return split[1];
    }

    public static String[] splitIndexName(String indexExpression) {
        if (indexExpression.isEmpty() || indexExpression.charAt(0) == '<' || indexExpression.startsWith("-<")) {
            return new String[]{null, indexExpression};
        }
        int i = indexExpression.indexOf(58);
        if (i == 0) {
            throw new IllegalArgumentException("index name [" + indexExpression + "] is invalid because the remote part is empty");
        }
        if (i < 0 || indexExpression.startsWith("::", i)) {
            return new String[]{null, indexExpression};
        }
        return new String[]{indexExpression.substring(0, i), indexExpression.substring(i + 1)};
    }

    protected Map<String, List<String>> groupClusterIndices(Set<String> remoteClusterNames, String[] requestIndices) {
        HashMap<String, List<String>> perClusterIndices = new HashMap<String, List<String>>();
        HashSet<String> clustersToRemove = new HashSet<String>();
        for (String index : requestIndices) {
            String[] split = RemoteClusterAware.splitIndexName(index);
            if (split[0] != null) {
                if (!this.isRemoteClusterClientEnabled) {
                    assert (remoteClusterNames.isEmpty()) : remoteClusterNames;
                    throw new IllegalArgumentException("node [" + this.nodeName + "] does not have the remote cluster client role enabled");
                }
                String remoteClusterName = split[0];
                String indexName = split[1];
                boolean isNegative = remoteClusterName.startsWith("-");
                List<String> clusters = ClusterNameExpressionResolver.resolveClusterNames(remoteClusterNames, isNegative ? remoteClusterName.substring(1) : remoteClusterName);
                if (isNegative) {
                    Tuple<String, String> indexAndSelector = IndexNameExpressionResolver.splitSelectorExpression(indexName);
                    indexName = indexAndSelector.v1();
                    String selectorString = indexAndSelector.v2();
                    if (!indexName.equals("*")) {
                        throw new IllegalArgumentException(Strings.format("To exclude a cluster you must specify the '*' wildcard for the index expression, but found: [%s]", indexName));
                    }
                    if (selectorString != null) {
                        throw new IllegalArgumentException(Strings.format("To exclude a cluster you must not specify the a selector, but found selector: [%s]", selectorString));
                    }
                    clustersToRemove.addAll(clusters);
                    continue;
                }
                for (String clusterName : clusters) {
                    perClusterIndices.computeIfAbsent(clusterName, k -> new ArrayList()).add(indexName);
                }
                continue;
            }
            perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
        }
        ArrayList<String> excludeFailed = new ArrayList<String>();
        for (String exclude : clustersToRemove) {
            List removed = (List)perClusterIndices.remove(exclude);
            if (removed != null) continue;
            excludeFailed.add(exclude);
        }
        if (excludeFailed.size() > 0) {
            String warning = Strings.format("Attempt to exclude cluster%s %s failed as %s not included in the list of clusters to be included: %s. Input: [%s]", excludeFailed.size() == 1 ? LOCAL_CLUSTER_GROUP_KEY : "s", excludeFailed, excludeFailed.size() == 1 ? "it is" : "they are", perClusterIndices.keySet().stream().map(s -> s.equals(LOCAL_CLUSTER_GROUP_KEY) ? "(local)" : s).collect(Collectors.toList()), String.join((CharSequence)",", requestIndices));
            throw new IllegalArgumentException(warning);
        }
        if (clustersToRemove.size() > 0 && perClusterIndices.size() == 0) {
            throw new IllegalArgumentException("The '-' exclusions in the index expression list excludes all indexes. Nothing to search. Input: [" + String.join((CharSequence)",", requestIndices) + "]");
        }
        return perClusterIndices;
    }

    public static String buildRemoteIndexName(String clusterAlias, String indexName) {
        return clusterAlias == null || LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias) ? indexName : clusterAlias + ":" + indexName;
    }
}

