/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ProjectRepo;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotNameAlreadyInUseException;
import org.elasticsearch.snapshots.SnapshotsService;

public class SnapshotsServiceUtils {
    private static final Logger logger = LogManager.getLogger(SnapshotsServiceUtils.class);

    public static void ensureSnapshotNameNotRunning(SnapshotsInProgress runningSnapshots, ProjectId projectId, String repositoryName, String snapshotName) {
        if (runningSnapshots.forRepo(projectId, repositoryName).stream().anyMatch(s -> s.snapshot().getSnapshotId().getName().equals(snapshotName))) {
            throw new SnapshotNameAlreadyInUseException(repositoryName, snapshotName, "snapshot with the same name is already in-progress");
        }
    }

    public static void ensureNoCleanupInProgress(ClusterState currentState, String repositoryName, String snapshotName, String reason) {
        RepositoryCleanupInProgress repositoryCleanupInProgress = RepositoryCleanupInProgress.get(currentState);
        if (repositoryCleanupInProgress.hasCleanupInProgress()) {
            throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot " + reason + " while a repository cleanup is in-progress in " + String.valueOf(repositoryCleanupInProgress.entries().stream().map(RepositoryCleanupInProgress.Entry::repository).collect(Collectors.toSet())));
        }
    }

    public static void ensureNotReadOnly(ProjectMetadata projectMetadata, String repositoryName) {
        RepositoryMetadata repositoryMetadata = RepositoriesMetadata.get(projectMetadata).repository(repositoryName);
        if (RepositoriesService.isReadOnly(repositoryMetadata.settings())) {
            throw new RepositoryException(repositoryMetadata.name(), "repository is readonly", new Object[0]);
        }
    }

    public static void ensureSnapshotNameAvailableInRepo(RepositoryData repositoryData, String snapshotName, Repository repository) {
        if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
            throw new SnapshotNameAlreadyInUseException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
        }
    }

    public static void ensureRepositoryExists(String repoName, ProjectMetadata projectMetadata) {
        if (RepositoriesMetadata.get(projectMetadata).repository(repoName) == null) {
            throw new RepositoryMissingException(repoName);
        }
    }

    public static void validate(String repositoryName, String snapshotName, ProjectMetadata projectMetadata) {
        if (RepositoriesMetadata.get(projectMetadata).repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsServiceUtils.validate(repositoryName, snapshotName);
    }

    public static void validate(String repositoryName, String snapshotName) {
        if (!org.elasticsearch.common.Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!org.elasticsearch.common.Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + org.elasticsearch.common.Strings.INVALID_FILENAME_CHARS);
        }
    }

    public static boolean assertNoDanglingSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        SnapshotDeletionsInProgress snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(state);
        Set reposWithRunningDelete = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(entry -> new ProjectRepo(entry.projectId(), entry.repository())).collect(Collectors.toSet());
        for (List<SnapshotsInProgress.Entry> repoEntry : snapshotsInProgress.entriesByRepo()) {
            SnapshotsInProgress.Entry entry2 = repoEntry.get(0);
            for (SnapshotsInProgress.ShardSnapshotStatus value : entry2.shardSnapshotStatusByRepoShardId().values()) {
                if (value.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                    assert (reposWithRunningDelete.contains(new ProjectRepo(entry2.projectId(), entry2.repository()))) : "Found shard snapshot waiting to be assigned in [" + String.valueOf(entry2) + "] but it is not blocked by any running delete";
                    continue;
                }
                if (value.isActive()) assert (!reposWithRunningDelete.contains(new ProjectRepo(entry2.projectId(), entry2.repository()))) : "Found shard snapshot actively executing in [" + String.valueOf(entry2) + "] when it should be blocked by a running delete [" + org.elasticsearch.common.Strings.toString(snapshotDeletionsInProgress) + "]";
            }
        }
        return true;
    }

    public static boolean useShardGenerations(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean useIndexGenerations(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SnapshotsService.INDEX_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean includesUUIDs(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SnapshotsService.UUIDS_IN_REPO_DATA_VERSION);
    }

    public static boolean includeFileInfoWriterUUID(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SnapshotsService.FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION);
    }

    public static boolean isWritingToRepository(SnapshotsInProgress.Entry entry) {
        if (entry.state().completed()) {
            return true;
        }
        for (SnapshotsInProgress.ShardSnapshotStatus value : entry.shardSnapshotStatusByRepoShardId().values()) {
            if (!value.isActive()) continue;
            return true;
        }
        return false;
    }

    public static boolean isQueued(@Nullable SnapshotsInProgress.ShardSnapshotStatus status) {
        return status != null && status.state() == SnapshotsInProgress.ShardState.QUEUED;
    }

    public static FinalizeSnapshotContext.UpdatedShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        ShardGenerations.Builder deletedBuilder = null;
        if (snapshot.isClone()) {
            snapshot.shardSnapshotStatusByRepoShardId().forEach((key, value) -> builder.put(key.index(), key.shardId(), (SnapshotsInProgress.ShardSnapshotStatus)value));
        } else {
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> entry : snapshot.shardSnapshotStatusByRepoShardId().entrySet()) {
                RepositoryShardId key2 = entry.getKey();
                SnapshotsInProgress.ShardSnapshotStatus value2 = entry.getValue();
                Index index = snapshot.indexByName(key2.indexName());
                if (!metadata.getProject(snapshot.projectId()).hasIndex(index)) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    if (deletedBuilder == null) {
                        deletedBuilder = ShardGenerations.builder();
                    }
                    deletedBuilder.put(key2.index(), key2.shardId(), value2);
                    continue;
                }
                builder.put(key2.index(), key2.shardId(), value2);
            }
        }
        return new FinalizeSnapshotContext.UpdatedShardGenerations(builder.build(), deletedBuilder == null ? ShardGenerations.EMPTY : deletedBuilder.build());
    }

    public static ProjectMetadata projectForSnapshot(SnapshotsInProgress.Entry snapshot, ProjectMetadata project) {
        ProjectMetadata.Builder builder;
        if (!snapshot.includeGlobalState()) {
            builder = ProjectMetadata.builder(project.id());
            for (IndexId index : snapshot.indices().values()) {
                IndexMetadata indexMetadata = project.index(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
            }
        } else {
            builder = ProjectMetadata.builder(project);
        }
        HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
        Set<String> indicesInSnapshot = snapshot.indices().keySet();
        for (String dataStreamName : snapshot.dataStreams()) {
            DataStream dataStream = project.dataStreams().get(dataStreamName);
            if (dataStream == null) {
                assert (snapshot.partial()) : "Data stream [" + dataStreamName + "] was deleted during a snapshot but snapshot was not partial.";
                continue;
            }
            DataStream reconciled = dataStream.snapshot(indicesInSnapshot, builder);
            if (reconciled == null) continue;
            dataStreams.put(dataStreamName, reconciled);
        }
        return builder.dataStreams(dataStreams, SnapshotsServiceUtils.filterDataStreamAliases(dataStreams, project.dataStreamAliases())).build();
    }

    public static List<SnapshotsInProgress.Entry> currentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, ProjectId projectId, String repository, List<String> snapshots) {
        if (snapshotsInProgress == null || snapshotsInProgress.isEmpty()) {
            return Collections.emptyList();
        }
        if ("_all".equals(repository)) {
            return snapshotsInProgress.asStream(projectId).toList();
        }
        if (snapshots.isEmpty()) {
            return snapshotsInProgress.forRepo(projectId, repository);
        }
        ArrayList<SnapshotsInProgress.Entry> builder = new ArrayList<SnapshotsInProgress.Entry>();
        block0: for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(projectId, repository)) {
            for (String snapshot : snapshots) {
                if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                builder.add(entry);
                continue block0;
            }
        }
        return Collections.unmodifiableList(builder);
    }

    public static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShardsAndRemovedNodes(SnapshotsInProgress.Entry snapshotEntry, RoutingTable routingTable, DiscoveryNodes nodes, Predicate<String> nodeIdRemovalPredicate, Map<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures) {
        assert (!snapshotEntry.isClone()) : "clones take a different path";
        boolean snapshotChanged = false;
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardSnapshotEntry : snapshotEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = shardSnapshotEntry.getValue();
            ShardId shardId = snapshotEntry.shardId(shardSnapshotEntry.getKey());
            if (shardStatus.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                SnapshotsInProgress.ShardSnapshotStatus knownFailure = knownFailures.get(shardSnapshotEntry.getKey());
                if (knownFailure == null) {
                    IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                    if (indexShardRoutingTable == null) {
                        assert (snapshotEntry.partial());
                        snapshotChanged = true;
                        logger.debug("failing snapshot of shard [{}] because index got deleted", (Object)shardId);
                        shards.put(shardId, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        knownFailures.put(shardSnapshotEntry.getKey(), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        continue;
                    }
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                shards.put(shardId, knownFailure);
                continue;
            }
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING || shardStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null) {
                    String primaryNodeId = shardRouting.primaryShard().currentNodeId();
                    if (nodeIdRemovalPredicate.test(primaryNodeId)) {
                        if (shardStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                            shards.put(shardId, shardStatus);
                            continue;
                        }
                        snapshotChanged = true;
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primaryNodeId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        logger.debug("Starting shard [{}] with shard generation [{}] that we were waiting to start on node [{}]. Previous shard state [{}]\n", (Object)shardId, (Object)shardStatus.generation(), (Object)shardStatus.nodeId(), (Object)shardStatus.state());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primaryNodeId, shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on node [{}] because shard is unassigned", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, shardStatus.generation(), "shard is unassigned");
                shards.put(shardId, failedState);
                knownFailures.put(shardSnapshotEntry.getKey(), failedState);
                continue;
            }
            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                if (nodes.nodeExists(shardStatus.nodeId())) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on departed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, shardStatus.generation(), "node left the cluster during snapshot");
                shards.put(shardId, failedState);
                knownFailures.put(shardSnapshotEntry.getKey(), failedState);
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return shards.build();
        }
        return null;
    }

    public static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterChangedEvent event) {
        for (List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
            for (SnapshotsInProgress.Entry entry : entries) {
                if (entry.state() != SnapshotsInProgress.State.STARTED || entry.isClone()) continue;
                ProjectId projectId = entry.projectId();
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    RepositoryShardId shardId;
                    Index index;
                    SnapshotsInProgress.ShardState state = shardStatus.getValue().state();
                    if (state != SnapshotsInProgress.ShardState.WAITING && state != SnapshotsInProgress.ShardState.QUEUED && state != SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL || !event.indexRoutingTableChanged(index = entry.indexByName((shardId = shardStatus.getKey()).indexName()))) continue;
                    IndexRoutingTable indexShardRoutingTable = event.state().routingTable(projectId).index(index);
                    if (indexShardRoutingTable == null) {
                        return true;
                    }
                    ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.shardId()).primaryShard();
                    if ((!shardRouting.started() || snapshotsInProgress.isNodeIdForRemoval(shardRouting.currentNodeId())) && !shardRouting.unassigned()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) {
            return false;
        }
        Set removedNodeIds = removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return snapshotsInProgress.asStream().anyMatch(snapshot -> {
            if (snapshot.state().completed() || snapshot.isClone()) {
                return false;
            }
            for (SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus : snapshot.shardSnapshotStatusByRepoShardId().values()) {
                if (shardSnapshotStatus.state().completed() || !removedNodeIds.contains(shardSnapshotStatus.nodeId())) continue;
                return true;
            }
            return false;
        });
    }

    public static List<SnapshotFeatureInfo> onlySuccessfulFeatureStates(SnapshotsInProgress.Entry entry, List<String> finalIndices) {
        assert (entry.partial()) : "should not try to filter feature states from a non-partial entry";
        HashSet indicesWithUnsuccessfulShards = new HashSet();
        entry.shardSnapshotStatusByRepoShardId().forEach((key, value) -> {
            SnapshotsInProgress.ShardState shardState = value.state();
            if (shardState.failed() || !shardState.completed()) {
                indicesWithUnsuccessfulShards.add(key.indexName());
            }
        });
        return entry.featureStates().stream().filter(stateInfo -> finalIndices.containsAll(stateInfo.getIndices())).filter(stateInfo -> !stateInfo.getIndices().stream().anyMatch(indicesWithUnsuccessfulShards::contains)).toList();
    }

    public static Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> readyDeletions(ClusterState currentState, @Nullable ProjectId projectId) {
        SnapshotDeletionsInProgress deletions = SnapshotDeletionsInProgress.get(currentState);
        if (!deletions.hasDeletionsInProgress() || projectId != null && !deletions.hasDeletionsInProgress(projectId)) {
            return Tuple.tuple(currentState, List.of());
        }
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)currentState.custom("snapshots");
        assert (snapshotsInProgress != null);
        HashSet<ProjectRepo> repositoriesSeen = new HashSet<ProjectRepo>();
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> readyDeletions = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        ArrayList<SnapshotDeletionsInProgress.Entry> newDeletes = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (projectId != null && !projectId.equals(entry.projectId())) {
                newDeletes.add(entry);
                continue;
            }
            ProjectRepo projectRepo = new ProjectRepo(entry.projectId(), entry.repository());
            if (repositoriesSeen.add(projectRepo) && entry.state() == SnapshotDeletionsInProgress.State.WAITING && snapshotsInProgress.forRepo(projectRepo).stream().noneMatch(SnapshotsServiceUtils::isWritingToRepository)) {
                changed = true;
                SnapshotDeletionsInProgress.Entry newEntry = entry.started();
                readyDeletions.add(newEntry);
                newDeletes.add(newEntry);
                continue;
            }
            newDeletes.add(entry);
        }
        return Tuple.tuple(changed ? ClusterState.builder(currentState).putCustom("snapshot_deletions", SnapshotDeletionsInProgress.of(newDeletes)).build() : currentState, readyDeletions);
    }

    public static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot, FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations) {
        SnapshotsInProgress inProgressSnapshots = SnapshotsInProgress.get(state);
        ClusterState result = state;
        int indexOfEntry = -1;
        ProjectId projectId = snapshot.getProjectId();
        String repository = snapshot.getRepository();
        List<SnapshotsInProgress.Entry> entryList = inProgressSnapshots.forRepo(projectId, repository);
        for (int i = 0; i < entryList.size(); ++i) {
            SnapshotsInProgress.Entry entry = entryList.get(i);
            if (!entry.snapshot().equals(snapshot)) continue;
            indexOfEntry = i;
            break;
        }
        if (indexOfEntry >= 0) {
            int i;
            ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(entryList.size() - 1);
            SnapshotsInProgress.Entry removedEntry = entryList.get(indexOfEntry);
            for (i = 0; i < indexOfEntry; ++i) {
                RepositoryShardId repositoryShardId;
                SnapshotsInProgress.ShardSnapshotStatus shardState;
                ImmutableOpenMap.Builder<Writeable, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments;
                SnapshotsInProgress.Entry previousEntry = entryList.get(i);
                if (removedEntry.isClone()) {
                    if (previousEntry.isClone()) {
                        updatedShardAssignments = null;
                        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                            shardState = finishedShardEntry.getValue();
                            if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS) continue;
                            updatedShardAssignments = SnapshotsServiceUtils.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, finishedShardEntry.getKey(), previousEntry.shardSnapshotStatusByRepoShardId());
                        }
                        SnapshotsServiceUtils.addCloneEntry(updatedEntries, previousEntry, updatedShardAssignments);
                        continue;
                    }
                    updatedShardAssignments = null;
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        shardState = finishedShardEntry.getValue();
                        repositoryShardId = finishedShardEntry.getKey();
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(repositoryShardId)) continue;
                        updatedShardAssignments = SnapshotsServiceUtils.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId(repositoryShardId), previousEntry.shards());
                    }
                    SnapshotsServiceUtils.addSnapshotEntry(updatedEntries, previousEntry, updatedShardAssignments);
                    continue;
                }
                if (previousEntry.isClone()) {
                    updatedShardAssignments = null;
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        shardState = finishedShardEntry.getValue();
                        repositoryShardId = finishedShardEntry.getKey();
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(repositoryShardId) || !updatedShardGenerations.hasShardGen(finishedShardEntry.getKey())) continue;
                        updatedShardAssignments = SnapshotsServiceUtils.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, repositoryShardId, previousEntry.shardSnapshotStatusByRepoShardId());
                    }
                    SnapshotsServiceUtils.addCloneEntry(updatedEntries, previousEntry, updatedShardAssignments);
                    continue;
                }
                updatedShardAssignments = null;
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    shardState = finishedShardEntry.getValue();
                    if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(finishedShardEntry.getKey()) || !updatedShardGenerations.hasShardGen(finishedShardEntry.getKey())) continue;
                    updatedShardAssignments = SnapshotsServiceUtils.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId(finishedShardEntry.getKey()), previousEntry.shards());
                }
                SnapshotsServiceUtils.addSnapshotEntry(updatedEntries, previousEntry, updatedShardAssignments);
            }
            for (i = indexOfEntry + 1; i < entryList.size(); ++i) {
                updatedEntries.add(entryList.get(i));
            }
            result = ClusterState.builder(state).putCustom("snapshots", inProgressSnapshots.createCopyWithUpdatedEntriesForRepo(projectId, repository, updatedEntries)).build();
        }
        return SnapshotsServiceUtils.readyDeletions(result, projectId).v1();
    }

    public static void addSnapshotEntry(List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shards());
            updatedStatus.putAllFromMap(updatedShardAssignments.build());
            entries.add(entryToUpdate.withShardStates(updatedStatus.build()));
        }
    }

    public static void addCloneEntry(List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shardSnapshotStatusByRepoShardId());
            updatedStatus.putAllFromMap(updatedShardAssignments.build());
            entries.add(entryToUpdate.withClones(updatedStatus.build()));
        }
    }

    @Nullable
    public static <T> ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> maybeAddUpdatedAssignment(@Nullable ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments, SnapshotsInProgress.ShardSnapshotStatus finishedShardState, T shardId, Map<T, SnapshotsInProgress.ShardSnapshotStatus> statesToUpdate) {
        ShardGeneration newGeneration = finishedShardState.generation();
        SnapshotsInProgress.ShardSnapshotStatus stateToUpdate = statesToUpdate.get(shardId);
        if (stateToUpdate != null && stateToUpdate.state() == SnapshotsInProgress.ShardState.SUCCESS && !Objects.equals(newGeneration, stateToUpdate.generation())) {
            if (updatedShardAssignments == null) {
                updatedShardAssignments = ImmutableOpenMap.builder();
            }
            updatedShardAssignments.put(shardId, stateToUpdate.withUpdatedGeneration(newGeneration));
        }
        return updatedShardAssignments;
    }

    @Nullable
    public static SnapshotDeletionsInProgress deletionsWithoutSnapshots(SnapshotDeletionsInProgress deletions, Collection<SnapshotId> snapshotIds, ProjectId projectId, String repository) {
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(deletions.getEntries().size());
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (entry.projectId().equals(projectId) && entry.repository().equals(repository)) {
                ArrayList<SnapshotId> updatedSnapshotIds = new ArrayList<SnapshotId>(entry.snapshots());
                if (updatedSnapshotIds.removeAll(snapshotIds)) {
                    changed = true;
                    updatedEntries.add(entry.withSnapshots(updatedSnapshotIds));
                    continue;
                }
                updatedEntries.add(entry);
                continue;
            }
            updatedEntries.add(entry);
        }
        return changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
    }

    public static IndexVersion minCompatibleVersion(IndexVersion minNodeVersion, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        IndexVersion minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds.stream().filter(excluded == null ? Predicates.always() : Predicate.not(excluded::contains)).toList()) {
            IndexVersion known = repositoryData.getVersion(snapshotId);
            if (known == null) {
                assert (repositoryData.shardGenerations().totalShards() == 0) : "Saw shard generations [" + String.valueOf(repositoryData.shardGenerations()) + "] but did not have versions tracked for snapshot [" + String.valueOf(snapshotId) + "]";
                return SnapshotsService.OLD_SNAPSHOT_FORMAT;
            }
            minCompatVersion = IndexVersion.min(minCompatVersion, known);
        }
        return minCompatVersion;
    }

    public static ClusterState updateWithSnapshots(ClusterState state, @Nullable SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress snapshotDeletionsInProgress) {
        if (snapshotsInProgress == null && snapshotDeletionsInProgress == null) {
            return state;
        }
        ClusterState.Builder builder = ClusterState.builder(state);
        if (snapshotsInProgress != null) {
            builder.putCustom("snapshots", snapshotsInProgress);
        }
        if (snapshotDeletionsInProgress != null) {
            builder.putCustom("snapshot_deletions", snapshotDeletionsInProgress);
        }
        return builder.build();
    }

    public static <T> void failListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, Exception failure) {
        if (listeners != null) {
            try {
                ActionListener.onFailure(listeners, failure);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    public static <T> void completeListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, T result) {
        if (listeners != null) {
            try {
                ActionListener.onResponse(listeners, result);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    public static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress, ProjectState currentState, Collection<IndexId> indices, boolean useShardGenerations, RepositoryData repositoryData, String repoName) {
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(currentState.projectId(), repoName));
        boolean readyToExecute = !deletionsInProgress.hasExecutingDeletion(currentState.projectId(), repoName);
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = currentState.metadata().index(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                continue;
            }
            IndexRoutingTable indexRoutingTable = currentState.routingTable().index(indexName);
            assert (indexRoutingTable != null);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                ShardGeneration shardRepoGeneration;
                ShardId shardId = indexRoutingTable.shard(i).shardId();
                if (useShardGenerations) {
                    ShardGeneration inFlightGeneration = inFlightShardStates.generationForShard(index, shardId.id(), shardGenerations);
                    if (inFlightGeneration == null && isNewIndex) {
                        assert (shardGenerations.getShardGen(index, shardId.getId()) == null) : "Found shard generation for new index [" + String.valueOf(index) + "]";
                        shardRepoGeneration = ShardGenerations.NEW_SHARD_GEN;
                    } else {
                        shardRepoGeneration = inFlightGeneration;
                    }
                } else {
                    shardRepoGeneration = null;
                }
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = !readyToExecute || inFlightShardStates.isActive(shardId.getIndexName(), shardId.id()) ? SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED : SnapshotsServiceUtils.initShardSnapshotStatus(shardRepoGeneration, indexRoutingTable.shard(i).primaryShard(), snapshotsInProgress::isNodeIdForRemoval);
                builder.put(shardId, shardSnapshotStatus);
            }
        }
        return builder.build();
    }

    public static SnapshotsInProgress.ShardSnapshotStatus initShardSnapshotStatus(ShardGeneration shardRepoGeneration, ShardRouting primary, Predicate<String> nodeIdRemovalPredicate) {
        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, shardRepoGeneration, "primary shard is not allocated") : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration) : (nodeIdRemovalPredicate.test(primary.currentNodeId()) ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, shardRepoGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, shardRepoGeneration, "primary shard hasn't been started yet") : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration))));
        return shardSnapshotStatus;
    }

    public static Set<String> snapshottingDataStreams(ProjectState projectState, Set<String> dataStreamsToCheck) {
        Map<String, DataStream> dataStreams = projectState.metadata().dataStreams();
        return SnapshotsInProgress.get(projectState.cluster()).asStream(projectState.projectId()).filter(e -> !e.partial()).flatMap(e -> e.dataStreams().stream()).filter(ds -> dataStreams.containsKey(ds) && dataStreamsToCheck.contains(ds)).collect(Collectors.toSet());
    }

    public static Set<Index> snapshottingIndices(ProjectState projectState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (List<SnapshotsInProgress.Entry> snapshotsInRepo : SnapshotsInProgress.get(projectState.cluster()).entriesByRepo(projectState.projectId())) {
            for (SnapshotsInProgress.Entry entry : snapshotsInRepo) {
                if (entry.partial() || entry.isClone()) continue;
                for (String indexName : entry.indices().keySet()) {
                    IndexMetadata indexMetadata = projectState.metadata().index(indexName);
                    if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                    indices.add(indexMetadata.getIndex());
                }
            }
        }
        return indices;
    }

    public static Map<String, DataStreamAlias> filterDataStreamAliases(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
        return dataStreamAliases.values().stream().filter(alias -> alias.getDataStreams().stream().anyMatch(dataStreams::containsKey)).map(alias -> alias.intersect(dataStreams::containsKey)).collect(Collectors.toMap(DataStreamAlias::getName, Function.identity()));
    }

    public static void logSnapshotFailure(String operation, Snapshot snapshot, Exception e) {
        Level logLevel = SnapshotsServiceUtils.snapshotFailureLogLevel(e);
        if (logLevel == Level.INFO && !logger.isDebugEnabled()) {
            logger.info(Strings.format("%s[%s] failed to %s snapshot: %s", ProjectRepo.projectRepoString(snapshot.getProjectId(), snapshot.getRepository()), snapshot.getSnapshotId().getName(), operation, e.getMessage()));
        } else {
            logger.log(logLevel, () -> Strings.format("[%s][%s] failed to %s snapshot", snapshot.getRepository(), snapshot.getSnapshotId().getName(), operation), (Throwable)e);
        }
    }

    public static Level snapshotFailureLogLevel(Exception e) {
        if (MasterService.isPublishFailureException(e)) {
            return Level.INFO;
        }
        if (e instanceof InvalidSnapshotNameException) {
            return Level.INFO;
        }
        if (e instanceof IndexNotFoundException) {
            return Level.INFO;
        }
        if (e instanceof SnapshotException ? e.getMessage().contains(ReferenceDocs.UNASSIGNED_SHARDS.toString()) : e instanceof IllegalArgumentException) {
            return Level.INFO;
        }
        return Level.WARN;
    }
}

