/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExactKnnQueryBuilder
extends AbstractQueryBuilder<ExactKnnQueryBuilder> {
    public static final String NAME = "exact_knn";
    private final String field;
    private final VectorData query;
    private final Float vectorSimilarity;

    public ExactKnnQueryBuilder(VectorData query, String field, Float vectorSimilarity) {
        this.query = query;
        this.field = field;
        this.vectorSimilarity = vectorSimilarity;
    }

    public ExactKnnQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.query = in.readOptionalWriteable(VectorData::new);
        this.field = in.readString();
        this.vectorSimilarity = in.readOptionalFloat();
    }

    String getField() {
        return this.field;
    }

    VectorData getQuery() {
        return this.query;
    }

    Float vectorSimilarity() {
        return this.vectorSimilarity;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.query);
        out.writeString(this.field);
        out.writeOptionalFloat(this.vectorSimilarity);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field("query", this.query);
        builder.field("field", this.field);
        if (this.vectorSimilarity != null) {
            builder.field("similarity", this.vectorSimilarity);
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        MappedFieldType fieldType = context.getFieldType(this.field);
        if (fieldType == null) {
            throw new IllegalArgumentException("field [" + this.field + "] does not exist in the mapping");
        }
        if (!(fieldType instanceof DenseVectorFieldMapper.DenseVectorFieldType)) {
            throw new IllegalArgumentException("[exact_knn] queries are only supported on [dense_vector] fields");
        }
        DenseVectorFieldMapper.DenseVectorFieldType vectorFieldType = (DenseVectorFieldMapper.DenseVectorFieldType)fieldType;
        return vectorFieldType.createExactKnnQuery(this.query, this.vectorSimilarity);
    }

    @Override
    protected boolean doEquals(ExactKnnQueryBuilder other) {
        return this.field.equals(other.field) && Objects.equals(this.query, other.query) && Objects.equals(this.vectorSimilarity, other.vectorSimilarity);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, Objects.hashCode(this.query), this.vectorSimilarity);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }
}

