/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public abstract sealed class ESAcceptDocs
extends AcceptDocs {
    public abstract int approximateCost() throws IOException;

    public abstract Optional<BitSet> getBitSet() throws IOException;

    private static BitSet createBitSet(DocIdSetIterator iterator, final Bits liveDocs, int maxDoc) throws IOException {
        if (liveDocs == null && iterator instanceof BitSetIterator) {
            BitSetIterator bitSetIterator = (BitSetIterator)iterator;
            return bitSetIterator.getBitSet();
        }
        int threshold = maxDoc >> 7;
        if (iterator.cost() >= (long)threshold) {
            FixedBitSet bitSet = new FixedBitSet(maxDoc);
            bitSet.or(iterator);
            if (liveDocs != null) {
                liveDocs.applyMask(bitSet, 0);
            }
            return bitSet;
        }
        return BitSet.of(liveDocs == null ? iterator : new FilteredDocIdSetIterator(iterator){

            @Override
            protected boolean match(int doc) {
                return liveDocs.get(doc);
            }
        }, maxDoc);
    }

    public static final class ScorerSupplierAcceptDocs
    extends ESAcceptDocs {
        private final ScorerSupplier scorerSupplier;
        private BitSet acceptBitSet;
        private final Bits liveDocs;
        private final int maxDoc;
        private int cardinality = -1;

        ScorerSupplierAcceptDocs(ScorerSupplier scorerSupplier, Bits liveDocs, int maxDoc) {
            this.scorerSupplier = scorerSupplier;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
        }

        private void createBitSetIfNecessary() throws IOException {
            if (this.acceptBitSet == null) {
                this.acceptBitSet = ESAcceptDocs.createBitSet(this.scorerSupplier.get(Integer.MAX_VALUE).iterator(), this.liveDocs, this.maxDoc);
            }
        }

        @Override
        public Bits bits() throws IOException {
            this.createBitSetIfNecessary();
            return this.acceptBitSet;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            if (this.acceptBitSet != null) {
                return new BitSetIterator(this.acceptBitSet, this.cardinality);
            }
            return this.liveDocs == null ? this.scorerSupplier.get(Integer.MAX_VALUE).iterator() : new FilteredDocIdSetIterator(this.scorerSupplier.get(Integer.MAX_VALUE).iterator()){

                @Override
                protected boolean match(int doc) {
                    return liveDocs.get(doc);
                }
            };
        }

        @Override
        public int cost() throws IOException {
            this.createBitSetIfNecessary();
            if (this.cardinality == -1) {
                this.cardinality = this.acceptBitSet.cardinality();
            }
            return this.cardinality;
        }

        @Override
        public int approximateCost() throws IOException {
            if (this.acceptBitSet != null) {
                return this.cardinality != -1 ? this.cardinality : this.acceptBitSet.approximateCardinality();
            }
            return Math.toIntExact(this.scorerSupplier.cost());
        }

        @Override
        public Optional<BitSet> getBitSet() throws IOException {
            this.createBitSetIfNecessary();
            return Optional.of(this.acceptBitSet);
        }
    }

    public static final class BitsAcceptDocs
    extends ESAcceptDocs {
        private final Bits bits;
        private final BitSet bitSetRef;
        private final int maxDoc;
        private final int approximateCost;

        BitsAcceptDocs(Bits bits, int maxDoc) {
            if (bits != null && bits.length() != maxDoc) {
                throw new IllegalArgumentException("Bits length = " + bits.length() + " != maxDoc = " + maxDoc);
            }
            this.bits = Objects.requireNonNull(bits);
            if (bits instanceof BitSet) {
                BitSet bitSet = (BitSet)bits;
                this.maxDoc = Objects.requireNonNull(bitSet).cardinality();
                this.approximateCost = Objects.requireNonNull(bitSet).approximateCardinality();
                this.bitSetRef = bitSet;
            } else {
                this.maxDoc = maxDoc;
                this.approximateCost = maxDoc;
                this.bitSetRef = null;
            }
        }

        @Override
        public Bits bits() {
            return this.bits;
        }

        @Override
        public DocIdSetIterator iterator() {
            if (this.bitSetRef != null) {
                return new BitSetIterator(this.bitSetRef, this.maxDoc);
            }
            return new FilteredDocIdSetIterator(DocIdSetIterator.all(this.maxDoc)){

                @Override
                protected boolean match(int doc) {
                    return bits.get(doc);
                }
            };
        }

        @Override
        public int cost() {
            return this.maxDoc;
        }

        @Override
        public int approximateCost() {
            return this.approximateCost;
        }

        @Override
        public Optional<BitSet> getBitSet() {
            if (this.bits == null) {
                return null;
            }
            return Optional.ofNullable(this.bitSetRef);
        }
    }

    public static final class ESAcceptDocsAll
    extends ESAcceptDocs {
        public static final ESAcceptDocsAll INSTANCE = new ESAcceptDocsAll();

        private ESAcceptDocsAll() {
        }

        @Override
        public int approximateCost() throws IOException {
            return 0;
        }

        @Override
        public Optional<BitSet> getBitSet() throws IOException {
            return null;
        }

        @Override
        public Bits bits() throws IOException {
            return null;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            return null;
        }

        @Override
        public int cost() throws IOException {
            return 0;
        }
    }
}

