/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.HnswQueueSaturationCollector;
import org.apache.lucene.search.KnnCollector;

public class AdaptiveHnswQueueSaturationCollector
extends HnswQueueSaturationCollector {
    private static final float DEFAULT_DISCOVERY_RATE_SMOOTHING = 0.9f;
    private static final float DEFAULT_THRESHOLD_LOOSENESS = 0.01f;
    private static final float DEFAULT_PATIENCE_SCALING = 10.0f;
    private final float discoveryRateSmoothing;
    private final float thresholdLooseness;
    private final float patienceScaling;
    private boolean patienceFinished = false;
    private int previousQueueSize = 0;
    private int currentQueueSize = 0;
    private float smoothedDiscoveryRate = 0.0f;
    private float mean = 0.0f;
    private float m2 = 0.0f;
    private int samples = 0;
    private int steps = 0;
    private int saturatedCount = 0;

    private AdaptiveHnswQueueSaturationCollector(KnnCollector delegate, float discoveryRateSmoothing, float thresholdLooseness, float patienceScaling) {
        super(delegate, 0.0, 0);
        this.discoveryRateSmoothing = discoveryRateSmoothing;
        this.thresholdLooseness = thresholdLooseness;
        this.patienceScaling = patienceScaling;
    }

    public AdaptiveHnswQueueSaturationCollector(KnnCollector delegate) {
        this(delegate, 0.9f, 0.01f, 10.0f);
    }

    @Override
    public boolean earlyTerminated() {
        return this.patienceFinished || super.earlyTerminated();
    }

    @Override
    public boolean collect(int docId, float similarity) {
        boolean collected = super.collect(docId, similarity);
        if (collected) {
            ++this.currentQueueSize;
        }
        ++this.steps;
        return collected;
    }

    @Override
    public void nextCandidate() {
        float discoveryRate = (float)((double)(this.currentQueueSize - this.previousQueueSize) / (1.0E-9 + (double)(this.steps * this.k())));
        float rate = Math.max(0.0f, discoveryRate);
        this.smoothedDiscoveryRate = this.discoveryRateSmoothing * rate + (1.0f - this.discoveryRateSmoothing) * this.smoothedDiscoveryRate;
        ++this.samples;
        float deltaMean = this.smoothedDiscoveryRate - this.mean;
        this.mean += deltaMean / (float)this.samples;
        this.m2 += deltaMean * (this.smoothedDiscoveryRate - this.mean);
        double variance = this.samples > 1 ? (double)(this.m2 / (float)(this.samples - 1)) : 0.0;
        double stddev = Math.sqrt(variance);
        double adaptiveThreshold = (double)this.mean + (double)this.thresholdLooseness * stddev;
        double adaptivePatience = (double)this.patienceScaling / (1.0 + stddev);
        this.saturatedCount = (double)this.smoothedDiscoveryRate < adaptiveThreshold ? ++this.saturatedCount : 0;
        if ((double)this.saturatedCount > adaptivePatience) {
            this.patienceFinished = true;
        }
        this.previousQueueSize = this.currentQueueSize;
        this.steps = 0;
    }
}

