/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class RescorerRetrieverBuilder
extends CompoundRetrieverBuilder<RescorerRetrieverBuilder> {
    public static final String NAME = "rescorer";
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ConstructingObjectParser<RescorerRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("rescorer", args -> new RescorerRetrieverBuilder((RetrieverBuilder)args[0], (List)args[1]));
    private final List<RescorerBuilder<?>> rescorers;

    public static RescorerRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        try {
            return PARSER.apply(parser, context);
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), e, new Object[0]);
        }
    }

    public RescorerRetrieverBuilder(RetrieverBuilder retriever, List<RescorerBuilder<?>> rescorers) {
        super(List.of(CompoundRetrieverBuilder.RetrieverSource.from(retriever)), RescorerRetrieverBuilder.extractMinWindowSize(rescorers));
        if (rescorers.isEmpty()) {
            throw new IllegalArgumentException("Missing rescore definition");
        }
        this.rescorers = rescorers;
    }

    private RescorerRetrieverBuilder(CompoundRetrieverBuilder.RetrieverSource retriever, List<RescorerBuilder<?>> rescorers) {
        super(List.of(retriever), RescorerRetrieverBuilder.extractMinWindowSize(rescorers));
        this.rescorers = rescorers;
    }

    private static int extractMinWindowSize(List<RescorerBuilder<?>> rescorers) {
        int windowSize = Integer.MAX_VALUE;
        for (RescorerBuilder<?> rescore : rescorers) {
            windowSize = Math.min(rescore.windowSize() == null ? 10 : rescore.windowSize(), windowSize);
        }
        return windowSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ParseField getRankWindowSizeField() {
        return RescorerBuilder.WINDOW_SIZE_FIELD;
    }

    @Override
    protected SearchSourceBuilder finalizeSourceBuilder(SearchSourceBuilder source) {
        for (RescorerBuilder<?> rescorer : this.rescorers) {
            source.addRescorer(rescorer);
        }
        return source;
    }

    @Override
    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName(), ((CompoundRetrieverBuilder.RetrieverSource)this.innerRetrievers.getFirst()).retriever());
        builder.startArray(SearchSourceBuilder.RESCORE_FIELD.getPreferredName());
        for (RescorerBuilder<?> rescorer : this.rescorers) {
            rescorer.toXContent(builder, params);
        }
        builder.endArray();
    }

    @Override
    protected RescorerRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newChildRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        RescorerRetrieverBuilder newInstance = new RescorerRetrieverBuilder(newChildRetrievers.get(0), this.rescorers);
        newInstance.preFilterQueryBuilders = newPreFilterQueryBuilders;
        newInstance.retrieverName = this.retrieverName;
        return newInstance;
    }

    @Override
    protected RankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        assert (rankResults.size() == 1);
        ScoreDoc[] scoreDocs = rankResults.getFirst();
        RankDoc[] rankDocs = new RankDoc[scoreDocs.length];
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            rankDocs[i] = new RankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
            rankDocs[i].rank = i + 1;
        }
        return rankDocs;
    }

    @Override
    public boolean doEquals(Object o) {
        RescorerRetrieverBuilder that = (RescorerRetrieverBuilder)o;
        return super.doEquals(o) && Objects.equals(this.rescorers, that.rescorers);
    }

    @Override
    public int doHashCode() {
        return Objects.hash(super.doHashCode(), this.rescorers);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (parser, context, n) -> {
            RetrieverBuilder innerRetriever = parser.namedObject(RetrieverBuilder.class, n, context);
            context.trackRetrieverUsage(innerRetriever);
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                ArrayList rescorers = new ArrayList();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    rescorers.add(RescorerBuilder.parseFromXContent(parser, name -> context.trackRescorerUsage((String)name)));
                }
                return rescorers;
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                return List.of(RescorerBuilder.parseFromXContent(parser, name -> context.trackRescorerUsage((String)name)));
            }
            throw new IllegalArgumentException("Unknown format for [rescorer.rescore], expects an object or an array of objects, got: " + String.valueOf((Object)parser.currentToken()));
        }, SearchSourceBuilder.RESCORE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        RetrieverBuilder.declareBaseParserFields(PARSER);
    }
}

