/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class RankDoc
extends ScoreDoc
implements VersionedNamedWriteable,
ToXContentFragment,
Comparable<RankDoc> {
    public static final String NAME = "rank_doc";
    public static final int NO_RANK = -1;
    public int rank = -1;

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public final int compareTo(RankDoc other) {
        if (this.score != other.score) {
            return this.score < other.score ? 1 : -1;
        }
        if (this.shardIndex != other.shardIndex) {
            return this.shardIndex < other.shardIndex ? -1 : 1;
        }
        return this.doc < other.doc ? -1 : 1;
    }

    public RankDoc(int doc, float score, int shardIndex) {
        super(doc, score, shardIndex);
    }

    public RankDoc(StreamInput in) throws IOException {
        super(in.readVInt(), in.readFloat(), in.readVInt());
        this.rank = in.readVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.doc);
        out.writeFloat(this.score);
        out.writeVInt(this.shardIndex);
        out.writeVInt(this.rank);
        this.doWriteTo(out);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
    }

    public Explanation explain(Explanation[] sourceExplanations, String[] queryNames) {
        return Explanation.match((Number)this.rank, "doc [" + this.doc + "] with an original score of [" + this.score + "] is at rank [" + this.rank + "] from the following source queries.", sourceExplanations);
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("_rank", this.rank);
        builder.field("_doc", this.doc);
        builder.field("_shard", this.shardIndex);
        builder.field("_score", this.score);
        this.doToXContent(builder, params);
        return builder;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankDoc rd = (RankDoc)o;
        return this.doc == rd.doc && this.score == rd.score && this.shardIndex == rd.shardIndex && this.rank == rd.rank && this.doEquals(rd);
    }

    protected boolean doEquals(RankDoc rd) {
        return true;
    }

    public final int hashCode() {
        return Objects.hash(this.doc, Float.valueOf(this.score), this.shardIndex, this.doHashCode());
    }

    protected int doHashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "RankDoc{_rank=" + this.rank + ", _doc=" + this.doc + ", _shard=" + this.shardIndex + ", _score=" + this.score + "}";
    }

    public record RankKey(int doc, int shardIndex) {
    }
}

