/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;
    private final Timer shallowAdvanceTimer;
    private final Timer computeMaxScoreTimer;
    private final Timer setMinCompetitiveScoreTimer;

    ProfileScorer(Scorer scorer, QueryProfileBreakdown profile) {
        this.scorer = scorer;
        this.scoreTimer = profile.getNewTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getNewTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getNewTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getNewTimer(QueryTimingType.MATCH);
        this.shallowAdvanceTimer = profile.getNewTimer(QueryTimingType.SHALLOW_ADVANCE);
        this.computeMaxScoreTimer = profile.getNewTimer(QueryTimingType.COMPUTE_MAX_SCORE);
        this.setMinCompetitiveScoreTimer = profile.getNewTimer(QueryTimingType.SET_MIN_COMPETITIVE_SCORE);
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    @Override
    public DocIdSetIterator iterator() {
        return new TimedDocIdSetIterator(this.scorer.iterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        return new TwoPhaseIterator(new TimedDocIdSetIterator(in.approximation())){

            @Override
            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            @Override
            public float matchCost() {
                return in.matchCost();
            }
        };
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        this.shallowAdvanceTimer.start();
        try {
            int n = this.scorer.advanceShallow(target);
            return n;
        }
        finally {
            this.shallowAdvanceTimer.stop();
        }
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        this.computeMaxScoreTimer.start();
        try {
            float f = this.scorer.getMaxScore(upTo);
            return f;
        }
        finally {
            this.computeMaxScoreTimer.stop();
        }
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.setMinCompetitiveScoreTimer.start();
        try {
            this.scorer.setMinCompetitiveScore(minScore);
        }
        finally {
            this.setMinCompetitiveScoreTimer.stop();
        }
    }

    private class TimedDocIdSetIterator
    extends DocIdSetIterator {
        private final DocIdSetIterator in;

        TimedDocIdSetIterator(DocIdSetIterator in) {
            this.in = in;
        }

        @Override
        public int advance(int target) throws IOException {
            ProfileScorer.this.advanceTimer.start();
            try {
                int n = this.in.advance(target);
                return n;
            }
            finally {
                ProfileScorer.this.advanceTimer.stop();
            }
        }

        @Override
        public int nextDoc() throws IOException {
            ProfileScorer.this.nextDocTimer.start();
            try {
                int n = this.in.nextDoc();
                return n;
            }
            finally {
                ProfileScorer.this.nextDocTimer.stop();
            }
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public long cost() {
            return this.in.cost();
        }
    }
}

