/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.crossproject.ProjectRoutingInfo;

public record TargetProjects(@Nullable ProjectRoutingInfo originProject, @Nullable List<ProjectRoutingInfo> linkedProjects) {
    public static final TargetProjects EMPTY = new TargetProjects(null, List.of());
    public static final TargetProjects LOCAL_ONLY_FOR_CPS_DISABLED = new TargetProjects(null, null);

    public TargetProjects(ProjectRoutingInfo originProject) {
        this(originProject, List.of());
    }

    @Nullable
    public String originProjectAlias() {
        return this.originProject != null ? this.originProject.projectAlias() : null;
    }

    public Set<String> allProjectAliases() {
        return this.allProjects().map(ProjectRoutingInfo::projectAlias).collect(Collectors.toUnmodifiableSet());
    }

    public Stream<ProjectRoutingInfo> allProjects() {
        return Stream.concat(this.originProject != null ? Stream.of(this.originProject) : Stream.empty(), this.linkedProjects != null ? this.linkedProjects.stream() : Stream.empty());
    }

    public boolean crossProject() {
        return this.originProject != null || this.linkedProjects != null && !this.linkedProjects.isEmpty();
    }

    public boolean isEmpty() {
        return this.originProject == null && this.linkedProjects != null && this.linkedProjects.isEmpty();
    }

    static {
        assert (EMPTY.isEmpty());
        assert (!EMPTY.crossProject());
        assert (!LOCAL_ONLY_FOR_CPS_DISABLED.isEmpty());
        assert (!LOCAL_ONLY_FOR_CPS_DISABLED.crossProject());
    }
}

