/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.crossproject.NoMatchingProjectException;
import org.elasticsearch.search.crossproject.ProjectRoutingInfo;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;

public class CrossProjectIndexExpressionsRewriter {
    public static TransportVersion NO_MATCHING_PROJECT_EXCEPTION_VERSION = TransportVersion.fromName("no_matching_project_exception");
    private static final Logger logger = LogManager.getLogger(CrossProjectIndexExpressionsRewriter.class);
    private static final String[] MATCH_ALL = new String[]{"_all"};
    private static final String EXCLUSION = "-";
    private static final String DATE_MATH = "<";

    public static Map<String, IndexRewriteResult> rewriteIndexExpressions(ProjectRoutingInfo originProject, List<ProjectRoutingInfo> linkedProjects, String[] originalIndices) {
        String[] indices = originalIndices == null || originalIndices.length == 0 ? MATCH_ALL : originalIndices;
        assert (!IndexNameExpressionResolver.isNoneExpression(indices)) : "expression list is *,-* which effectively means a request that requests no indices";
        Set<String> allProjectAliases = CrossProjectIndexExpressionsRewriter.getAllProjectAliases(originProject, linkedProjects);
        String originProjectAlias = originProject != null ? originProject.projectAlias() : null;
        LinkedHashMap<String, IndexRewriteResult> canonicalExpressionsMap = new LinkedHashMap<String, IndexRewriteResult>(indices.length);
        for (String indexExpression : indices) {
            if (canonicalExpressionsMap.containsKey(indexExpression)) continue;
            canonicalExpressionsMap.put(indexExpression, CrossProjectIndexExpressionsRewriter.rewriteIndexExpression(indexExpression, originProjectAlias, allProjectAliases, null));
        }
        return canonicalExpressionsMap;
    }

    public static IndexRewriteResult rewriteIndexExpression(String indexExpression, @Nullable String originProjectAlias, Set<String> allProjectAliases, @Nullable String projectRouting) {
        IndexRewriteResult rewrittenExpression;
        CrossProjectIndexExpressionsRewriter.maybeThrowOnUnsupportedResource(indexExpression);
        if (originProjectAlias == null && allProjectAliases.isEmpty()) {
            assert (projectRouting != null);
            throw new NoMatchingProjectException("no matching project after applying project routing [" + projectRouting + "]");
        }
        boolean isQualified = RemoteClusterAware.isRemoteIndexName(indexExpression);
        if (isQualified) {
            rewrittenExpression = CrossProjectIndexExpressionsRewriter.rewriteQualifiedExpression(indexExpression, originProjectAlias, allProjectAliases, projectRouting);
            logger.debug("Rewrote qualified expression [{}] to [{}]", indexExpression, rewrittenExpression);
        } else {
            rewrittenExpression = CrossProjectIndexExpressionsRewriter.rewriteUnqualifiedExpression(indexExpression, originProjectAlias, allProjectAliases);
            logger.debug("Rewrote unqualified expression [{}] to [{}]", indexExpression, rewrittenExpression);
        }
        assert (!rewrittenExpression.isEmpty()) : "rewritten index expression must not be empty";
        return rewrittenExpression;
    }

    private static Set<String> getAllProjectAliases(@Nullable ProjectRoutingInfo originProject, List<ProjectRoutingInfo> linkedProjects) {
        assert (originProject != null || !linkedProjects.isEmpty()) : "either origin project or linked projects must be in project target set";
        Set allProjectAliases = linkedProjects.stream().map(ProjectRoutingInfo::projectAlias).collect(Collectors.toSet());
        if (originProject != null) {
            allProjectAliases.add(originProject.projectAlias());
        }
        return Collections.unmodifiableSet(allProjectAliases);
    }

    private static IndexRewriteResult rewriteUnqualifiedExpression(String indexExpression, @Nullable String originAlias, Set<String> allProjectAliases) {
        String localExpression = null;
        LinkedHashSet<String> rewrittenExpressions = new LinkedHashSet<String>();
        if (originAlias != null) {
            localExpression = indexExpression;
        }
        for (String targetProjectAlias : allProjectAliases) {
            if (targetProjectAlias.equals(originAlias)) continue;
            rewrittenExpressions.add(RemoteClusterAware.buildRemoteIndexName(targetProjectAlias, indexExpression));
        }
        return new IndexRewriteResult(localExpression, rewrittenExpressions);
    }

    private static IndexRewriteResult rewriteQualifiedExpression(String resource, @Nullable String originProjectAlias, Set<String> allProjectAliases, @Nullable String projectRouting) {
        String[] splitResource = RemoteClusterAware.splitIndexName(resource);
        assert (splitResource.length == 2) : "Expected two strings (project and indexExpression) for a qualified resource [" + resource + "], but found [" + splitResource.length + "]";
        String requestedProjectAlias = splitResource[0];
        assert (requestedProjectAlias != null) : "Expected a project alias for a qualified resource but was null";
        String indexExpression = splitResource[1];
        CrossProjectIndexExpressionsRewriter.maybeThrowOnUnsupportedResource(indexExpression);
        if (originProjectAlias != null && "_origin".equals(requestedProjectAlias)) {
            return new IndexRewriteResult(indexExpression);
        }
        if (originProjectAlias == null && "_origin".equals(requestedProjectAlias)) {
            throw new NoMatchingProjectException(requestedProjectAlias, projectRouting);
        }
        try {
            List<String> allProjectsMatchingAlias = ClusterNameExpressionResolver.resolveClusterNames(allProjectAliases, requestedProjectAlias);
            if (allProjectsMatchingAlias.isEmpty()) {
                throw new NoMatchingProjectException(requestedProjectAlias, projectRouting);
            }
            String localExpression = null;
            LinkedHashSet<String> resourcesMatchingLinkedProjectAliases = new LinkedHashSet<String>();
            for (String project : allProjectsMatchingAlias) {
                if (project.equals(originProjectAlias)) {
                    localExpression = indexExpression;
                    continue;
                }
                resourcesMatchingLinkedProjectAliases.add(RemoteClusterAware.buildRemoteIndexName(project, indexExpression));
            }
            return new IndexRewriteResult(localExpression, resourcesMatchingLinkedProjectAliases);
        }
        catch (NoSuchRemoteClusterException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new NoMatchingProjectException(requestedProjectAlias, projectRouting);
        }
    }

    private static void maybeThrowOnUnsupportedResource(String resource) {
        if (resource.startsWith(EXCLUSION)) {
            throw new IllegalArgumentException("Exclusions are not currently supported but was found in the expression [" + resource + "]");
        }
    }

    public record IndexRewriteResult(@Nullable String localExpression, Set<String> remoteExpressions) {
        public IndexRewriteResult(String localExpression) {
            this(localExpression, Set.of());
        }

        public boolean isEmpty() {
            return this.localExpression == null && this.remoteExpressions.isEmpty();
        }
    }
}

