/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregator;
import org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.NonCollectingSingleMetricAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public class MedianAbsoluteDeviationAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final MedianAbsoluteDeviationAggregatorSupplier aggregatorSupplier;
    private final double compression;
    private final TDigestExecutionHint executionHint;

    MedianAbsoluteDeviationAggregatorFactory(String name, ValuesSourceConfig config, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, double compression, TDigestExecutionHint executionHint, MedianAbsoluteDeviationAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.compression = compression;
        this.executionHint = executionHint;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(MedianAbsoluteDeviationAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, TimeSeriesValuesSourceType.COUNTER), MedianAbsoluteDeviationAggregator::new, true);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        InternalMedianAbsoluteDeviation empty = InternalMedianAbsoluteDeviation.empty(this.name, metadata, this.config.format(), this.compression, this.executionHint);
        return new NonCollectingSingleMetricAggregator(this.name, this.context, parent, empty, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config, this.config.format(), this.context, parent, metadata, this.compression, this.executionHint);
    }
}

