/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.InternalBounds;

public class InternalGeoBounds
extends InternalBounds<GeoPoint>
implements GeoBounds {
    public final double posLeft;
    public final double posRight;
    public final double negLeft;
    public final double negRight;
    public final boolean wrapLongitude;

    public InternalGeoBounds(String name, double top, double bottom, double posLeft, double posRight, double negLeft, double negRight, boolean wrapLongitude, Map<String, Object> metadata) {
        super(name, top, bottom, metadata);
        this.posLeft = posLeft;
        this.posRight = posRight;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.wrapLongitude = wrapLongitude;
    }

    public InternalGeoBounds(StreamInput in) throws IOException {
        super(in);
        this.posLeft = in.readDouble();
        this.posRight = in.readDouble();
        this.negLeft = in.readDouble();
        this.negRight = in.readDouble();
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.posLeft);
        out.writeDouble(this.posRight);
        out.writeDouble(this.negLeft);
        out.writeDouble(this.negRight);
        out.writeBoolean(this.wrapLongitude);
    }

    public static InternalGeoBounds empty(String name, boolean wrapLongitude, Map<String, Object> metadata) {
        return new InternalGeoBounds(name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, wrapLongitude, metadata);
    }

    @Override
    public String getWriteableName() {
        return "geo_bounds";
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            double posLeft = Double.POSITIVE_INFINITY;
            double posRight = Double.NEGATIVE_INFINITY;
            double negLeft = Double.POSITIVE_INFINITY;
            double negRight = Double.NEGATIVE_INFINITY;

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalGeoBounds bounds = (InternalGeoBounds)aggregation;
                if (bounds.top > this.top) {
                    this.top = bounds.top;
                }
                if (bounds.bottom < this.bottom) {
                    this.bottom = bounds.bottom;
                }
                if (bounds.posLeft < this.posLeft) {
                    this.posLeft = bounds.posLeft;
                }
                if (bounds.posRight > this.posRight) {
                    this.posRight = bounds.posRight;
                }
                if (bounds.negLeft < this.negLeft) {
                    this.negLeft = bounds.negLeft;
                }
                if (bounds.negRight > this.negRight) {
                    this.negRight = bounds.negRight;
                }
            }

            @Override
            public InternalAggregation get() {
                return new InternalGeoBounds(InternalGeoBounds.this.name, this.top, this.bottom, this.posLeft, this.posRight, this.negLeft, this.negRight, InternalGeoBounds.this.wrapLongitude, InternalGeoBounds.this.getMetadata());
            }
        };
    }

    @Override
    protected Object selectCoordinate(String coordinateString, GeoPoint cornerPoint) {
        return switch (coordinateString) {
            case "lat" -> cornerPoint.lat();
            case "lon" -> cornerPoint.lon();
            default -> throw new IllegalArgumentException("Found unknown path element [" + coordinateString + "] in [" + this.getName() + "]");
        };
    }

    protected GeoBoundingBox resolveBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        if (Double.isInfinite(this.posLeft)) {
            return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.negRight));
        }
        if (Double.isInfinite(this.negLeft)) {
            return new GeoBoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.posRight));
        }
        if (this.wrapLongitude) {
            double unwrappedWidth = this.posRight - this.negLeft;
            double wrappedWidth = 180.0 - this.posLeft - (-180.0 - this.negRight);
            if (unwrappedWidth <= wrappedWidth) {
                return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
            }
            return new GeoBoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.negRight));
        }
        return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoBounds other = (InternalGeoBounds)obj;
        return this.top == other.top && this.bottom == other.bottom && this.posLeft == other.posLeft && this.posRight == other.posRight && this.negLeft == other.negLeft && this.negRight == other.negRight && this.wrapLongitude == other.wrapLongitude;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottom, this.posLeft, this.posRight, this.negLeft, this.negRight, this.wrapLongitude);
    }
}

