/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xcontent.ParseField;

final class GeoBoundsAggregator
extends MetricsAggregator {
    static final ParseField WRAP_LONGITUDE_FIELD = new ParseField("wrap_longitude", new String[0]);
    private final ValuesSource.GeoPoint valuesSource;
    private final boolean wrapLongitude;
    DoubleArray tops;
    DoubleArray bottoms;
    DoubleArray posLefts;
    DoubleArray posRights;
    DoubleArray negLefts;
    DoubleArray negRights;

    GeoBoundsAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource();
        this.wrapLongitude = wrapLongitude;
        this.tops = this.bigArrays().newDoubleArray(1L, false);
        this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
        this.bottoms = this.bigArrays().newDoubleArray(1L, false);
        this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
        this.posLefts = this.bigArrays().newDoubleArray(1L, false);
        this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
        this.posRights = this.bigArrays().newDoubleArray(1L, false);
        this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
        this.negLefts = this.bigArrays().newDoubleArray(1L, false);
        this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
        this.negRights = this.bigArrays().newDoubleArray(1L, false);
        this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        MultiGeoPointValues values = this.valuesSource.geoPointValues(aggCtx.getLeafReaderContext());
        GeoPointValues singleton = FieldData.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final MultiGeoPointValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    GeoBoundsAggregator.this.growBucket(bucket);
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        GeoBoundsAggregator.this.addPoint(values.nextValue(), bucket);
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final GeoPointValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    GeoBoundsAggregator.this.growBucket(bucket);
                    GeoBoundsAggregator.this.addPoint(values.pointValue(), bucket);
                }
            }
        };
    }

    private void growBucket(long bucket) {
        if (bucket >= this.tops.size()) {
            long from = this.tops.size();
            this.tops = this.bigArrays().grow(this.tops, bucket + 1L);
            this.tops.fill(from, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = this.bigArrays().resize(this.bottoms, this.tops.size());
            this.bottoms.fill(from, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = this.bigArrays().resize(this.posLefts, this.tops.size());
            this.posLefts.fill(from, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = this.bigArrays().resize(this.posRights, this.tops.size());
            this.posRights.fill(from, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = this.bigArrays().resize(this.negLefts, this.tops.size());
            this.negLefts.fill(from, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = this.bigArrays().resize(this.negRights, this.tops.size());
            this.negRights.fill(from, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    private void addPoint(GeoPoint value, long bucket) {
        this.tops.set(bucket, Math.max(this.tops.get(bucket), value.lat()));
        this.bottoms.set(bucket, Math.min(this.bottoms.get(bucket), value.lat()));
        if (value.lon() >= 0.0) {
            this.posLefts.set(bucket, Math.min(this.posLefts.get(bucket), value.lon()));
            this.posRights.set(bucket, Math.max(this.posRights.get(bucket), value.lon()));
        } else {
            this.negLefts.set(bucket, Math.min(this.negLefts.get(bucket), value.lon()));
            this.negRights.set(bucket, Math.max(this.negRights.get(bucket), value.lon()));
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (owningBucketOrdinal >= this.tops.size()) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalGeoBounds.empty(this.name, this.wrapLongitude, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights);
    }
}

