/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RandomSamplerAggregationBuilder
extends AbstractAggregationBuilder<RandomSamplerAggregationBuilder> {
    public static final String NAME = "random_sampler";
    static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    static final ParseField SEED = new ParseField("seed", new String[0]);
    static final ParseField SHARD_SEED = new ParseField("shard_seed", new String[0]);
    public static final ObjectParser<RandomSamplerAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("random_sampler", RandomSamplerAggregationBuilder::new);
    private int seed = Randomness.get().nextInt();
    private Integer shardSeed;
    private double p;

    public RandomSamplerAggregationBuilder(String name) {
        super(name);
    }

    public RandomSamplerAggregationBuilder setProbability(double probability) {
        if (probability <= 0.0) {
            throw new IllegalArgumentException("[probability] must be greater than 0.0, was [" + probability + "]");
        }
        if (probability > 0.5 && probability != 1.0) {
            throw new IllegalArgumentException("[probability] must be between 0.0 and 0.5 or exactly 1.0, was [" + probability + "]");
        }
        this.p = probability;
        return this;
    }

    public RandomSamplerAggregationBuilder setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public RandomSamplerAggregationBuilder setShardSeed(int shardSeed) {
        this.shardSeed = shardSeed;
        return this;
    }

    public RandomSamplerAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.p = in.readDouble();
        this.seed = in.readInt();
        this.shardSeed = in.readOptionalInt();
    }

    protected RandomSamplerAggregationBuilder(RandomSamplerAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.p = clone.p;
        this.seed = clone.seed;
        this.shardSeed = clone.shardSeed;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.p);
        out.writeInt(this.seed);
        out.writeOptionalInt(this.shardSeed);
    }

    static void recursivelyCheckSubAggs(Collection<AggregationBuilder> builders, Consumer<AggregationBuilder> aggregationCheck) {
        if (builders == null || builders.isEmpty()) {
            return;
        }
        for (AggregationBuilder b : builders) {
            aggregationCheck.accept(b);
            RandomSamplerAggregationBuilder.recursivelyCheckSubAggs(b.getSubAggregations(), aggregationCheck);
        }
    }

    @Override
    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        if (parent != null) {
            throw new IllegalArgumentException("[random_sampler] aggregation [" + this.getName() + "] cannot have a parent aggregation");
        }
        if (subfactoriesBuilder.getAggregatorFactories().isEmpty()) {
            throw new IllegalArgumentException("[random_sampler] aggregation [" + this.getName() + "] must have sub-aggregations");
        }
        if (this.p == 0.0) {
            throw new IllegalArgumentException("[random_sampler] aggregation [" + this.getName() + "] must have [probability] set");
        }
        RandomSamplerAggregationBuilder.recursivelyCheckSubAggs(subfactoriesBuilder.getAggregatorFactories(), builder -> {
            if (!builder.supportsSampling()) {
                throw new IllegalArgumentException("[random_sampler] aggregation [" + this.getName() + "] does not support sampling [" + builder.getType() + "] aggregation [" + builder.getName() + "]");
            }
        });
        return new RandomSamplerAggregatorFactory(this.name, this.seed, this.shardSeed, this.p, context, parent, subfactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PROBABILITY.getPreferredName(), this.p);
        builder.field(SEED.getPreferredName(), this.seed);
        if (this.shardSeed != null) {
            builder.field(SHARD_SEED.getPreferredName(), this.shardSeed);
        }
        builder.endObject();
        return null;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new RandomSamplerAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.p, this.seed, this.shardSeed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RandomSamplerAggregationBuilder other = (RandomSamplerAggregationBuilder)obj;
        return Objects.equals(this.p, other.p) && Objects.equals(this.seed, other.seed) && Objects.equals(this.shardSeed, other.shardSeed);
    }

    static {
        PARSER.declareInt(RandomSamplerAggregationBuilder::setSeed, SEED);
        PARSER.declareInt(RandomSamplerAggregationBuilder::setShardSeed, SHARD_SEED);
        PARSER.declareDouble(RandomSamplerAggregationBuilder::setProbability, PROBABILITY);
    }
}

