/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.BucketAndOrd;
import org.elasticsearch.xcontent.ToXContentObject;

public abstract class BucketOrder
implements ToXContentObject,
Writeable {
    public static BucketOrder count(boolean asc) {
        return asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC;
    }

    public static BucketOrder key(boolean asc) {
        return asc ? InternalOrder.KEY_ASC : InternalOrder.KEY_DESC;
    }

    public static BucketOrder aggregation(String path, boolean asc) {
        return new InternalOrder.Aggregation(path, asc);
    }

    public static BucketOrder aggregation(String path, String metricName, boolean asc) {
        return new InternalOrder.Aggregation(path + "." + metricName, asc);
    }

    public static BucketOrder compound(List<BucketOrder> orders) {
        return new InternalOrder.CompoundOrder(orders);
    }

    public static BucketOrder compound(BucketOrder ... orders) {
        return BucketOrder.compound(Arrays.asList(orders));
    }

    public final void validate(Aggregator aggregator) throws AggregationExecutionException {
        this.partiallyBuiltBucketComparator(aggregator);
    }

    public abstract <T extends MultiBucketsAggregation.Bucket> Comparator<BucketAndOrd<T>> partiallyBuiltBucketComparator(Aggregator var1);

    public abstract Comparator<MultiBucketsAggregation.Bucket> comparator();

    abstract <B extends InternalMultiBucketAggregation.InternalBucket> Comparator<DelayedBucket<B>> delayedBucketComparator(BiFunction<List<B>, AggregationReduceContext, B> var1, AggregationReduceContext var2);

    abstract byte id();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeOrder(this, out);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

