/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ShardSearchContextId;

public class ActiveReaders {
    private final Map<Long, ReaderContext> activeReaders = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final Map<ShardSearchContextId, Long> relocationMap = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final String sessionId;

    ActiveReaders(String searchServiceSessionId) {
        this.sessionId = searchServiceSessionId;
    }

    void put(ReaderContext context) {
        ShardSearchContextId contextId = context.id();
        assert (this.sessionId.equals(contextId.getSessionId()));
        ReaderContext previous = this.activeReaders.put(contextId.getId(), context);
        assert (previous == null);
    }

    void putRelocatedReader(Long mappingKey, ReaderContext context) {
        ReaderContext previous = this.activeReaders.put(mappingKey, context);
        assert (previous == null);
    }

    Long generateRelocationMapping(ShardSearchContextId relocatedContextId, long mappingKey) {
        return this.relocationMap.putIfAbsent(relocatedContextId, mappingKey);
    }

    ReaderContext get(ShardSearchContextId contextId) {
        if (this.sessionId.equals(contextId.getSessionId())) {
            return this.activeReaders.get(contextId.getId());
        }
        Long activeReaderKey = this.relocationMap.get(contextId);
        if (activeReaderKey != null) {
            return this.activeReaders.get(activeReaderKey);
        }
        return null;
    }

    ReaderContext remove(ShardSearchContextId contextId) {
        if (this.sessionId.equals(contextId.getSessionId())) {
            return this.activeReaders.remove(contextId.getId());
        }
        Long activeReaderKey = this.relocationMap.get(contextId);
        if (activeReaderKey != null) {
            this.relocationMap.remove(contextId);
            return this.activeReaders.remove(activeReaderKey);
        }
        return null;
    }

    int size() {
        return this.activeReaders.size();
    }

    int relocationMapSize() {
        return this.relocationMap.size();
    }

    Collection<ReaderContext> values() {
        return this.activeReaders.values();
    }
}

