/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Collections;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class TransportSearchTemplateAction
extends HandledTransportAction<SearchTemplateRequest, SearchTemplateResponse> {
    private static final String TEMPLATE_LANG = "mustache";
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final Predicate<NodeFeature> clusterSupportsFeature;
    private final NodeClient client;
    private final SearchUsageHolder searchUsageHolder;

    @Inject
    public TransportSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client, UsageService usageService, ClusterService clusterService, FeatureService featureService) {
        super(MustachePlugin.SEARCH_TEMPLATE_ACTION.name(), transportService, actionFilters, SearchTemplateRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.clusterSupportsFeature = f -> {
            ClusterState state = clusterService.state();
            return state.clusterRecovered() && featureService.clusterHasFeature(state, (NodeFeature)f);
        };
        this.client = client;
        this.searchUsageHolder = usageService.getSearchUsageHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(Task task, SearchTemplateRequest request, ActionListener<SearchTemplateResponse> listener) {
        SearchTemplateResponse response = new SearchTemplateResponse();
        boolean success = false;
        try {
            SearchRequest searchRequest = TransportSearchTemplateAction.convert(request, response, this.scriptService, this.xContentRegistry, this.clusterSupportsFeature, this.searchUsageHolder);
            if (searchRequest != null) {
                this.client.search(searchRequest, listener.delegateResponse((l, e) -> {
                    response.decRef();
                    l.onFailure((Exception)e);
                }).delegateFailureAndWrap((l, searchResponse) -> {
                    response.setResponse((SearchResponse)searchResponse);
                    searchResponse.incRef();
                    ActionListener.respondAndRelease(l, response);
                }));
                success = true;
            } else {
                success = true;
                ActionListener.respondAndRelease(listener, response);
            }
        }
        catch (IOException e2) {
            listener.onFailure(e2);
        }
        finally {
            if (!success) {
                response.decRef();
            }
        }
    }

    static SearchRequest convert(SearchTemplateRequest searchTemplateRequest, SearchTemplateResponse response, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Predicate<NodeFeature> clusterSupportsFeature, SearchUsageHolder searchUsageHolder) throws IOException {
        Script script = new Script(searchTemplateRequest.getScriptType(), searchTemplateRequest.getScriptType() == ScriptType.STORED ? null : TEMPLATE_LANG, searchTemplateRequest.getScript(), searchTemplateRequest.getScriptParams() == null ? Collections.emptyMap() : searchTemplateRequest.getScriptParams());
        TemplateScript compiledScript = scriptService.compile(script, TemplateScript.CONTEXT).newInstance(script.getParams());
        String source = compiledScript.execute();
        response.setSource(new BytesArray(source));
        SearchRequest searchRequest = searchTemplateRequest.getRequest();
        SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler(LoggingDeprecationHandler.INSTANCE);
        try (XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(parserConfig, source);){
            builder.parseXContent(parser, false, searchUsageHolder, clusterSupportsFeature);
        }
        if (searchTemplateRequest.isSimulate()) {
            return null;
        }
        builder.explain(searchTemplateRequest.isExplain());
        builder.profile(searchTemplateRequest.isProfile());
        TransportSearchTemplateAction.checkRestTotalHitsAsInt(searchRequest, builder);
        searchRequest.source(builder);
        return searchRequest;
    }

    private static void checkRestTotalHitsAsInt(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        Integer trackTotalHitsUpTo;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) != null) {
            if (searchSourceBuilder.trackTotalHitsUpTo() == null) {
                searchSourceBuilder.trackTotalHitsUpTo(trackTotalHitsUpTo);
            } else if (searchSourceBuilder.trackTotalHitsUpTo() != Integer.MAX_VALUE && searchSourceBuilder.trackTotalHitsUpTo() != -1) {
                throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + searchSourceBuilder.trackTotalHitsUpTo());
            }
        }
    }
}

