/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.RankVectors;
import org.elasticsearch.script.field.vectors.VectorIterator;

public class FloatRankVectors
implements RankVectors {
    private final BytesRef magnitudes;
    private float[] magnitudesArray = null;
    private final int dims;
    private final int numVectors;
    private final VectorIterator<float[]> vectorValues;

    public FloatRankVectors(VectorIterator<float[]> decodedDocVector, BytesRef magnitudes, int numVectors, int dims) {
        assert (magnitudes.length == numVectors * 4);
        this.vectorValues = decodedDocVector;
        this.magnitudes = magnitudes;
        this.numVectors = numVectors;
        this.dims = dims;
    }

    @Override
    public float maxSimDotProduct(float[][] query) {
        this.vectorValues.reset();
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        while (this.vectorValues.hasNext()) {
            float[] vv = (float[])this.vectorValues.next();
            for (int i = 0; i < query.length; ++i) {
                maxes[i] = Math.max(maxes[i], VectorUtil.dotProduct(query[i], vv));
            }
        }
        float sum = 0.0f;
        for (float m : maxes) {
            sum += m;
        }
        return sum;
    }

    @Override
    public float maxSimDotProduct(byte[][] query) {
        throw new UnsupportedOperationException("use [float maxSimDotProduct(float[][] queryVector)] instead");
    }

    @Override
    public float maxSimInvHamming(byte[][] query) {
        throw new UnsupportedOperationException("hamming distance is not supported for float vectors");
    }

    @Override
    public Iterator<float[]> getVectors() {
        return this.vectorValues.copy();
    }

    @Override
    public float[] getMagnitudes() {
        if (this.magnitudesArray == null) {
            this.magnitudesArray = VectorEncoderDecoder.getMultiMagnitudes(this.magnitudes);
        }
        return this.magnitudesArray;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.numVectors;
    }
}

