/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.RankVectors;
import org.elasticsearch.script.field.vectors.VectorIterator;

public class ByteRankVectors
implements RankVectors {
    protected final VectorIterator<byte[]> vectorValues;
    protected final int numVecs;
    protected final int dims;
    private float[] magnitudes;
    private final BytesRef magnitudesBytes;

    public ByteRankVectors(VectorIterator<byte[]> vectorValues, BytesRef magnitudesBytes, int numVecs, int dims) {
        assert (magnitudesBytes.length == numVecs * 4);
        this.vectorValues = vectorValues;
        this.numVecs = numVecs;
        this.dims = dims;
        this.magnitudesBytes = magnitudesBytes;
    }

    @Override
    public float maxSimDotProduct(float[][] query) {
        throw new UnsupportedOperationException("use [float maxSimDotProduct(byte[][] queryVector)] instead");
    }

    @Override
    public float maxSimDotProduct(byte[][] query) {
        this.vectorValues.reset();
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        while (this.vectorValues.hasNext()) {
            byte[] vv = (byte[])this.vectorValues.next();
            for (int i = 0; i < query.length; ++i) {
                maxes[i] = Math.max(maxes[i], (float)VectorUtil.dotProduct(query[i], vv));
            }
        }
        float sum = 0.0f;
        for (float m : maxes) {
            sum += m;
        }
        return sum;
    }

    @Override
    public float maxSimInvHamming(byte[][] query) {
        this.vectorValues.reset();
        int bitCount = this.dims * 8;
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        while (this.vectorValues.hasNext()) {
            byte[] vv = (byte[])this.vectorValues.next();
            for (int i = 0; i < query.length; ++i) {
                maxes[i] = Math.max(maxes[i], (float)(bitCount - VectorUtil.xorBitCount(vv, query[i])) / (float)bitCount);
            }
        }
        float sum = 0.0f;
        for (float m : maxes) {
            sum += m;
        }
        return sum;
    }

    @Override
    public Iterator<float[]> getVectors() {
        return new ByteToFloatIteratorWrapper(this.vectorValues.copy(), this.dims);
    }

    @Override
    public float[] getMagnitudes() {
        if (this.magnitudes == null) {
            this.magnitudes = VectorEncoderDecoder.getMultiMagnitudes(this.magnitudesBytes);
        }
        return this.magnitudes;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.numVecs;
    }

    static class ByteToFloatIteratorWrapper
    implements Iterator<float[]> {
        private final Iterator<byte[]> byteIterator;
        private final float[] buffer;
        private final int dims;

        ByteToFloatIteratorWrapper(Iterator<byte[]> byteIterator, int dims) {
            this.byteIterator = byteIterator;
            this.buffer = new float[dims];
            this.dims = dims;
        }

        @Override
        public boolean hasNext() {
            return this.byteIterator.hasNext();
        }

        @Override
        public float[] next() {
            byte[] next = this.byteIterator.next();
            for (int i = 0; i < this.dims; ++i) {
                this.buffer[i] = next[i];
            }
            return this.buffer;
        }
    }
}

