/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.RestClusterGetSettingsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestClusterGetSettingsAction
extends BaseRestHandler {
    private final Settings settings;
    private final ClusterSettings clusterSettings;
    private final SettingsFilter settingsFilter;

    public RestClusterGetSettingsAction(Settings settings, ClusterSettings clusterSettings, SettingsFilter settingsFilter) {
        this.settings = settings;
        this.clusterSettings = clusterSettings;
        this.settingsFilter = settingsFilter;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/settings"));
    }

    @Override
    public String getName() {
        return "cluster_get_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        ClusterGetSettingsAction.Request clusterSettingsRequest = new ClusterGetSettingsAction.Request(RestUtils.getMasterNodeTimeout(request));
        RestUtils.consumeDeprecatedLocalParameter(request);
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(ClusterGetSettingsAction.INSTANCE, clusterSettingsRequest, new RestToXContentListener<RestClusterGetSettingsResponse>((RestChannel)channel).map(r -> RestClusterGetSettingsAction.response(r, renderDefaults, this.settingsFilter, this.clusterSettings, this.settings)));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static RestClusterGetSettingsResponse response(ClusterGetSettingsAction.Response response, boolean renderDefaults, SettingsFilter settingsFilter, ClusterSettings clusterSettings, Settings settings) {
        return new RestClusterGetSettingsResponse(settingsFilter.filter(response.persistentSettings()), settingsFilter.filter(response.transientSettings()), renderDefaults ? settingsFilter.filter(clusterSettings.diff(response.settings(), settings)) : Settings.EMPTY);
    }
}

