/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import org.elasticsearch.common.Strings;

public class RequestedRangeNotSatisfiedException
extends IOException {
    private final String resource;
    private final long position;
    private final long length;

    public RequestedRangeNotSatisfiedException(String resource, long position, long length) {
        super(RequestedRangeNotSatisfiedException.message(resource, position, length));
        this.resource = resource;
        this.position = position;
        this.length = length;
    }

    public RequestedRangeNotSatisfiedException(String resource, long position, long length, Throwable cause) {
        super(RequestedRangeNotSatisfiedException.message(resource, position, length), cause);
        this.resource = resource;
        this.position = position;
        this.length = length;
    }

    public String getResource() {
        return this.resource;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        return this.length;
    }

    private static String message(String resource, long position, long length) {
        return Strings.format("Requested range [position=%d, length=%d] cannot be satisfied for [%s]", position, length, resource);
    }
}

