/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RepositoriesStats
implements Writeable,
ToXContentFragment {
    private final Map<String, SnapshotStats> repositorySnapshotStats;

    public RepositoriesStats(StreamInput in) throws IOException {
        this.repositorySnapshotStats = in.readMap(SnapshotStats::readFrom);
    }

    public RepositoriesStats(Map<String, SnapshotStats> repositorySnapshotStats) {
        this.repositorySnapshotStats = new HashMap<String, SnapshotStats>(repositorySnapshotStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.repositorySnapshotStats, StreamOutput::writeWriteable);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("repositories", this.repositorySnapshotStats);
        return builder;
    }

    public Map<String, SnapshotStats> getRepositorySnapshotStats() {
        return Collections.unmodifiableMap(this.repositorySnapshotStats);
    }

    public record SnapshotStats(long shardSnapshotsStarted, long shardSnapshotsCompleted, long shardSnapshotsInProgress, long totalReadThrottledNanos, long totalWriteThrottledNanos, long numberOfBlobsUploaded, long numberOfBytesUploaded, long totalUploadTimeInMillis, long totalUploadReadTimeInMillis) implements ToXContentObject,
    Writeable
    {
        private static final TransportVersion EXTENDED_SNAPSHOT_STATS_IN_NODE_INFO = TransportVersion.fromName("extended_snapshot_stats_in_node_info");
        public static final SnapshotStats ZERO = new SnapshotStats(0L, 0L);

        public SnapshotStats(long totalReadThrottledNanos, long totalWriteThrottledNanos) {
            this(0L, 0L, 0L, totalReadThrottledNanos, totalWriteThrottledNanos, 0L, 0L, 0L, 0L);
        }

        public static SnapshotStats readFrom(StreamInput in) throws IOException {
            long totalReadThrottledNanos = in.readVLong();
            long totalWriteThrottledNanos = in.readVLong();
            if (in.getTransportVersion().supports(EXTENDED_SNAPSHOT_STATS_IN_NODE_INFO)) {
                return new SnapshotStats(in.readVLong(), in.readVLong(), in.readVLong(), totalReadThrottledNanos, totalWriteThrottledNanos, in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
            }
            return new SnapshotStats(totalReadThrottledNanos, totalWriteThrottledNanos);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (builder.humanReadable()) {
                builder.field("total_read_throttled_time", new TimeValue(this.totalReadThrottledNanos, TimeUnit.NANOSECONDS));
                builder.field("total_write_throttled_time", new TimeValue(this.totalWriteThrottledNanos, TimeUnit.NANOSECONDS));
            }
            builder.field("total_read_throttled_time_nanos", this.totalReadThrottledNanos);
            builder.field("total_write_throttled_time_nanos", this.totalWriteThrottledNanos);
            builder.field("shard_snapshots_started", this.shardSnapshotsStarted);
            builder.field("shard_snapshots_completed", this.shardSnapshotsCompleted);
            builder.field("shard_snapshots_in_progress", this.shardSnapshotsInProgress);
            builder.field("uploaded_blobs", this.numberOfBlobsUploaded);
            builder.humanReadableField("uploaded_size_in_bytes", "uploaded_size", ByteSizeValue.ofBytes(this.numberOfBytesUploaded));
            builder.humanReadableField("total_upload_time_in_millis", "total_upload_time", TimeValue.timeValueMillis(this.totalUploadTimeInMillis));
            builder.humanReadableField("total_read_time_in_millis", "total_read_time", TimeValue.timeValueMillis(this.totalUploadReadTimeInMillis));
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.totalReadThrottledNanos);
            out.writeVLong(this.totalWriteThrottledNanos);
            if (out.getTransportVersion().supports(EXTENDED_SNAPSHOT_STATS_IN_NODE_INFO)) {
                out.writeVLong(this.shardSnapshotsStarted);
                out.writeVLong(this.shardSnapshotsCompleted);
                out.writeVLong(this.shardSnapshotsInProgress);
                out.writeVLong(this.numberOfBlobsUploaded);
                out.writeVLong(this.numberOfBytesUploaded);
                out.writeVLong(this.totalUploadTimeInMillis);
                out.writeVLong(this.totalUploadReadTimeInMillis);
            }
        }
    }
}

