/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.protocol.xpack.graph.Hop;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GraphExploreRequest
extends LegacyActionRequest
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static final String NO_HOPS_ERROR_MESSAGE = "Graph explore request must have at least one hop";
    public static final String NO_VERTICES_ERROR_MESSAGE = "Graph explore hop must have at least one VertexRequest";
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
    private String routing;
    private TimeValue timeout;
    private int sampleSize = 100;
    private String sampleDiversityField;
    private int maxDocsPerDiversityValue;
    private boolean useSignificance = true;
    private boolean returnDetailedInfo;
    private List<Hop> hops = new ArrayList<Hop>();

    public GraphExploreRequest() {
    }

    public GraphExploreRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.hops.size() == 0) {
            validationException = ValidateActions.addValidationError(NO_HOPS_ERROR_MESSAGE, validationException);
        }
        for (Hop hop : this.hops) {
            validationException = hop.validate(validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public GraphExploreRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public GraphExploreRequest indicesOptions(IndicesOptions indicesOptions) {
        if (indicesOptions == null) {
            throw new IllegalArgumentException("IndicesOptions must not be null");
        }
        this.indicesOptions = indicesOptions;
        return this;
    }

    public GraphExploreRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.routing = in.readOptionalString();
        this.timeout = in.readOptionalTimeValue();
        this.sampleSize = in.readInt();
        this.sampleDiversityField = in.readOptionalString();
        this.maxDocsPerDiversityValue = in.readInt();
        this.useSignificance = in.readBoolean();
        this.returnDetailedInfo = in.readBoolean();
        int numHops = in.readInt();
        Hop parentHop = null;
        for (int i = 0; i < numHops; ++i) {
            Hop hop = new Hop(parentHop);
            hop.readFrom(in);
            this.hops.add(hop);
            parentHop = hop;
        }
    }

    public String routing() {
        return this.routing;
    }

    public GraphExploreRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GraphExploreRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public GraphExploreRequest timeout(TimeValue timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout must not be null");
        }
        this.timeout = timeout;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.routing);
        out.writeOptionalTimeValue(this.timeout);
        out.writeInt(this.sampleSize);
        out.writeOptionalString(this.sampleDiversityField);
        out.writeInt(this.maxDocsPerDiversityValue);
        out.writeBoolean(this.useSignificance);
        out.writeBoolean(this.returnDetailedInfo);
        out.writeInt(this.hops.size());
        for (Hop hop : this.hops) {
            hop.writeTo(out);
        }
    }

    @Override
    public String toString() {
        return "graph explore [" + Arrays.toString(this.indices) + "]";
    }

    public void sampleSize(int maxNumberOfDocsPerHop) {
        this.sampleSize = maxNumberOfDocsPerHop;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public void sampleDiversityField(String name) {
        this.sampleDiversityField = name;
    }

    public String sampleDiversityField() {
        return this.sampleDiversityField;
    }

    public void maxDocsPerDiversityValue(int maxDocs) {
        this.maxDocsPerDiversityValue = maxDocs;
    }

    public int maxDocsPerDiversityValue() {
        return this.maxDocsPerDiversityValue;
    }

    public void useSignificance(boolean value) {
        this.useSignificance = value;
    }

    public boolean useSignificance() {
        return this.useSignificance;
    }

    public void returnDetailedInfo(boolean value) {
        this.returnDetailedInfo = value;
    }

    public boolean returnDetailedInfo() {
        return this.returnDetailedInfo;
    }

    public Hop createNextHop(QueryBuilder guidingQuery) {
        Hop parent = null;
        if (this.hops.size() > 0) {
            parent = this.hops.get(this.hops.size() - 1);
        }
        Hop newHop = new Hop(parent);
        newHop.guidingQuery = guidingQuery;
        this.hops.add(newHop);
        return newHop;
    }

    public int getHopNumbers() {
        return this.hops.size();
    }

    public Hop getHop(int hopNumber) {
        return this.hops.get(hopNumber);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("controls");
        if (this.sampleSize != 100) {
            builder.field("sample_size", this.sampleSize);
        }
        if (this.sampleDiversityField != null) {
            builder.startObject("sample_diversity");
            builder.field("field", this.sampleDiversityField);
            builder.field("max_docs_per_value", this.maxDocsPerDiversityValue);
            builder.endObject();
        }
        builder.field("use_significance", this.useSignificance);
        if (this.returnDetailedInfo) {
            builder.field("return_detailed_stats", this.returnDetailedInfo);
        }
        builder.endObject();
        for (Hop hop : this.hops) {
            if (hop.parentHop != null) {
                builder.startObject("connections");
            }
            hop.toXContent(builder, params);
        }
        for (Hop hop : this.hops) {
            if (hop.parentHop == null) continue;
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class TermBoost
    implements Writeable {
        String term;
        float boost;

        public TermBoost(String term, float boost) {
            this.term = term;
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("Boosts must be a positive non-zero number");
            }
            this.boost = boost;
        }

        TermBoost() {
        }

        public String getTerm() {
            return this.term;
        }

        public float getBoost() {
            return this.boost;
        }

        void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.boost = in.readFloat();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeFloat(this.boost);
        }
    }
}

