/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.nativeaccess.NativeAccessUtil;
import org.elasticsearch.plugins.ModuleSupport;

public class UberModuleClassLoader
extends SecureClassLoader
implements AutoCloseable {
    private final Module module;
    private final URLClassLoader internalLoader;
    private final CodeSource codeSource;
    private final ModuleLayer.Controller moduleController;
    private final Set<String> packageNames;

    private static Map<String, Set<String>> getModuleToServiceMap(ModuleLayer moduleLayer) {
        Set unqualifiedExports = moduleLayer.modules().stream().flatMap(module -> module.getDescriptor().exports().stream()).filter(Predicate.not(ModuleDescriptor.Exports::isQualified)).map(ModuleDescriptor.Exports::source).collect(Collectors.toSet());
        return moduleLayer.modules().stream().map(Module::getDescriptor).filter(ModuleSupport::hasAtLeastOneUnqualifiedExport).collect(Collectors.toMap(ModuleDescriptor::name, md -> md.provides().stream().map(ModuleDescriptor.Provides::service).filter(name -> unqualifiedExports.contains(UberModuleClassLoader.packageName(name))).collect(Collectors.toSet())));
    }

    static UberModuleClassLoader getInstance(ClassLoader parent, String moduleName, Set<URL> jarUrls) {
        return UberModuleClassLoader.getInstance(parent, ModuleLayer.boot(), moduleName, jarUrls, Set.of(), Set.of());
    }

    static UberModuleClassLoader getInstance(ClassLoader parent, ModuleLayer parentLayer, String moduleName, Set<URL> jarUrls, Set<String> moduleDenyList, Set<String> modulesWithNativeAccess) {
        Path[] jarPaths = (Path[])jarUrls.stream().map(UberModuleClassLoader::urlToPathUnchecked).toArray(Path[]::new);
        Map<String, Set<String>> parentLayerModuleToServiceMap = UberModuleClassLoader.getModuleToServiceMap(parentLayer);
        Set<String> requires = parentLayerModuleToServiceMap.keySet().stream().filter(Predicate.not(moduleDenyList::contains)).collect(Collectors.toSet());
        Set<String> uses = parentLayerModuleToServiceMap.entrySet().stream().filter(Predicate.not(entry -> moduleDenyList.contains(entry.getKey()))).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
        ModuleFinder finder = ModuleSupport.ofSyntheticPluginModule(moduleName, jarPaths, requires, uses, s -> UberModuleClassLoader.isPackageInLayers(s, parentLayer));
        Configuration cf = parentLayer.configuration().resolve(finder, ModuleFinder.of(new Path[0]), Set.of(moduleName));
        Set packageNames = finder.find(moduleName).map(ModuleReference::descriptor).map(ModuleDescriptor::packages).orElseThrow();
        return new UberModuleClassLoader(parent, moduleName, jarUrls.toArray(new URL[0]), cf, parentLayer, packageNames, modulesWithNativeAccess);
    }

    private static boolean isPackageInLayers(String packageName, ModuleLayer moduleLayer) {
        if (moduleLayer.modules().stream().map(Module::getPackages).anyMatch(p -> p.contains(packageName))) {
            return true;
        }
        if (moduleLayer.parents().equals(List.of(ModuleLayer.empty()))) {
            return false;
        }
        return moduleLayer.parents().stream().anyMatch(ml -> UberModuleClassLoader.isPackageInLayers(packageName, ml));
    }

    private UberModuleClassLoader(ClassLoader parent, String moduleName, URL[] jarURLs, Configuration cf, ModuleLayer mparent, Set<String> packageNames, Set<String> modulesWithNativeAccess) {
        super(parent);
        this.internalLoader = new URLClassLoader(jarURLs);
        this.codeSource = new CodeSource(jarURLs[0], (CodeSigner[])null);
        this.moduleController = ModuleLayer.defineModules(cf, List.of(mparent), s -> this);
        this.module = this.moduleController.layer().findModule(moduleName).orElseThrow();
        for (String name : modulesWithNativeAccess) {
            this.moduleController.layer().findModule(name).ifPresent(m -> NativeAccessUtil.enableNativeAccess((ModuleLayer.Controller)this.moduleController, (Module)m));
        }
        this.packageNames = packageNames;
    }

    public ModuleLayer getLayer() {
        return this.moduleController.layer();
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        if (Objects.isNull(moduleName) || !this.module.getName().equals(moduleName)) {
            return null;
        }
        return this.findClass(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) {
        String rn = name.replace('.', '/').concat(".class");
        try (InputStream in = this.internalLoader.getResourceAsStream(rn);){
            if (in == null) {
                Class<?> clazz2 = null;
                return clazz2;
            }
            byte[] bytes = in.readAllBytes();
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, this.codeSource);
            return clazz;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected URL findResource(String moduleName, String name) {
        if (Objects.isNull(moduleName) || !this.module.getName().equals(moduleName)) {
            return null;
        }
        return this.findResource(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.internalLoader.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.internalLoader.findResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
        String packageName = UberModuleClassLoader.packageName(cn);
        Object object = this.getClassLoadingLock(cn);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(cn);
            if (c == null) {
                c = this.packageNames.contains(packageName) ? this.findClass(cn) : this.getParent().loadClass(cn);
            }
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    void addReadsSystemClassLoaderUnnamedModule() {
        this.moduleController.layer().modules().forEach(module -> this.moduleController.addReads((Module)module, ClassLoader.getSystemClassLoader().getUnnamedModule()));
    }

    private static String packageName(String cn) {
        int pos = cn.lastIndexOf(46);
        return pos < 0 ? "" : cn.substring(0, pos);
    }

    @SuppressForbidden(reason="plugin infrastructure provides URLs but module layer uses Paths")
    static Path urlToPathUnchecked(URL url) {
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.internalLoader.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not close internal URLClassLoader");
        }
    }

    public URLClassLoader getInternalLoader() {
        return this.internalLoader;
    }
}

