/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.phase.IRTreeVisitor;

public abstract class IRNode {
    private final Map<Class<? extends IRDecoration<?>>, IRDecoration<?>> decorations = new HashMap();
    private final Set<Class<? extends IRCondition>> conditions = new HashSet<Class<? extends IRCondition>>();
    private final Location location;

    public <V> V attachDecoration(IRDecoration<V> decoration) {
        IRDecoration<V> previous = this.decorations.put(decoration.getClass(), decoration);
        return previous == null ? null : (V)previous.getValue();
    }

    public <T extends IRDecoration<?>> T removeDecoration(Class<T> type) {
        return (T)((IRDecoration)type.cast(this.decorations.remove(type)));
    }

    public <T extends IRDecoration<?>> T getDecoration(Class<T> type) {
        return (T)((IRDecoration)type.cast(this.decorations.get(type)));
    }

    public <T extends IRDecoration<V>, V> V getDecorationValue(Class<T> type) {
        return this.getDecorationValueOrDefault(type, null);
    }

    public <T extends IRDecoration<V>, V> V getDecorationValueOrDefault(Class<T> type, V defaultValue) {
        IRDecoration decoration = (IRDecoration)type.cast(this.decorations.get(type));
        return decoration == null ? defaultValue : decoration.getValue();
    }

    public <T extends IRDecoration<?>> String getDecorationString(Class<T> type) {
        IRDecoration decoration = (IRDecoration)type.cast(this.decorations.get(type));
        return decoration == null ? null : decoration.toString();
    }

    public boolean attachCondition(Class<? extends IRCondition> type) {
        return this.conditions.add(type);
    }

    public boolean removeCondition(Class<? extends IRCondition> type) {
        return this.conditions.remove(type);
    }

    public boolean hasCondition(Class<? extends IRCondition> type) {
        return this.conditions.contains(type);
    }

    public Location getLocation() {
        return this.location;
    }

    public abstract <Scope> void visit(IRTreeVisitor<Scope> var1, Scope var2);

    public abstract <Scope> void visitChildren(IRTreeVisitor<Scope> var1, Scope var2);

    public IRNode(Location location) {
        this.location = location;
    }

    public static abstract class IRDecoration<V> {
        private final V value;

        public IRDecoration(V value) {
            this.value = Objects.requireNonNull(value);
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static interface IRCondition {
    }
}

