/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.antlr;

import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.elasticsearch.painless.Location;

final class ParserErrorStrategy
extends DefaultErrorStrategy {
    final String sourceName;

    ParserErrorStrategy(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public void recover(Parser recognizer, RecognitionException re) {
        Token token = re.getOffendingToken();
        Object message = token == null ? "no parse token found." : (re instanceof InputMismatchException ? "unexpected token [" + this.getTokenErrorDisplay(token) + "] was expecting one of [" + re.getExpectedTokens().toString(recognizer.getVocabulary()) + "]." : (re instanceof NoViableAltException ? (token.getType() == -1 ? "unexpected end of script." : "invalid sequence of tokens near [" + this.getTokenErrorDisplay(token) + "].") : "unexpected token near [" + this.getTokenErrorDisplay(token) + "]."));
        Location location = new Location(this.sourceName, token == null ? -1 : token.getStartIndex());
        throw location.createError(new IllegalArgumentException((String)message, re));
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        Token token = recognizer.getCurrentToken();
        String message = "unexpected token [" + this.getTokenErrorDisplay(token) + "] was expecting one of [" + recognizer.getExpectedTokens().toString(recognizer.getVocabulary()) + "].";
        Location location = new Location(this.sourceName, token.getStartIndex());
        throw location.createError(new IllegalArgumentException(message));
    }

    @Override
    public void sync(Parser recognizer) {
    }
}

