/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.painless.PainlessScriptEngine;
import org.elasticsearch.painless.action.PainlessContextInfo;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PainlessContextAction {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/scripts/painless/context");
    private static final String SCRIPT_CONTEXT_NAME_PARAM = "context";

    private PainlessContextAction() {
    }

    public static class RestAction
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_scripts/painless/_context"));
        }

        @Override
        public String getName() {
            return "_scripts_painless_context";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
            Request request = new Request();
            request.setScriptContextName(restRequest.param(PainlessContextAction.SCRIPT_CONTEXT_NAME_PARAM));
            return channel -> client.executeLocally(INSTANCE, request, new RestToXContentListener((RestChannel)channel));
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final PainlessScriptEngine painlessScriptEngine;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, PainlessScriptEngine painlessScriptEngine) {
            super(INSTANCE.name(), transportService, actionFilters, Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.painlessScriptEngine = painlessScriptEngine;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            PainlessContextInfo painlessContextInfo;
            List<String> scriptContextNames;
            if (request.scriptContextName == null) {
                scriptContextNames = this.painlessScriptEngine.getContextsToLookups().keySet().stream().map(v -> v.name).collect(Collectors.toList());
                painlessContextInfo = null;
            } else {
                ScriptContext<?> scriptContext = null;
                PainlessLookup painlessLookup = null;
                for (Map.Entry<ScriptContext<?>, PainlessLookup> contextLookupEntry : this.painlessScriptEngine.getContextsToLookups().entrySet()) {
                    if (!contextLookupEntry.getKey().name.equals(request.getScriptContextName())) continue;
                    scriptContext = contextLookupEntry.getKey();
                    painlessLookup = contextLookupEntry.getValue();
                    break;
                }
                if (scriptContext == null || painlessLookup == null) {
                    throw new IllegalArgumentException("script context [" + request.getScriptContextName() + "] not found");
                }
                scriptContextNames = Collections.emptyList();
                painlessContextInfo = new PainlessContextInfo(scriptContext, painlessLookup);
            }
            listener.onResponse(new Response(scriptContextNames, painlessContextInfo));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
        private final List<String> scriptContextNames;
        private final PainlessContextInfo painlessContextInfo;

        public Response(List<String> scriptContextNames, PainlessContextInfo painlessContextInfo) {
            Objects.requireNonNull(scriptContextNames);
            scriptContextNames = new ArrayList<String>(scriptContextNames);
            scriptContextNames.sort(String::compareTo);
            this.scriptContextNames = Collections.unmodifiableList(scriptContextNames);
            this.painlessContextInfo = painlessContextInfo;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.scriptContextNames);
            out.writeOptionalWriteable(this.painlessContextInfo);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.painlessContextInfo == null) {
                builder.startObject();
                builder.field(CONTEXTS.getPreferredName(), (Collection<String>)this.scriptContextNames);
                builder.endObject();
            } else {
                this.painlessContextInfo.toXContent(builder, params);
            }
            return builder;
        }
    }

    public static class Request
    extends LegacyActionRequest {
        private String scriptContextName;

        public Request() {
            this.scriptContextName = null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.scriptContextName = in.readString();
        }

        public void setScriptContextName(String scriptContextName) {
            this.scriptContextName = scriptContextName;
        }

        public String getScriptContextName() {
            return this.scriptContextName;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.scriptContextName);
        }
    }
}

