/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SunThreadInfo {
    private static final ThreadMXBean threadMXBean;
    private static final Method getThreadAllocatedBytes;
    private static final Method isThreadAllocatedMemorySupported;
    private static final Method isThreadAllocatedMemoryEnabled;
    private static final Logger logger;
    public static final SunThreadInfo INSTANCE;

    public boolean isThreadAllocatedMemorySupported() {
        if (isThreadAllocatedMemorySupported == null) {
            return false;
        }
        try {
            return (Boolean)isThreadAllocatedMemorySupported.invoke((Object)threadMXBean, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("exception while invoke isThreadAllocatedMemorySupported", (Throwable)e);
            return false;
        }
    }

    public boolean isThreadAllocatedMemoryEnabled() {
        if (isThreadAllocatedMemoryEnabled == null) {
            return false;
        }
        try {
            return (Boolean)isThreadAllocatedMemoryEnabled.invoke((Object)threadMXBean, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("exception while invoke isThreadAllocatedMemoryEnabled", (Throwable)e);
            return false;
        }
    }

    public long getThreadAllocatedBytes(long id) {
        if (getThreadAllocatedBytes == null) {
            return 0L;
        }
        if (!this.isThreadAllocatedMemorySupported() || !this.isThreadAllocatedMemoryEnabled()) {
            return 0L;
        }
        if (id <= 0L) {
            return 0L;
        }
        try {
            long bytes = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, id);
            assert (bytes >= 0L) : "OS reported a negative thread allocated size [" + bytes + "], thread id [" + id + "].";
            return Math.max(0L, bytes);
        }
        catch (Exception e) {
            logger.warn("exception retrieving thread allocated memory", (Throwable)e);
            return 0L;
        }
    }

    private static Method getMethod(String methodName, Class<?> ... parameterTypes) {
        String className = "com.sun.management.ThreadMXBean";
        try {
            Method method = Class.forName(className).getMethod(methodName, parameterTypes);
            return method;
        }
        catch (Exception e) {
            logger.debug(() -> "failed to get method [" + methodName + "] from class [" + className + "]", (Throwable)e);
            return null;
        }
    }

    static {
        logger = LogManager.getLogger(SunThreadInfo.class);
        INSTANCE = new SunThreadInfo();
        threadMXBean = ManagementFactory.getThreadMXBean();
        getThreadAllocatedBytes = SunThreadInfo.getMethod("getThreadAllocatedBytes", Long.TYPE);
        isThreadAllocatedMemorySupported = SunThreadInfo.getMethod("isThreadAllocatedMemorySupported", new Class[0]);
        isThreadAllocatedMemoryEnabled = SunThreadInfo.getMethod("isThreadAllocatedMemoryEnabled", new Class[0]);
    }
}

