/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.util.Arrays;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.lucene.spatial.CartesianShapeDocValuesQuery;

public class XYQueriesUtils {
    public static Query toXYPointQuery(Geometry geometry, String fieldName, ShapeRelation relation, IndexType indexType) {
        boolean indexed = indexType.hasPoints();
        boolean hasDocValues = indexType.hasDocValues();
        assert (indexed || hasDocValues);
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry(geometry, t -> {});
        return switch (relation) {
            default -> throw new MatchException(null, null);
            case ShapeRelation.INTERSECTS -> XYQueriesUtils.buildIntersectsQuery(fieldName, indexed, hasDocValues, luceneGeometries);
            case ShapeRelation.DISJOINT -> XYQueriesUtils.buildDisjointQuery(fieldName, indexed, hasDocValues, luceneGeometries);
            case ShapeRelation.CONTAINS -> XYQueriesUtils.buildContainsQuery(fieldName, indexed, hasDocValues, luceneGeometries);
            case ShapeRelation.WITHIN -> XYQueriesUtils.buildWithinQuery(fieldName, indexed, hasDocValues, luceneGeometries);
        };
    }

    private static Query buildIntersectsQuery(String fieldName, boolean isIndexed, boolean hasDocValues, XYGeometry ... luceneGeometries) {
        Query query;
        if (isIndexed) {
            query = XYPointField.newGeometryQuery(fieldName, luceneGeometries);
            if (hasDocValues) {
                Query queryDocValues = XYDocValuesField.newSlowGeometryQuery(fieldName, luceneGeometries);
                query = new IndexOrDocValuesQuery(query, queryDocValues);
            }
        } else {
            query = XYDocValuesField.newSlowGeometryQuery(fieldName, luceneGeometries);
        }
        return query;
    }

    private static Query buildDisjointQuery(String fieldName, boolean isIndexed, boolean hasDocValues, XYGeometry ... luceneGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (hasDocValues) {
            builder.add(new FieldExistsQuery(fieldName), BooleanClause.Occur.FILTER);
        } else {
            builder.add(XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, new XYRectangle(-3.4028235E38f, Float.MAX_VALUE, -3.4028235E38f, Float.MAX_VALUE)), BooleanClause.Occur.FILTER);
        }
        builder.add(XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, luceneGeometries), BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    private static Query buildContainsQuery(String fieldName, boolean isIndexed, boolean hasDocValues, XYGeometry ... luceneGeometries) {
        if (!XYQueriesUtils.allPoints(luceneGeometries)) {
            return Queries.NO_DOCS_INSTANCE;
        }
        if (luceneGeometries.length == 1) {
            return XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, luceneGeometries);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (XYGeometry geometry : luceneGeometries) {
            builder.add(XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, geometry), BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    private static Query buildWithinQuery(String fieldName, boolean isIndexed, boolean hasDocValues, XYGeometry ... luceneGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, luceneGeometries), BooleanClause.Occur.FILTER);
        builder.add(XYQueriesUtils.buildIntersectsQuery(fieldName, isIndexed, hasDocValues, new InverseXYGeometry(luceneGeometries)), BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    private static boolean allPoints(XYGeometry[] geometries) {
        return Arrays.stream(geometries).allMatch(g -> g instanceof XYPoint);
    }

    public static Query toXYShapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, IndexType indexType) {
        Query query;
        boolean indexed = indexType.hasPoints();
        boolean hasDocValues = indexType.hasDocValues();
        assert (indexed || hasDocValues);
        if (geometry == null || geometry.isEmpty()) {
            return Queries.NO_DOCS_INSTANCE;
        }
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry(geometry, t -> {});
        if (indexed) {
            query = XYShape.newGeometryQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
            if (hasDocValues) {
                CartesianShapeDocValuesQuery queryDocValues = new CartesianShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
                query = new IndexOrDocValuesQuery(query, queryDocValues);
            }
        } else {
            query = new CartesianShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
        }
        return query;
    }

    private static class InverseXYGeometry
    extends XYGeometry {
        private final XYGeometry[] geometries;

        InverseXYGeometry(XYGeometry ... geometries) {
            this.geometries = geometries;
        }

        @Override
        protected Component2D toComponent2D() {
            final Component2D component2D = XYGeometry.create(this.geometries);
            return new Component2D(){

                @Override
                public double getMinX() {
                    return -3.4028234663852886E38;
                }

                @Override
                public double getMaxX() {
                    return 3.4028234663852886E38;
                }

                @Override
                public double getMinY() {
                    return -3.4028234663852886E38;
                }

                @Override
                public double getMaxY() {
                    return 3.4028234663852886E38;
                }

                @Override
                public boolean contains(double x, double y) {
                    return !component2D.contains(x, y);
                }

                @Override
                public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
                    PointValues.Relation relation = component2D.relate(minX, maxX, minY, maxY);
                    return switch (relation) {
                        default -> throw new MatchException(null, null);
                        case PointValues.Relation.CELL_INSIDE_QUERY -> PointValues.Relation.CELL_OUTSIDE_QUERY;
                        case PointValues.Relation.CELL_OUTSIDE_QUERY -> PointValues.Relation.CELL_INSIDE_QUERY;
                        case PointValues.Relation.CELL_CROSSES_QUERY -> PointValues.Relation.CELL_CROSSES_QUERY;
                    };
                }

                @Override
                public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Component2D.WithinRelation withinPoint(double x, double y) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InverseXYGeometry that = (InverseXYGeometry)o;
            return Arrays.equals(this.geometries, that.geometries);
        }

        public int hashCode() {
            return Arrays.hashCode(this.geometries);
        }
    }
}

