/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.ShapeDocValuesQuery;

public class LatLonShapeDocValuesQuery
extends ShapeDocValuesQuery<LatLonGeometry> {
    public LatLonShapeDocValuesQuery(String field, ShapeField.QueryRelation relation, LatLonGeometry ... geometries) {
        super(field, CoordinateEncoder.GEO, relation, geometries);
    }

    @Override
    protected Component2D create(LatLonGeometry[] geometries) {
        return LatLonGeometry.create(geometries);
    }

    @Override
    protected Component2D create(LatLonGeometry geometry) {
        return LatLonGeometry.create(geometry);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void add(List<Component2D> components2D, LatLonGeometry geometry) {
        if (geometry instanceof Rectangle) {
            Rectangle r = (Rectangle)geometry;
            if (r.minLon > r.maxLon) {
                super.add(components2D, new Rectangle(r.minLat, r.maxLat, r.minLon, 180.0));
                super.add(components2D, new Rectangle(r.minLat, r.maxLat, -180.0, r.maxLon));
                return;
            }
        }
        super.add(components2D, geometry);
    }
}

