/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.lucene.comparators.XNumericComparator;

public class XLongComparator
extends XNumericComparator<Long> {
    private final long[] values;
    protected long topValue;
    protected long bottom;

    public XLongComparator(int numHits, String field, Long missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : 0L, reverse, pruning, 8);
        this.values = new long[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Long.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Long value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Long value(int slot) {
        return this.values[slot];
    }

    @Override
    protected long missingValueAsComparableLong() {
        return (Long)this.missingValue;
    }

    @Override
    protected long sortableBytesToLong(byte[] bytes) {
        return NumericUtils.sortableBytesToLong(bytes, 0);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new LongLeafComparator(context);
    }

    public class LongLeafComparator
    extends XNumericComparator.NumericLeafComparator {
        public LongLeafComparator(LeafReaderContext context) throws IOException {
            super(XLongComparator.this, context);
        }

        @Override
        protected XNumericComparator.CompetitiveDISIBuilder buildCompetitiveDISIBuilder(LeafReaderContext context) throws IOException {
            return super.buildCompetitiveDISIBuilder(context);
        }

        private long getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return this.docValues.longValue();
            }
            return (Long)XLongComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            XLongComparator.this.bottom = XLongComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Long.compare(XLongComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Long.compare(XLongComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            XLongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return XLongComparator.this.bottom;
        }

        @Override
        protected long topAsComparableLong() {
            return XLongComparator.this.topValue;
        }
    }
}

