/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.injection.guice.Guice;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.Module;

public class ModulesBuilder
implements Iterable<Module> {
    private final List<Module> modules = new ArrayList<Module>();

    public ModulesBuilder add(Module ... newModules) {
        Collections.addAll(this.modules, newModules);
        return this;
    }

    public <T> T bindToInstance(Class<T> cls, T instance) {
        this.modules.add(b -> b.bind(cls).toInstance(instance));
        return instance;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    public Injector createInjector() {
        Injector injector = Guice.createInjector(this.modules);
        ((InjectorImpl)injector).clearCache();
        ((InjectorImpl)injector).readOnlyAllSingletons();
        return injector;
    }
}

