/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class GeoIpDownloaderStats
implements Task.Status {
    public static final GeoIpDownloaderStats EMPTY = new GeoIpDownloaderStats(0, 0, 0L, 0, 0, 0);
    static final ParseField SUCCESSFUL_DOWNLOADS = new ParseField("successful_downloads", new String[0]);
    static final ParseField FAILED_DOWNLOADS = new ParseField("failed_downloads", new String[0]);
    static final ParseField TOTAL_DOWNLOAD_TIME = new ParseField("total_download_time", new String[0]);
    static final ParseField DATABASES_COUNT = new ParseField("databases_count", new String[0]);
    static final ParseField SKIPPED_DOWNLOADS = new ParseField("skipped_updates", new String[0]);
    static final ParseField EXPIRED_DATABASES = new ParseField("expired_databases", new String[0]);
    private final int successfulDownloads;
    private final int failedDownloads;
    private final long totalDownloadTime;
    private final int databasesCount;
    private final int skippedDownloads;
    private final int expiredDatabases;

    public GeoIpDownloaderStats(StreamInput in) throws IOException {
        this.successfulDownloads = in.readVInt();
        this.failedDownloads = in.readVInt();
        this.totalDownloadTime = in.readVLong();
        this.databasesCount = in.readVInt();
        this.skippedDownloads = in.readVInt();
        this.expiredDatabases = in.readVInt();
    }

    GeoIpDownloaderStats(int successfulDownloads, int failedDownloads, long totalDownloadTime, int databasesCount, int skippedDownloads, int expiredDatabases) {
        this.successfulDownloads = successfulDownloads;
        this.failedDownloads = failedDownloads;
        this.totalDownloadTime = totalDownloadTime;
        this.databasesCount = databasesCount;
        this.skippedDownloads = skippedDownloads;
        this.expiredDatabases = expiredDatabases;
    }

    public int getSuccessfulDownloads() {
        return this.successfulDownloads;
    }

    public int getFailedDownloads() {
        return this.failedDownloads;
    }

    public long getTotalDownloadTime() {
        return this.totalDownloadTime;
    }

    public int getDatabasesCount() {
        return this.databasesCount;
    }

    public int getSkippedDownloads() {
        return this.skippedDownloads;
    }

    public int getExpiredDatabases() {
        return this.expiredDatabases;
    }

    public GeoIpDownloaderStats skippedDownload() {
        return new GeoIpDownloaderStats(this.successfulDownloads, this.failedDownloads, this.totalDownloadTime, this.databasesCount, this.skippedDownloads + 1, this.expiredDatabases);
    }

    public GeoIpDownloaderStats successfulDownload(long downloadTime) {
        return new GeoIpDownloaderStats(this.successfulDownloads + 1, this.failedDownloads, this.totalDownloadTime + Math.max(downloadTime, 0L), this.databasesCount, this.skippedDownloads, this.expiredDatabases);
    }

    public GeoIpDownloaderStats failedDownload() {
        return new GeoIpDownloaderStats(this.successfulDownloads, this.failedDownloads + 1, this.totalDownloadTime, this.databasesCount, this.skippedDownloads, this.expiredDatabases);
    }

    public GeoIpDownloaderStats databasesCount(int databasesCount) {
        return new GeoIpDownloaderStats(this.successfulDownloads, this.failedDownloads, this.totalDownloadTime, databasesCount, this.skippedDownloads, this.expiredDatabases);
    }

    public GeoIpDownloaderStats expiredDatabases(int expiredDatabases) {
        return new GeoIpDownloaderStats(this.successfulDownloads, this.failedDownloads, this.totalDownloadTime, this.databasesCount, this.skippedDownloads, expiredDatabases);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCESSFUL_DOWNLOADS.getPreferredName(), this.successfulDownloads);
        builder.field(FAILED_DOWNLOADS.getPreferredName(), this.failedDownloads);
        builder.field(TOTAL_DOWNLOAD_TIME.getPreferredName(), this.totalDownloadTime);
        builder.field(DATABASES_COUNT.getPreferredName(), this.databasesCount);
        builder.field(SKIPPED_DOWNLOADS.getPreferredName(), this.skippedDownloads);
        builder.field(EXPIRED_DATABASES.getPreferredName(), this.expiredDatabases);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.successfulDownloads);
        out.writeVInt(this.failedDownloads);
        out.writeVLong(this.totalDownloadTime);
        out.writeVInt(this.databasesCount);
        out.writeVInt(this.skippedDownloads);
        out.writeVInt(this.expiredDatabases);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoIpDownloaderStats that = (GeoIpDownloaderStats)o;
        return this.successfulDownloads == that.successfulDownloads && this.failedDownloads == that.failedDownloads && this.totalDownloadTime == that.totalDownloadTime && this.databasesCount == that.databasesCount && this.skippedDownloads == that.skippedDownloads && this.expiredDatabases == that.expiredDatabases;
    }

    public int hashCode() {
        return Objects.hash(this.successfulDownloads, this.failedDownloads, this.totalDownloadTime, this.databasesCount, this.skippedDownloads, this.expiredDatabases);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public String getWriteableName() {
        return "geoip-downloader";
    }
}

