/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.CefParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class CefProcessor
extends AbstractProcessor {
    public static final String TYPE = "cef";
    final String field;
    final String targetField;
    final boolean ignoreMissing;
    final boolean ignoreEmptyValues;
    private final TemplateScript.Factory timezone;

    CefProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, boolean ignoreEmptyValues, @Nullable TemplateScript.Factory timezone) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.ignoreEmptyValues = ignoreEmptyValues;
        this.timezone = timezone;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        String line = document.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (line == null && this.ignoreMissing) {
            return document;
        }
        if (line == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        ZoneId timezone = this.getTimezone(document);
        try (CefParser.CefEvent event = new CefParser(timezone, this.ignoreEmptyValues).process(line);){
            event.getRootMappings().forEach(document::setFieldValue);
            event.getCefMappings().forEach((k, v) -> document.setFieldValue(this.targetField + "." + k, v));
        }
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    ZoneId getTimezone(IngestDocument document) {
        String value;
        String string = value = this.timezone == null ? null : document.renderTemplate(this.timezone);
        if (value == null) {
            return ZoneOffset.UTC;
        }
        return ZoneId.of(value);
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public CefProcessor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) {
            String field = ConfigurationUtils.readStringProperty(CefProcessor.TYPE, tag, config, "field");
            String targetField = ConfigurationUtils.readStringProperty(CefProcessor.TYPE, tag, config, "target_field", CefProcessor.TYPE);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(CefProcessor.TYPE, tag, config, "ignore_missing", false);
            boolean ignoreEmptyValues = ConfigurationUtils.readBooleanProperty(CefProcessor.TYPE, tag, config, "ignore_empty_values", true);
            String timezoneString = ConfigurationUtils.readOptionalStringProperty(CefProcessor.TYPE, tag, config, "timezone");
            TemplateScript.Factory compiledTimezoneTemplate = null;
            if (timezoneString != null) {
                compiledTimezoneTemplate = ConfigurationUtils.compileTemplate(CefProcessor.TYPE, tag, "timezone", timezoneString, this.scriptService);
            }
            return new CefProcessor(tag, description, field, targetField, ignoreMissing, ignoreEmptyValues, compiledTimezoneTemplate);
        }
    }
}

