/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.core.Nullable;

final class CefParser {
    private final boolean ignoreEmptyValues;
    private final ZoneId timezone;
    private static final Pattern MAC_ADDRESS_PATTERN = Pattern.compile(String.join((CharSequence)"|", "(?:[0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}", "(?:[0-9A-Fa-f]{4}\\.){2}[0-9A-Fa-f]{4}", "(?:[0-9A-Fa-f]{2}[:-]){7}[0-9A-Fa-f]{2}", "(?:[0-9A-Fa-f]{4}\\.){3}[0-9A-Fa-f]{4}"));
    private static final int EUI48_HEX_LENGTH = 12;
    private static final int EUI64_HEX_LENGTH = 16;
    private static final int EUI64_HEX_WITH_SEPARATOR_MAX_LENGTH = 23;
    private static final Map<String, ExtensionMapping> EXTENSION_MAPPINGS = Map.ofEntries(Map.entry("agt", new ExtensionMapping("agentAddress", DataType.IPType, "agent.ip")), Map.entry("agentDnsDomain", new ExtensionMapping("agentDnsDomain", DataType.StringType, "agent.name")), Map.entry("ahost", new ExtensionMapping("agentHostName", DataType.StringType, "agent.name")), Map.entry("aid", new ExtensionMapping("agentId", DataType.StringType, "agent.id")), Map.entry("amac", new ExtensionMapping("agentMacAddress", DataType.MACAddressType, "agent.mac")), Map.entry("agentNtDomain", new ExtensionMapping("agentNtDomain", DataType.StringType, null)), Map.entry("art", new ExtensionMapping("agentReceiptTime", DataType.TimestampType, "event.created")), Map.entry("atz", new ExtensionMapping("agentTimeZone", DataType.StringType, null)), Map.entry("agentTranslatedAddress", new ExtensionMapping("agentTranslatedAddress", DataType.IPType, null)), Map.entry("agentTranslatedZoneExternalID", new ExtensionMapping("agentTranslatedZoneExternalID", DataType.StringType, null)), Map.entry("agentTranslatedZoneURI", new ExtensionMapping("agentTranslatedZoneURI", DataType.StringType, null)), Map.entry("at", new ExtensionMapping("agentType", DataType.StringType, "agent.type")), Map.entry("av", new ExtensionMapping("agentVersion", DataType.StringType, "agent.version")), Map.entry("agentZoneExternalID", new ExtensionMapping("agentZoneExternalID", DataType.StringType, null)), Map.entry("agentZoneURI", new ExtensionMapping("agentZoneURI", DataType.StringType, null)), Map.entry("app", new ExtensionMapping("applicationProtocol", DataType.StringType, "network.protocol")), Map.entry("cnt", new ExtensionMapping("baseEventCount", DataType.IntegerType, null)), Map.entry("in", new ExtensionMapping("bytesIn", DataType.LongType, "source.bytes")), Map.entry("out", new ExtensionMapping("bytesOut", DataType.LongType, "destination.bytes")), Map.entry("customerExternalID", new ExtensionMapping("customerExternalID", DataType.StringType, "organization.id")), Map.entry("customerURI", new ExtensionMapping("customerURI", DataType.StringType, "organization.name")), Map.entry("dst", new ExtensionMapping("destinationAddress", DataType.IPType, "destination.ip")), Map.entry("destinationDnsDomain", new ExtensionMapping("destinationDnsDomain", DataType.StringType, "destination.registered_domain")), Map.entry("dlat", new ExtensionMapping("destinationGeoLatitude", DataType.DoubleType, "destination.geo.location.lat")), Map.entry("dlong", new ExtensionMapping("destinationGeoLongitude", DataType.DoubleType, "destination.geo.location.lon")), Map.entry("dhost", new ExtensionMapping("destinationHostName", DataType.StringType, "destination.domain")), Map.entry("dmac", new ExtensionMapping("destinationMacAddress", DataType.MACAddressType, "destination.mac")), Map.entry("dntdom", new ExtensionMapping("destinationNtDomain", DataType.StringType, "destination.registered_domain")), Map.entry("dpt", new ExtensionMapping("destinationPort", DataType.IntegerType, "destination.port")), Map.entry("dpid", new ExtensionMapping("destinationProcessId", DataType.IntegerType, "destination.process.pid")), Map.entry("dproc", new ExtensionMapping("destinationProcessName", DataType.StringType, "destination.process.name")), Map.entry("destinationServiceName", new ExtensionMapping("destinationServiceName", DataType.StringType, "destination.service.name")), Map.entry("destinationTranslatedAddress", new ExtensionMapping("destinationTranslatedAddress", DataType.IPType, "destination.nat.ip")), Map.entry("destinationTranslatedPort", new ExtensionMapping("destinationTranslatedPort", DataType.IntegerType, "destination.nat.port")), Map.entry("destinationTranslatedZoneExternalID", new ExtensionMapping("destinationTranslatedZoneExternalID", DataType.StringType, null)), Map.entry("destinationTranslatedZoneURI", new ExtensionMapping("destinationTranslatedZoneURI", DataType.StringType, null)), Map.entry("duid", new ExtensionMapping("destinationUserId", DataType.StringType, "destination.user.id")), Map.entry("duser", new ExtensionMapping("destinationUserName", DataType.StringType, "destination.user.name")), Map.entry("dpriv", new ExtensionMapping("destinationUserPrivileges", DataType.StringType, "destination.user.group.name")), Map.entry("destinationZoneExternalID", new ExtensionMapping("destinationZoneExternalID", DataType.StringType, null)), Map.entry("destinationZoneURI", new ExtensionMapping("destinationZoneURI", DataType.StringType, null)), Map.entry("act", new ExtensionMapping("deviceAction", DataType.StringType, "event.action")), Map.entry("dvc", new ExtensionMapping("deviceAddress", DataType.IPType, "observer.ip")), Map.entry("cfp1Label", new ExtensionMapping("deviceCustomFloatingPoint1Label", DataType.StringType, null)), Map.entry("cfp3Label", new ExtensionMapping("deviceCustomFloatingPoint3Label", DataType.StringType, null)), Map.entry("cfp4Label", new ExtensionMapping("deviceCustomFloatingPoint4Label", DataType.StringType, null)), Map.entry("deviceCustomDate1", new ExtensionMapping("deviceCustomDate1", DataType.TimestampType, null)), Map.entry("deviceCustomDate1Label", new ExtensionMapping("deviceCustomDate1Label", DataType.StringType, null)), Map.entry("deviceCustomDate2", new ExtensionMapping("deviceCustomDate2", DataType.TimestampType, null)), Map.entry("deviceCustomDate2Label", new ExtensionMapping("deviceCustomDate2Label", DataType.StringType, null)), Map.entry("cfp1", new ExtensionMapping("deviceCustomFloatingPoint1", DataType.DoubleType, null)), Map.entry("cfp2", new ExtensionMapping("deviceCustomFloatingPoint2", DataType.DoubleType, null)), Map.entry("cfp2Label", new ExtensionMapping("deviceCustomFloatingPoint2Label", DataType.StringType, null)), Map.entry("cfp3", new ExtensionMapping("deviceCustomFloatingPoint3", DataType.DoubleType, null)), Map.entry("cfp4", new ExtensionMapping("deviceCustomFloatingPoint4", DataType.DoubleType, null)), Map.entry("c6a1", new ExtensionMapping("deviceCustomIPv6Address1", DataType.IPType, null)), Map.entry("c6a1Label", new ExtensionMapping("deviceCustomIPv6Address1Label", DataType.StringType, null)), Map.entry("c6a2", new ExtensionMapping("deviceCustomIPv6Address2", DataType.IPType, null)), Map.entry("c6a2Label", new ExtensionMapping("deviceCustomIPv6Address2Label", DataType.StringType, null)), Map.entry("c6a3", new ExtensionMapping("deviceCustomIPv6Address3", DataType.IPType, null)), Map.entry("c6a3Label", new ExtensionMapping("deviceCustomIPv6Address3Label", DataType.StringType, null)), Map.entry("c6a4", new ExtensionMapping("deviceCustomIPv6Address4", DataType.IPType, null)), Map.entry("c6a4Label", new ExtensionMapping("deviceCustomIPv6Address4Label", DataType.StringType, null)), Map.entry("cn1", new ExtensionMapping("deviceCustomNumber1", DataType.LongType, null)), Map.entry("cn1Label", new ExtensionMapping("deviceCustomNumber1Label", DataType.StringType, null)), Map.entry("cn2", new ExtensionMapping("deviceCustomNumber2", DataType.LongType, null)), Map.entry("cn2Label", new ExtensionMapping("deviceCustomNumber2Label", DataType.StringType, null)), Map.entry("cn3", new ExtensionMapping("deviceCustomNumber3", DataType.LongType, null)), Map.entry("cn3Label", new ExtensionMapping("deviceCustomNumber3Label", DataType.StringType, null)), Map.entry("cs1", new ExtensionMapping("deviceCustomString1", DataType.StringType, null)), Map.entry("cs1Label", new ExtensionMapping("deviceCustomString1Label", DataType.StringType, null)), Map.entry("cs2", new ExtensionMapping("deviceCustomString2", DataType.StringType, null)), Map.entry("cs2Label", new ExtensionMapping("deviceCustomString2Label", DataType.StringType, null)), Map.entry("cs3", new ExtensionMapping("deviceCustomString3", DataType.StringType, null)), Map.entry("cs3Label", new ExtensionMapping("deviceCustomString3Label", DataType.StringType, null)), Map.entry("cs4", new ExtensionMapping("deviceCustomString4", DataType.StringType, null)), Map.entry("cs4Label", new ExtensionMapping("deviceCustomString4Label", DataType.StringType, null)), Map.entry("cs5", new ExtensionMapping("deviceCustomString5", DataType.StringType, null)), Map.entry("cs5Label", new ExtensionMapping("deviceCustomString5Label", DataType.StringType, null)), Map.entry("cs6", new ExtensionMapping("deviceCustomString6", DataType.StringType, null)), Map.entry("cs6Label", new ExtensionMapping("deviceCustomString6Label", DataType.StringType, null)), Map.entry("deviceDirection", new ExtensionMapping("deviceDirection", DataType.StringType, "network.direction")), Map.entry("deviceDnsDomain", new ExtensionMapping("deviceDnsDomain", DataType.StringType, "observer.registered_domain")), Map.entry("cat", new ExtensionMapping("deviceEventCategory", DataType.StringType, null)), Map.entry("deviceExternalId", new ExtensionMapping("deviceExternalId", DataType.StringType, "observer.name")), Map.entry("deviceFacility", new ExtensionMapping("deviceFacility", DataType.StringType, null)), Map.entry("dvchost", new ExtensionMapping("deviceHostName", DataType.StringType, "observer.hostname")), Map.entry("deviceInboundInterface", new ExtensionMapping("deviceInboundInterface", DataType.StringType, "observer.ingress.interface.name")), Map.entry("dvcmac", new ExtensionMapping("deviceMacAddress", DataType.MACAddressType, "observer.mac")), Map.entry("deviceNtDomain", new ExtensionMapping("deviceNtDomain", DataType.StringType, null)), Map.entry("deviceOutboundInterface", new ExtensionMapping("deviceOutboundInterface", DataType.StringType, "observer.egress.interface.name")), Map.entry("devicePayloadId", new ExtensionMapping("devicePayloadId", DataType.StringType, "event.id")), Map.entry("dvcpid", new ExtensionMapping("deviceProcessId", DataType.IntegerType, "process.pid")), Map.entry("deviceProcessName", new ExtensionMapping("deviceProcessName", DataType.StringType, "process.name")), Map.entry("rt", new ExtensionMapping("deviceReceiptTime", DataType.TimestampType, "@timestamp")), Map.entry("dtz", new ExtensionMapping("deviceTimeZone", DataType.StringType, "event.timezone")), Map.entry("deviceTranslatedAddress", new ExtensionMapping("deviceTranslatedAddress", DataType.IPType, "host.nat.ip")), Map.entry("deviceTranslatedZoneExternalID", new ExtensionMapping("deviceTranslatedZoneExternalID", DataType.StringType, null)), Map.entry("deviceTranslatedZoneURI", new ExtensionMapping("deviceTranslatedZoneURI", DataType.StringType, null)), Map.entry("deviceZoneExternalID", new ExtensionMapping("deviceZoneExternalID", DataType.StringType, null)), Map.entry("deviceZoneURI", new ExtensionMapping("deviceZoneURI", DataType.StringType, null)), Map.entry("end", new ExtensionMapping("endTime", DataType.TimestampType, "event.end")), Map.entry("eventId", new ExtensionMapping("eventId", DataType.StringType, "event.id")), Map.entry("outcome", new ExtensionMapping("eventOutcome", DataType.StringType, "event.outcome")), Map.entry("externalId", new ExtensionMapping("externalId", DataType.StringType, null)), Map.entry("fileCreateTime", new ExtensionMapping("fileCreateTime", DataType.TimestampType, "file.created")), Map.entry("fileHash", new ExtensionMapping("fileHash", DataType.StringType, "file.hash")), Map.entry("fileId", new ExtensionMapping("fileId", DataType.StringType, "file.inode")), Map.entry("fileModificationTime", new ExtensionMapping("fileModificationTime", DataType.TimestampType, "file.mtime")), Map.entry("flexNumber1", new ExtensionMapping("deviceFlexNumber1", DataType.LongType, null)), Map.entry("flexNumber1Label", new ExtensionMapping("deviceFlexNumber1Label", DataType.StringType, null)), Map.entry("flexNumber2", new ExtensionMapping("deviceFlexNumber2", DataType.LongType, null)), Map.entry("flexNumber2Label", new ExtensionMapping("deviceFlexNumber2Label", DataType.StringType, null)), Map.entry("fname", new ExtensionMapping("filename", DataType.StringType, "file.name")), Map.entry("filePath", new ExtensionMapping("filePath", DataType.StringType, "file.path")), Map.entry("filePermission", new ExtensionMapping("filePermission", DataType.StringType, "file.group")), Map.entry("fsize", new ExtensionMapping("fileSize", DataType.LongType, "file.size")), Map.entry("fileType", new ExtensionMapping("fileType", DataType.StringType, "file.type")), Map.entry("flexDate1", new ExtensionMapping("flexDate1", DataType.TimestampType, null)), Map.entry("flexDate1Label", new ExtensionMapping("flexDate1Label", DataType.StringType, null)), Map.entry("flexString1", new ExtensionMapping("flexString1", DataType.StringType, null)), Map.entry("flexString2", new ExtensionMapping("flexString2", DataType.StringType, null)), Map.entry("flexString1Label", new ExtensionMapping("flexString1Label", DataType.StringType, null)), Map.entry("flexString2Label", new ExtensionMapping("flexString2Label", DataType.StringType, null)), Map.entry("msg", new ExtensionMapping("message", DataType.StringType, "message")), Map.entry("oldFileCreateTime", new ExtensionMapping("oldFileCreateTime", DataType.TimestampType, null)), Map.entry("oldFileHash", new ExtensionMapping("oldFileHash", DataType.StringType, null)), Map.entry("oldFileId", new ExtensionMapping("oldFileId", DataType.StringType, null)), Map.entry("oldFileModificationTime", new ExtensionMapping("oldFileModificationTime", DataType.TimestampType, null)), Map.entry("oldFileName", new ExtensionMapping("oldFileName", DataType.StringType, null)), Map.entry("oldFilePath", new ExtensionMapping("oldFilePath", DataType.StringType, null)), Map.entry("oldFilePermission", new ExtensionMapping("oldFilePermission", DataType.StringType, null)), Map.entry("oldFileSize", new ExtensionMapping("oldFileSize", DataType.LongType, null)), Map.entry("oldFileType", new ExtensionMapping("oldFileType", DataType.StringType, null)), Map.entry("rawEvent", new ExtensionMapping("rawEvent", DataType.StringType, "event.original")), Map.entry("reason", new ExtensionMapping("reason", DataType.StringType, "event.reason")), Map.entry("requestClientApplication", new ExtensionMapping("requestClientApplication", DataType.StringType, "user_agent.original")), Map.entry("requestContext", new ExtensionMapping("requestContext", DataType.StringType, "http.request.referrer")), Map.entry("requestCookies", new ExtensionMapping("requestCookies", DataType.StringType, null)), Map.entry("requestMethod", new ExtensionMapping("requestMethod", DataType.StringType, "http.request.method")), Map.entry("request", new ExtensionMapping("requestUrl", DataType.StringType, "url.original")), Map.entry("src", new ExtensionMapping("sourceAddress", DataType.IPType, "source.ip")), Map.entry("sourceDnsDomain", new ExtensionMapping("sourceDnsDomain", DataType.StringType, "source.domain")), Map.entry("slat", new ExtensionMapping("sourceGeoLatitude", DataType.DoubleType, "source.geo.location.lat")), Map.entry("slong", new ExtensionMapping("sourceGeoLongitude", DataType.DoubleType, "source.geo.location.lon")), Map.entry("shost", new ExtensionMapping("sourceHostName", DataType.StringType, "source.domain")), Map.entry("smac", new ExtensionMapping("sourceMacAddress", DataType.MACAddressType, "source.mac")), Map.entry("sntdom", new ExtensionMapping("sourceNtDomain", DataType.StringType, "source.registered_domain")), Map.entry("spt", new ExtensionMapping("sourcePort", DataType.IntegerType, "source.port")), Map.entry("spid", new ExtensionMapping("sourceProcessId", DataType.IntegerType, "source.process.pid")), Map.entry("sproc", new ExtensionMapping("sourceProcessName", DataType.StringType, "source.process.name")), Map.entry("sourceServiceName", new ExtensionMapping("sourceServiceName", DataType.StringType, "source.service.name")), Map.entry("sourceTranslatedAddress", new ExtensionMapping("sourceTranslatedAddress", DataType.IPType, "source.nat.ip")), Map.entry("sourceTranslatedPort", new ExtensionMapping("sourceTranslatedPort", DataType.IntegerType, "source.nat.port")), Map.entry("sourceTranslatedZoneExternalID", new ExtensionMapping("sourceTranslatedZoneExternalID", DataType.StringType, null)), Map.entry("sourceTranslatedZoneURI", new ExtensionMapping("sourceTranslatedZoneURI", DataType.StringType, null)), Map.entry("suid", new ExtensionMapping("sourceUserId", DataType.StringType, "source.user.id")), Map.entry("suser", new ExtensionMapping("sourceUserName", DataType.StringType, "source.user.name")), Map.entry("spriv", new ExtensionMapping("sourceUserPrivileges", DataType.StringType, "source.user.group.name")), Map.entry("sourceZoneExternalID", new ExtensionMapping("sourceZoneExternalID", DataType.StringType, null)), Map.entry("sourceZoneURI", new ExtensionMapping("sourceZoneURI", DataType.StringType, null)), Map.entry("start", new ExtensionMapping("startTime", DataType.TimestampType, "event.start")), Map.entry("proto", new ExtensionMapping("transportProtocol", DataType.StringType, "network.transport")), Map.entry("type", new ExtensionMapping("type", DataType.StringType, "event.kind")), Map.entry("catdt", new ExtensionMapping("categoryDeviceType", DataType.StringType, null)), Map.entry("mrt", new ExtensionMapping("managerReceiptTime", DataType.TimestampType, "event.ingested")), Map.entry("agentTranslatedZoneKey", new ExtensionMapping("agentTranslatedZoneKey", DataType.LongType, null)), Map.entry("agentZoneKey", new ExtensionMapping("agentZoneKey", DataType.LongType, null)), Map.entry("customerKey", new ExtensionMapping("customerKey", DataType.LongType, null)), Map.entry("destinationTranslatedZoneKey", new ExtensionMapping("destinationTranslatedZoneKey", DataType.LongType, null)), Map.entry("dZoneKey", new ExtensionMapping("destinationZoneKey", DataType.LongType, null)), Map.entry("deviceTranslatedZoneKey", new ExtensionMapping("deviceTranslatedZoneKey", DataType.LongType, null)), Map.entry("deviceZoneKey", new ExtensionMapping("deviceZoneKey", DataType.LongType, null)), Map.entry("sTranslatedZoneKey", new ExtensionMapping("sourceTranslatedZoneKey", DataType.LongType, null)), Map.entry("sZoneKey", new ExtensionMapping("sourceZoneKey", DataType.LongType, null)), Map.entry("parserVersion", new ExtensionMapping("parserVersion", DataType.StringType, null)), Map.entry("parserIdentifier", new ExtensionMapping("parserIdentifier", DataType.StringType, null)));
    private static final String INCOMPLETE_CEF_HEADER = "Incomplete CEF header";
    private static final String INVALID_CEF_FORMAT = "Invalid CEF format";
    private static final String UNESCAPED_EQUALS_SIGN = "CEF extensions contain unescaped equals sign";
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("MMM dd[ yyyy] HH:mm:ss[.SSS][ zzz]", Locale.ROOT);
    private static final List<ChronoField> CHRONO_FIELDS = List.of(ChronoField.NANO_OF_SECOND, ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR);

    CefParser(ZoneId timezone, boolean ignoreEmptyValues) {
        this.ignoreEmptyValues = ignoreEmptyValues;
        this.timezone = timezone;
    }

    CefEvent process(String cefString) {
        List<String> headers = CefParser.parseHeaders(cefString);
        Map<String, String> parsedExtensions = CefParser.parseExtensions(headers.removeLast(), this.ignoreEmptyValues);
        CefEvent event = new CefEvent();
        CefParser.processHeaders(headers, event);
        this.processExtensions(parsedExtensions, event);
        return event;
    }

    static List<String> parseHeaders(String cefString) {
        ArrayList<String> headers = new ArrayList<String>();
        int extensionStart = -1;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < cefString.length(); ++i) {
            char next;
            char curr = cefString.charAt(i);
            char c = next = i < cefString.length() - 1 ? cefString.charAt(i + 1) : (char)'\u0000';
            if (curr == '\\' && next == '\\') {
                buffer.append('\\');
                ++i;
                continue;
            }
            if (curr == '\\' && next == '|') {
                buffer.append('|');
                ++i;
                continue;
            }
            if (curr == '|') {
                headers.add(buffer.toString());
                buffer = new StringBuilder();
                if (headers.size() != 7) continue;
                extensionStart = i + 1;
                break;
            }
            buffer.append(curr);
        }
        if (headers.isEmpty() || !((String)headers.getFirst()).startsWith("CEF:")) {
            throw new IllegalArgumentException(INVALID_CEF_FORMAT);
        }
        if (headers.size() != 7) {
            throw new IllegalArgumentException(INCOMPLETE_CEF_HEADER);
        }
        String extensionString = cefString.substring(extensionStart);
        headers.add(extensionString);
        return headers;
    }

    private static void processHeaders(List<String> headers, CefEvent event) {
        block9: for (int i = 0; i < headers.size(); ++i) {
            String value = headers.get(i);
            switch (i) {
                case 0: {
                    event.addCefMapping("version", value.substring(4));
                    continue block9;
                }
                case 1: {
                    event.addCefMapping("device.vendor", value);
                    event.addRootMapping("observer.vendor", value);
                    continue block9;
                }
                case 2: {
                    event.addCefMapping("device.product", value);
                    event.addRootMapping("observer.product", value);
                    continue block9;
                }
                case 3: {
                    event.addCefMapping("device.version", value);
                    event.addRootMapping("observer.version", value);
                    continue block9;
                }
                case 4: {
                    event.addCefMapping("device.event_class_id", value);
                    event.addRootMapping("event.code", value);
                    continue block9;
                }
                case 5: {
                    event.addCefMapping("name", value);
                    continue block9;
                }
                case 6: {
                    event.addCefMapping("severity", value);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException(INVALID_CEF_FORMAT);
                }
            }
        }
    }

    static Map<String, String> parseExtensions(String extensionString) {
        return CefParser.parseExtensions(extensionString, false);
    }

    static Map<String, String> parseExtensions(String extensionString, boolean ignoreEmptyValues) {
        String value;
        char curr;
        int i;
        ArrayList<String> chunks = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < extensionString.length() && (curr = extensionString.charAt(i)) == ' '; ++i) {
        }
        while (i < extensionString.length()) {
            char next;
            curr = extensionString.charAt(i);
            char c = next = i < extensionString.length() - 1 ? extensionString.charAt(i + 1) : (char)'\u0000';
            if (curr == '\\') {
                if (next == '\\') {
                    buffer.append('\\');
                } else if (next == '=') {
                    buffer.append('=');
                } else if (next == 'n') {
                    buffer.append('\n');
                } else if (next == 'r') {
                    buffer.append('\r');
                } else if (next == 't') {
                    buffer.append('\t');
                } else {
                    throw new IllegalArgumentException("Illegal escape sequence '\\" + next + "'");
                }
                ++i;
            } else if (curr == '=') {
                chunks.add(buffer.toString());
                buffer = new StringBuilder();
            } else {
                buffer.append(curr);
            }
            ++i;
        }
        chunks.add(buffer.toString());
        if (chunks.size() == 1) {
            String chunk = (String)chunks.getFirst();
            if (chunk.isEmpty()) {
                return Map.of();
            }
            throw new IllegalArgumentException("Invalid extensions in the CEF event: " + chunk);
        }
        HashMap<String, String> extensions = HashMap.newHashMap(chunks.size() - 1);
        String key = (String)chunks.getFirst();
        if (key.isEmpty() || CefParser.containsWhitespace(key)) {
            throw new IllegalArgumentException(UNESCAPED_EQUALS_SIGN);
        }
        for (int j = 1; j < chunks.size() - 1; ++j) {
            String chunk = (String)chunks.get(j);
            int idx = chunk.lastIndexOf(32);
            value = idx == -1 ? "" : chunk.substring(0, idx);
            if (!ignoreEmptyValues || !Strings.isEmpty(value)) {
                extensions.put(key, value);
            }
            if (!(key = chunk.substring(idx + 1)).isEmpty() && !CefParser.containsWhitespace(key)) continue;
            throw new IllegalArgumentException(UNESCAPED_EQUALS_SIGN);
        }
        value = CefParser.stripTrailingWhitespace((String)chunks.getLast());
        if (!ignoreEmptyValues || !Strings.isEmpty(value)) {
            extensions.put(key, value);
        }
        return extensions;
    }

    private static String stripTrailingWhitespace(String str) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        return str.stripTrailing();
    }

    private static boolean containsWhitespace(String str) {
        if (Strings.hasLength(str)) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c)) continue;
                return true;
            }
        }
        return false;
    }

    private void processExtensions(Map<String, String> parsedExtensions, CefEvent event) {
        for (Map.Entry<String, String> entry : parsedExtensions.entrySet()) {
            ExtensionMapping mapping = EXTENSION_MAPPINGS.get(entry.getKey());
            if (mapping != null) {
                String ecsKey = mapping.ecsKey();
                if (ecsKey != null) {
                    event.addRootMapping(ecsKey, this.convertValueToType(entry.getValue(), mapping.dataType()));
                    continue;
                }
                event.addCefMapping("extensions." + mapping.key(), this.convertValueToType(entry.getValue(), mapping.dataType()));
                continue;
            }
            event.addCefMapping("extensions." + entry.getKey(), entry.getValue());
        }
    }

    private Object convertValueToType(String value, DataType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> value;
            case 0 -> Integer.parseInt(value);
            case 1 -> Long.parseLong(value);
            case 2 -> Double.parseDouble(value);
            case 6 -> this.toTimestamp(value);
            case 5 -> this.toMACAddress(value);
            case 4 -> this.toIP(value);
        };
    }

    private static boolean isDigits(String s) {
        if (!Strings.hasLength(s)) {
            return false;
        }
        int i = 0;
        if (s.length() > 1 && (s.charAt(0) == '+' || s.charAt(0) == '-')) {
            ++i;
        }
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    ZonedDateTime toTimestamp(String value) {
        if (CefParser.isDigits(value)) {
            try {
                long milliseconds = Long.parseLong(value);
                return Instant.ofEpochMilli(milliseconds).atZone(this.timezone);
            }
            catch (NumberFormatException milliseconds) {
                // empty catch block
            }
        }
        try {
            TemporalAccessor accessor = TIME_FORMAT.parse(value);
            if (!(accessor.isSupported(ChronoField.YEAR) || accessor.isSupported(ChronoField.YEAR_OF_ERA) || accessor.isSupported(WeekFields.ISO.weekBasedYear()) || accessor.isSupported(WeekFields.of(Locale.ROOT).weekBasedYear()) || accessor.isSupported(ChronoField.INSTANT_SECONDS))) {
                int year = LocalDate.now(ZoneOffset.UTC).getYear();
                ZonedDateTime newTime = Instant.EPOCH.atZone(ZoneOffset.UTC).withYear(year);
                for (ChronoField field : CHRONO_FIELDS) {
                    if (!accessor.isSupported(field)) continue;
                    newTime = newTime.with(field, accessor.get(field));
                }
                accessor = newTime.withZoneSameLocal(this.timezone);
            }
            return DateFormatters.from(accessor, Locale.ROOT, this.timezone).withZoneSameInstant(this.timezone);
        }
        catch (DateTimeParseException ignored) {
            throw new IllegalArgumentException("Value is not a valid timestamp: " + value);
        }
    }

    String toMACAddress(String v) throws IllegalArgumentException {
        String macWithSeparators = CefParser.insertMACSeparators(v);
        Matcher matcher = MAC_ADDRESS_PATTERN.matcher(macWithSeparators);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid MAC address format");
        }
        return macWithSeparators;
    }

    String toIP(String v) {
        try {
            return NetworkAddress.format(InetAddresses.forString(v));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid IP address format", e);
        }
    }

    private static String insertMACSeparators(String v) {
        if (v.length() != 12 && v.length() != 16 || v.charAt(2) == ':' || v.charAt(2) == '-' || v.charAt(4) == '.') {
            return v;
        }
        StringBuilder sb = new StringBuilder(23);
        for (int i = 0; i < v.length(); ++i) {
            sb.append(v.charAt(i));
            if (i >= v.length() - 1 || i % 2 == 0) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    static class CefEvent
    implements AutoCloseable {
        private Map<String, Object> rootMappings = new HashMap<String, Object>();
        private Map<String, Object> cefMappings = new HashMap<String, Object>();

        CefEvent() {
        }

        void addRootMapping(String key, Object value) {
            this.rootMappings.put(key, value);
        }

        void addCefMapping(String key, Object value) {
            this.cefMappings.put(key, value);
        }

        Map<String, Object> getRootMappings() {
            return Objects.requireNonNull(this.rootMappings);
        }

        Map<String, Object> getCefMappings() {
            return Objects.requireNonNull(this.cefMappings);
        }

        @Override
        public void close() {
            this.rootMappings = null;
            this.cefMappings = null;
        }
    }

    private record ExtensionMapping(String key, DataType dataType, @Nullable String ecsKey) {
        ExtensionMapping {
            Objects.requireNonNull(key);
            Objects.requireNonNull(dataType);
        }
    }

    static enum DataType {
        IntegerType,
        LongType,
        DoubleType,
        StringType,
        IPType,
        MACAddressType,
        TimestampType;

    }
}

