/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class AppendProcessor
extends AbstractProcessor {
    public static final String TYPE = "append";
    private final TemplateScript.Factory field;
    private final ValueSource value;
    private final String copyFrom;
    private final boolean allowDuplicates;
    private final boolean ignoreEmptyValues;

    AppendProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, String copyFrom, boolean allowDuplicates, boolean ignoreEmptyValues) {
        super(tag, description);
        this.field = field;
        this.value = value;
        this.copyFrom = copyFrom;
        this.allowDuplicates = allowDuplicates;
        this.ignoreEmptyValues = ignoreEmptyValues;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public String getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public IngestDocument execute(IngestDocument document) throws Exception {
        String path = document.renderTemplate(this.field);
        if (this.copyFrom != null) {
            Object fieldValue = document.getFieldValue(this.copyFrom, Object.class, this.ignoreEmptyValues);
            document.appendFieldValue(path, IngestDocument.deepCopy(fieldValue), this.allowDuplicates, this.ignoreEmptyValues);
        } else {
            document.appendFieldValue(path, this.value, this.allowDuplicates, this.ignoreEmptyValues);
        }
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public AppendProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(AppendProcessor.TYPE, processorTag, config, "field");
            String copyFrom = ConfigurationUtils.readOptionalStringProperty(AppendProcessor.TYPE, processorTag, config, "copy_from");
            String mediaType = ConfigurationUtils.readMediaTypeProperty(AppendProcessor.TYPE, processorTag, config, "media_type", "application/json");
            ValueSource valueSource = null;
            if (copyFrom == null) {
                value = ConfigurationUtils.readObject(AppendProcessor.TYPE, processorTag, config, "value");
                valueSource = ValueSource.wrap(value, this.scriptService, Map.of("content_type", mediaType));
            } else {
                value = config.remove("value");
                if (value != null) {
                    throw ConfigurationUtils.newConfigurationException(AppendProcessor.TYPE, processorTag, "copy_from", "cannot set both `copy_from` and `value` in the same processor");
                }
            }
            boolean allowDuplicates = ConfigurationUtils.readBooleanProperty(AppendProcessor.TYPE, processorTag, config, "allow_duplicates", true);
            boolean ignoreEmptyValues = ConfigurationUtils.readBooleanProperty(AppendProcessor.TYPE, processorTag, config, "ignore_empty_values", false);
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate(AppendProcessor.TYPE, processorTag, "field", field, this.scriptService);
            return new AppendProcessor(processorTag, description, compiledTemplate, valueSource, copyFrom, allowDuplicates, ignoreEmptyValues);
        }
    }
}

