/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestPipelineMetric;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record IngestStats(Stats totalStats, List<PipelineStat> pipelineStats, Map<ProjectId, Map<String, List<ProcessorStat>>> processorStats) implements Writeable,
ChunkedToXContent
{
    private static final Comparator<PipelineStat> PIPELINE_STAT_COMPARATOR = Comparator.comparingLong(p -> p.stats.ingestTimeInMillis).thenComparingLong(p -> p.stats.ingestCount).thenComparingLong(p -> p.byteStats.bytesProduced);
    public static final IngestStats IDENTITY = new IngestStats(Stats.IDENTITY, List.of(), Map.of());
    private static final TransportVersion NODES_STATS_SUPPORTS_MULTI_PROJECT = TransportVersion.fromName("nodes_stats_supports_multi_project");

    public IngestStats {
        pipelineStats = pipelineStats.stream().sorted(PIPELINE_STAT_COMPARATOR).toList();
    }

    public static IngestStats read(StreamInput in) throws IOException {
        HashMap namesAndTypesCache = new HashMap();
        Stats stats = IngestStats.readStats(in);
        int size = in.readVInt();
        if (stats == Stats.IDENTITY && size == 0) {
            return IDENTITY;
        }
        ArrayList<PipelineStat> pipelineStats = new ArrayList<PipelineStat>(size);
        HashMap<ProjectId, Map> processorStats = new HashMap<ProjectId, Map>();
        for (int i = 0; i < size; ++i) {
            ProjectId projectId = in.getTransportVersion().supports(NODES_STATS_SUPPORTS_MULTI_PROJECT) ? ProjectId.readFrom(in) : Metadata.DEFAULT_PROJECT_ID;
            String pipelineId = in.readString();
            Stats pipelineStat = IngestStats.readStats(in);
            ByteStats byteStat = IngestStats.readByteStats(in);
            pipelineStats.add(new PipelineStat(projectId, pipelineId, pipelineStat, byteStat));
            int processorsSize = in.readVInt();
            ArrayList<ProcessorStat> processorStatsPerPipeline = new ArrayList<ProcessorStat>(processorsSize);
            for (int j = 0; j < processorsSize; ++j) {
                String processorName = in.readString();
                String processorType = in.readString();
                Stats processorStat = IngestStats.readStats(in);
                processorName = (String)namesAndTypesCache.computeIfAbsent(processorName, Function.identity());
                processorType = (String)namesAndTypesCache.computeIfAbsent(processorType, Function.identity());
                processorStatsPerPipeline.add(new ProcessorStat(processorName, processorType, processorStat));
            }
            processorStats.computeIfAbsent(projectId, k -> new HashMap()).put(pipelineId, Collections.unmodifiableList(processorStatsPerPipeline));
        }
        return new IngestStats(stats, pipelineStats, Collections.unmodifiableMap(processorStats));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.pipelineStats.size());
        for (PipelineStat pipelineStat : this.pipelineStats) {
            if (out.getTransportVersion().supports(NODES_STATS_SUPPORTS_MULTI_PROJECT)) {
                pipelineStat.projectId().writeTo(out);
            }
            out.writeString(pipelineStat.pipelineId());
            pipelineStat.stats().writeTo(out);
            pipelineStat.byteStats().writeTo(out);
            List processorStatsForPipeline = (List)this.processorStats.getOrDefault(pipelineStat.projectId(), Map.of()).get(pipelineStat.pipelineId());
            if (processorStatsForPipeline == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeCollection(processorStatsForPipeline, (o, processorStat) -> {
                o.writeString(processorStat.name());
                o.writeString(processorStat.type());
                processorStat.stats().writeTo(o);
            });
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject("ingest");
            builder.startObject("total");
            this.totalStats.toXContent(builder, params);
            builder.endObject();
            builder.startObject("pipelines");
            return builder;
        }), Iterators.flatMap(this.pipelineStats.iterator(), pipelineStat -> Iterators.concat(Iterators.single((builder, params) -> {
            String key = outerParams.paramAsBoolean("multi_project_enabled_node_stats", false) ? String.valueOf(pipelineStat.projectId()) + "/" + pipelineStat.pipelineId() : pipelineStat.pipelineId();
            builder.startObject(key);
            pipelineStat.stats().toXContent(builder, params);
            pipelineStat.byteStats().toXContent(builder, params);
            builder.startArray("processors");
            return builder;
        }), Iterators.map(this.processorStats.getOrDefault(pipelineStat.projectId(), Map.of()).getOrDefault(pipelineStat.pipelineId(), List.of()).iterator(), processorStat -> (builder, params) -> {
            builder.startObject();
            builder.startObject(processorStat.name());
            builder.field("type", processorStat.type());
            builder.startObject("stats");
            processorStat.stats().toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray().endObject()))), Iterators.single((builder, params) -> builder.endObject().endObject()));
    }

    public static IngestStats merge(IngestStats first, IngestStats second) {
        return new IngestStats(Stats.merge(first.totalStats, second.totalStats), PipelineStat.merge(first.pipelineStats, second.pipelineStats), IngestStats.merge(first.processorStats, second.processorStats));
    }

    static Map<ProjectId, Map<String, List<ProcessorStat>>> merge(Map<ProjectId, Map<String, List<ProcessorStat>>> first, Map<ProjectId, Map<String, List<ProcessorStat>>> second) {
        HashMap<ProjectId, Map<String, List<ProcessorStat>>> totals = new HashMap<ProjectId, Map<String, List<ProcessorStat>>>();
        first.forEach((projectId, statsByPipeline) -> totals.merge((ProjectId)projectId, (Map<String, List<ProcessorStat>>)statsByPipeline, IngestStats::innerMerge));
        second.forEach((projectId, statsByPipeline) -> totals.merge((ProjectId)projectId, (Map<String, List<ProcessorStat>>)statsByPipeline, IngestStats::innerMerge));
        return totals;
    }

    private static Map<String, List<ProcessorStat>> innerMerge(Map<String, List<ProcessorStat>> first, Map<String, List<ProcessorStat>> second) {
        HashMap<String, List<ProcessorStat>> totalsPerPipelineProcessor = new HashMap<String, List<ProcessorStat>>();
        first.forEach((pipelineId, stats) -> totalsPerPipelineProcessor.merge((String)pipelineId, (List<ProcessorStat>)stats, ProcessorStat::merge));
        second.forEach((pipelineId, stats) -> totalsPerPipelineProcessor.merge((String)pipelineId, (List<ProcessorStat>)stats, ProcessorStat::merge));
        return totalsPerPipelineProcessor;
    }

    private static Stats readStats(StreamInput in) throws IOException {
        long ingestCount = in.readVLong();
        long ingestTimeInMillis = in.readVLong();
        long ingestCurrent = in.readVLong();
        long ingestFailedCount = in.readVLong();
        if (ingestCount == 0L && ingestTimeInMillis == 0L && ingestCurrent == 0L && ingestFailedCount == 0L) {
            return Stats.IDENTITY;
        }
        return new Stats(ingestCount, ingestTimeInMillis, ingestCurrent, ingestFailedCount);
    }

    static ByteStats readByteStats(StreamInput in) throws IOException {
        long bytesIngested = in.readVLong();
        long bytesProduced = in.readVLong();
        if (bytesProduced == 0L && bytesIngested == 0L) {
            return ByteStats.IDENTITY;
        }
        return new ByteStats(bytesIngested, bytesProduced);
    }

    public record Stats(long ingestCount, long ingestTimeInMillis, long ingestCurrent, long ingestFailedCount) implements Writeable,
    ToXContentFragment
    {
        public static final Stats IDENTITY = new Stats(0L, 0L, 0L, 0L);

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.ingestCount);
            out.writeVLong(this.ingestTimeInMillis);
            out.writeVLong(this.ingestCurrent);
            out.writeVLong(this.ingestFailedCount);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.ingestCount);
            builder.humanReadableField("time_in_millis", "time", new TimeValue(this.ingestTimeInMillis, TimeUnit.MILLISECONDS));
            builder.field("current", this.ingestCurrent);
            builder.field("failed", this.ingestFailedCount);
            return builder;
        }

        static Stats merge(Stats first, Stats second) {
            return new Stats(first.ingestCount + second.ingestCount, first.ingestTimeInMillis + second.ingestTimeInMillis, first.ingestCurrent + second.ingestCurrent, first.ingestFailedCount + second.ingestFailedCount);
        }
    }

    public record ByteStats(long bytesIngested, long bytesProduced) implements Writeable,
    ToXContentFragment
    {
        public static final ByteStats IDENTITY = new ByteStats(0L, 0L);

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.bytesIngested);
            out.writeVLong(this.bytesProduced);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.humanReadableField("ingested_as_first_pipeline_in_bytes", "ingested_as_first_pipeline", ByteSizeValue.ofBytes(this.bytesIngested));
            builder.humanReadableField("produced_as_first_pipeline_in_bytes", "produced_as_first_pipeline", ByteSizeValue.ofBytes(this.bytesProduced));
            return builder;
        }

        static ByteStats merge(ByteStats first, ByteStats second) {
            if (first == IDENTITY) {
                return second;
            }
            if (second == IDENTITY) {
                return first;
            }
            return new ByteStats(first.bytesIngested + second.bytesIngested, first.bytesProduced + second.bytesProduced);
        }
    }

    public record PipelineStat(ProjectId projectId, String pipelineId, Stats stats, ByteStats byteStats) {
        static List<PipelineStat> merge(List<PipelineStat> first, List<PipelineStat> second) {
            record MergeKey(ProjectId projectId, String pipelineId) {
            }
            HashMap totalsPerPipeline = new HashMap();
            first.forEach(ps -> totalsPerPipeline.merge(new MergeKey(ps.projectId, ps.pipelineId), ps, PipelineStat::merge));
            second.forEach(ps -> totalsPerPipeline.merge(new MergeKey(ps.projectId, ps.pipelineId), ps, PipelineStat::merge));
            return totalsPerPipeline.entrySet().stream().map(v -> new PipelineStat(((MergeKey)v.getKey()).projectId(), ((MergeKey)v.getKey()).pipelineId(), ((PipelineStat)v.getValue()).stats, ((PipelineStat)v.getValue()).byteStats)).sorted(PIPELINE_STAT_COMPARATOR).toList();
        }

        private static PipelineStat merge(PipelineStat first, PipelineStat second) {
            assert (first.projectId.equals(second.projectId)) : "Can only merge stats from the same project";
            assert (first.pipelineId.equals(second.pipelineId)) : "Can only merge stats from the same pipeline";
            return new PipelineStat(first.projectId, first.pipelineId, Stats.merge(first.stats, second.stats), ByteStats.merge(first.byteStats, second.byteStats));
        }
    }

    public record ProcessorStat(String name, String type, Stats stats) {
        private static List<ProcessorStat> merge(List<ProcessorStat> first, List<ProcessorStat> second) {
            long firstIngestCountTotal = 0L;
            for (ProcessorStat ps : first) {
                firstIngestCountTotal += ps.stats.ingestCount;
            }
            long secondIngestCountTotal = 0L;
            for (ProcessorStat ps : second) {
                secondIngestCountTotal += ps.stats.ingestCount;
            }
            if (firstIngestCountTotal == 0L) {
                return second;
            }
            if (secondIngestCountTotal == 0L) {
                return first;
            }
            if (first.size() == second.size()) {
                boolean match = true;
                ArrayList<ProcessorStat> merged = new ArrayList<ProcessorStat>(first.size());
                for (int i = 0; i < first.size(); ++i) {
                    ProcessorStat ps1 = first.get(i);
                    ProcessorStat ps2 = second.get(i);
                    if (!ps1.name.equals(ps2.name) || !ps1.type.equals(ps2.type)) {
                        match = false;
                        break;
                    }
                    merged.add(new ProcessorStat(ps1.name, ps1.type, Stats.merge(ps1.stats, ps2.stats)));
                }
                if (match) {
                    return merged;
                }
            }
            if (firstIngestCountTotal < secondIngestCountTotal) {
                return first;
            }
            return second;
        }
    }

    static class Builder {
        private Stats totalStats = null;
        private final List<PipelineStat> pipelineStats = new ArrayList<PipelineStat>();
        private final Map<ProjectId, Map<String, List<ProcessorStat>>> processorStats = new HashMap<ProjectId, Map<String, List<ProcessorStat>>>();

        Builder() {
        }

        Builder addTotalMetrics(IngestMetric totalMetric) {
            assert (this.totalStats == null);
            this.totalStats = totalMetric.createStats();
            return this;
        }

        Builder addPipelineMetrics(ProjectId projectId, String pipelineId, IngestPipelineMetric ingestPipelineMetrics) {
            this.pipelineStats.add(new PipelineStat(projectId, pipelineId, ingestPipelineMetrics.createStats(), ingestPipelineMetrics.createByteStats()));
            return this;
        }

        Builder addProcessorMetrics(ProjectId projectId, String pipelineId, String processorName, String processorType, IngestMetric metric) {
            this.processorStats.computeIfAbsent(projectId, k -> new HashMap()).computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStat(processorName, processorType, metric.createStats()));
            return this;
        }

        IngestStats build() {
            return new IngestStats(this.totalStats, Collections.unmodifiableList(this.pipelineStats), Collections.unmodifiableMap(this.processorStats));
        }
    }
}

