/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.stats;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndexingPressureStats
implements Writeable,
ToXContentFragment {
    private static final TransportVersion MAX_OPERATION_SIZE_REJECTIONS_ADDED = TransportVersion.fromName("max_operation_size_rejections_added");
    private final long totalCombinedCoordinatingAndPrimaryBytes;
    private final long totalCoordinatingBytes;
    private final long totalPrimaryBytes;
    private final long totalReplicaBytes;
    private final long currentCombinedCoordinatingAndPrimaryBytes;
    private final long currentCoordinatingBytes;
    private final long currentPrimaryBytes;
    private final long currentReplicaBytes;
    private final long coordinatingRejections;
    private final long primaryRejections;
    private final long replicaRejections;
    private final long primaryDocumentRejections;
    private final long memoryLimit;
    private final long lowWaterMarkSplits;
    private final long highWaterMarkSplits;
    private final long largeOpsRejections;
    private final long totalLargeRejectedOpsBytes;
    private final long totalCoordinatingOps;
    private final long totalCoordinatingRequests;
    private final long totalPrimaryOps;
    private final long totalReplicaOps;
    private final long currentCoordinatingOps;
    private final long currentPrimaryOps;
    private final long currentReplicaOps;
    private static final String COMBINED = "combined_coordinating_and_primary";
    private static final String COMBINED_IN_BYTES = "combined_coordinating_and_primary_in_bytes";
    private static final String COORDINATING = "coordinating";
    private static final String COORDINATING_IN_BYTES = "coordinating_in_bytes";
    private static final String PRIMARY = "primary";
    private static final String PRIMARY_IN_BYTES = "primary_in_bytes";
    private static final String REPLICA = "replica";
    private static final String REPLICA_IN_BYTES = "replica_in_bytes";
    private static final String ALL = "all";
    private static final String ALL_IN_BYTES = "all_in_bytes";
    private static final String COORDINATING_REJECTIONS = "coordinating_rejections";
    private static final String PRIMARY_REJECTIONS = "primary_rejections";
    private static final String REPLICA_REJECTIONS = "replica_rejections";
    private static final String PRIMARY_DOCUMENT_REJECTIONS = "primary_document_rejections";
    private static final String LIMIT = "limit";
    private static final String LIMIT_IN_BYTES = "limit_in_bytes";
    private static final String LARGE_OPERATION_REJECTIONS = "large_operation_rejections";

    public IndexingPressureStats(StreamInput in) throws IOException {
        this.totalCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.totalCoordinatingBytes = in.readVLong();
        this.totalPrimaryBytes = in.readVLong();
        this.totalReplicaBytes = in.readVLong();
        this.currentCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.currentCoordinatingBytes = in.readVLong();
        this.currentPrimaryBytes = in.readVLong();
        this.currentReplicaBytes = in.readVLong();
        this.coordinatingRejections = in.readVLong();
        this.primaryRejections = in.readVLong();
        this.replicaRejections = in.readVLong();
        this.memoryLimit = in.readVLong();
        this.totalCoordinatingOps = 0L;
        this.totalPrimaryOps = 0L;
        this.totalReplicaOps = 0L;
        this.currentCoordinatingOps = 0L;
        this.currentPrimaryOps = 0L;
        this.currentReplicaOps = 0L;
        this.primaryDocumentRejections = in.readVLong();
        this.totalCoordinatingRequests = in.readVLong();
        this.lowWaterMarkSplits = in.readVLong();
        this.highWaterMarkSplits = in.readVLong();
        if (in.getTransportVersion().supports(MAX_OPERATION_SIZE_REJECTIONS_ADDED)) {
            this.largeOpsRejections = in.readVLong();
            this.totalLargeRejectedOpsBytes = in.readVLong();
        } else {
            this.largeOpsRejections = -1L;
            this.totalLargeRejectedOpsBytes = -1L;
        }
    }

    public IndexingPressureStats(long totalCombinedCoordinatingAndPrimaryBytes, long totalCoordinatingBytes, long totalPrimaryBytes, long totalReplicaBytes, long currentCombinedCoordinatingAndPrimaryBytes, long currentCoordinatingBytes, long currentPrimaryBytes, long currentReplicaBytes, long coordinatingRejections, long primaryRejections, long replicaRejections, long memoryLimit, long totalCoordinatingOps, long totalPrimaryOps, long totalReplicaOps, long currentCoordinatingOps, long currentPrimaryOps, long currentReplicaOps, long primaryDocumentRejections, long totalCoordinatingRequests, long lowWaterMarkSplits, long highWaterMarkSplits, long largeOpsRejections, long totalRejectedLargeOpsBytes) {
        this.totalCombinedCoordinatingAndPrimaryBytes = totalCombinedCoordinatingAndPrimaryBytes;
        this.totalCoordinatingBytes = totalCoordinatingBytes;
        this.totalPrimaryBytes = totalPrimaryBytes;
        this.totalReplicaBytes = totalReplicaBytes;
        this.currentCombinedCoordinatingAndPrimaryBytes = currentCombinedCoordinatingAndPrimaryBytes;
        this.currentCoordinatingBytes = currentCoordinatingBytes;
        this.currentPrimaryBytes = currentPrimaryBytes;
        this.currentReplicaBytes = currentReplicaBytes;
        this.coordinatingRejections = coordinatingRejections;
        this.primaryRejections = primaryRejections;
        this.replicaRejections = replicaRejections;
        this.memoryLimit = memoryLimit;
        this.totalCoordinatingOps = totalCoordinatingOps;
        this.totalPrimaryOps = totalPrimaryOps;
        this.totalReplicaOps = totalReplicaOps;
        this.currentCoordinatingOps = currentCoordinatingOps;
        this.currentPrimaryOps = currentPrimaryOps;
        this.currentReplicaOps = currentReplicaOps;
        this.primaryDocumentRejections = primaryDocumentRejections;
        this.totalCoordinatingRequests = totalCoordinatingRequests;
        this.lowWaterMarkSplits = lowWaterMarkSplits;
        this.highWaterMarkSplits = highWaterMarkSplits;
        this.largeOpsRejections = largeOpsRejections;
        this.totalLargeRejectedOpsBytes = totalRejectedLargeOpsBytes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.totalCoordinatingBytes);
        out.writeVLong(this.totalPrimaryBytes);
        out.writeVLong(this.totalReplicaBytes);
        out.writeVLong(this.currentCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.currentCoordinatingBytes);
        out.writeVLong(this.currentPrimaryBytes);
        out.writeVLong(this.currentReplicaBytes);
        out.writeVLong(this.coordinatingRejections);
        out.writeVLong(this.primaryRejections);
        out.writeVLong(this.replicaRejections);
        out.writeVLong(this.memoryLimit);
        out.writeVLong(this.primaryDocumentRejections);
        out.writeVLong(this.totalCoordinatingRequests);
        out.writeVLong(this.lowWaterMarkSplits);
        out.writeVLong(this.highWaterMarkSplits);
        if (out.getTransportVersion().supports(MAX_OPERATION_SIZE_REJECTIONS_ADDED)) {
            out.writeVLong(this.largeOpsRejections);
            out.writeVLong(this.totalLargeRejectedOpsBytes);
        }
    }

    public long getTotalCombinedCoordinatingAndPrimaryBytes() {
        return this.totalCombinedCoordinatingAndPrimaryBytes;
    }

    public long getTotalCoordinatingBytes() {
        return this.totalCoordinatingBytes;
    }

    public long getTotalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public long getTotalReplicaBytes() {
        return this.totalReplicaBytes;
    }

    public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
        return this.currentCombinedCoordinatingAndPrimaryBytes;
    }

    public long getCurrentCoordinatingBytes() {
        return this.currentCoordinatingBytes;
    }

    public long getCurrentPrimaryBytes() {
        return this.currentPrimaryBytes;
    }

    public long getCurrentReplicaBytes() {
        return this.currentReplicaBytes;
    }

    public long getCoordinatingRejections() {
        return this.coordinatingRejections;
    }

    public long getPrimaryRejections() {
        return this.primaryRejections;
    }

    public long getReplicaRejections() {
        return this.replicaRejections;
    }

    public long getTotalCoordinatingOps() {
        return this.totalCoordinatingOps;
    }

    public long getTotalPrimaryOps() {
        return this.totalPrimaryOps;
    }

    public long getTotalReplicaOps() {
        return this.totalReplicaOps;
    }

    public long getCurrentCoordinatingOps() {
        return this.currentCoordinatingOps;
    }

    public long getCurrentPrimaryOps() {
        return this.currentPrimaryOps;
    }

    public long getCurrentReplicaOps() {
        return this.currentReplicaOps;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public long getPrimaryDocumentRejections() {
        return this.primaryDocumentRejections;
    }

    public long getTotalCoordinatingRequests() {
        return this.totalCoordinatingRequests;
    }

    public long getHighWaterMarkSplits() {
        return this.highWaterMarkSplits;
    }

    public long getLowWaterMarkSplits() {
        return this.lowWaterMarkSplits;
    }

    public long getLargeOpsRejections() {
        return this.largeOpsRejections;
    }

    public long getTotalLargeRejectedOpsBytes() {
        return this.totalLargeRejectedOpsBytes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing_pressure");
        builder.startObject("memory");
        builder.startObject("current");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, ByteSizeValue.ofBytes(this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, ByteSizeValue.ofBytes(this.currentCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, ByteSizeValue.ofBytes(this.currentPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, ByteSizeValue.ofBytes(this.currentReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, ByteSizeValue.ofBytes(this.currentReplicaBytes + this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.endObject();
        builder.startObject("total");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, ByteSizeValue.ofBytes(this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, ByteSizeValue.ofBytes(this.totalCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, ByteSizeValue.ofBytes(this.totalPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, ByteSizeValue.ofBytes(this.totalReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, ByteSizeValue.ofBytes(this.totalReplicaBytes + this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.field(COORDINATING_REJECTIONS, this.coordinatingRejections);
        builder.field(PRIMARY_REJECTIONS, this.primaryRejections);
        builder.field(REPLICA_REJECTIONS, this.replicaRejections);
        builder.field(PRIMARY_DOCUMENT_REJECTIONS, this.primaryDocumentRejections);
        builder.field(LARGE_OPERATION_REJECTIONS, this.largeOpsRejections);
        builder.endObject();
        builder.humanReadableField(LIMIT_IN_BYTES, LIMIT, ByteSizeValue.ofBytes(this.memoryLimit));
        builder.endObject();
        return builder.endObject();
    }
}

