/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShardCountStats
implements Writeable,
ToXContentFragment {
    private final long totalCount;

    public ShardCountStats() {
        this.totalCount = 0L;
    }

    public ShardCountStats(StreamInput in) throws IOException {
        this.totalCount = in.readVLong();
    }

    public ShardCountStats(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public ShardCountStats add(@Nullable ShardCountStats other) {
        return new ShardCountStats(this.totalCount + (other == null ? 0L : other.totalCount));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("shard_stats");
        builder.field("total_count", this.totalCount);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCount);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        return o instanceof ShardCountStats && this.totalCount == ((ShardCountStats)o).totalCount;
    }

    public int hashCode() {
        return Long.hashCode(this.totalCount);
    }

    static final class Fields {
        static final String SHARDS = "shard_stats";
        static final String TOTAL_COUNT = "total_count";

        Fields() {
        }
    }
}

