/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.queries.intervals.FilteredIntervalsSource;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextFamilyFieldType;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.IntervalBuilder;
import org.elasticsearch.index.query.IntervalFilterScript;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class IntervalsSourceProvider
implements NamedWriteable,
ToXContentFragment {
    public abstract IntervalsSource getSource(SearchExecutionContext var1, TextFamilyFieldType var2) throws IOException;

    public abstract void extractFields(Set<String> var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static IntervalsSourceProvider fromXContent(XContentParser parser) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.FIELD_NAME);
        switch (parser.currentName()) {
            case "match": {
                return Match.fromXContent(parser);
            }
            case "any_of": {
                return Disjunction.fromXContent(parser);
            }
            case "all_of": {
                return Combine.fromXContent(parser);
            }
            case "prefix": {
                return Prefix.fromXContent(parser);
            }
            case "wildcard": {
                return Wildcard.fromXContent(parser);
            }
            case "fuzzy": {
                return Fuzzy.fromXContent(parser);
            }
            case "regexp": {
                return Regexp.fromXContent(parser);
            }
            case "range": {
                return Range.fromXContent(parser);
            }
        }
        throw new ParsingException(parser.getTokenLocation(), "Unknown interval type [" + parser.currentName() + "], expecting one of [match, any_of, all_of, prefix, wildcard, regexp, range]", new Object[0]);
    }

    private static IntervalsSourceProvider parseInnerIntervals(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        IntervalsSourceProvider isp = IntervalsSourceProvider.fromXContent(parser);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        return isp;
    }

    private static TextFamilyFieldType useField(MappedFieldType fieldType) {
        if (fieldType instanceof TextFamilyFieldType) {
            return (TextFamilyFieldType)fieldType;
        }
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + fieldType.name() + "] which is of type [" + fieldType.typeName() + "]");
    }

    public static class Match
    extends IntervalsSourceProvider {
        public static final String NAME = "match";
        private final String query;
        private final int maxGaps;
        private final boolean ordered;
        private final String analyzer;
        private final IntervalFilter filter;
        private final String useField;
        private static final ConstructingObjectParser<Match, Void> PARSER = new ConstructingObjectParser("match", args -> {
            String query = (String)args[0];
            int max_gaps = args[1] == null ? -1 : (Integer)args[1];
            boolean ordered = args[2] != null && (Boolean)args[2] != false;
            String analyzer = (String)args[3];
            IntervalFilter filter = (IntervalFilter)args[4];
            String useField = (String)args[5];
            return new Match(query, max_gaps, ordered, analyzer, filter, useField);
        });

        public Match(String query, int maxGaps, boolean ordered, String analyzer, IntervalFilter filter, String useField) {
            this.query = query;
            this.maxGaps = maxGaps;
            this.ordered = ordered;
            this.analyzer = analyzer;
            this.filter = filter;
            this.useField = useField;
        }

        public Match(StreamInput in) throws IOException {
            this.query = in.readString();
            this.maxGaps = in.readVInt();
            this.ordered = in.readBoolean();
            this.analyzer = in.readOptionalString();
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
            this.useField = in.readOptionalString();
        }

        private static IntervalsSource intervals(final TextFamilyFieldType fieldType, String text, int maxGaps, boolean ordered, NamedAnalyzer analyzer, final SearchExecutionContext context) throws IOException {
            IntervalBuilder builder = new IntervalBuilder(fieldType.name(), analyzer){

                @Override
                protected IntervalsSource termIntervals(BytesRef term) {
                    return fieldType.termIntervals(term, context);
                }
            };
            return builder.analyzeText(text, maxGaps, ordered);
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) throws IOException {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            IntervalsSource source = Match.intervals(fieldType, this.query, this.maxGaps, this.ordered, analyzer, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            if (this.filter != null) {
                source = this.filter.filter(source, context, fieldType);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            return this.maxGaps == match.maxGaps && this.ordered == match.ordered && Objects.equals(this.query, match.query) && Objects.equals(this.filter, match.filter) && Objects.equals(this.useField, match.useField) && Objects.equals(this.analyzer, match.analyzer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.query, this.maxGaps, this.ordered, this.analyzer, this.filter, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.query);
            out.writeVInt(this.maxGaps);
            out.writeBoolean(this.ordered);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalWriteable(this.filter);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            builder.startObject();
            builder.field("query", this.query);
            builder.field("max_gaps", this.maxGaps);
            builder.field("ordered", this.ordered);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            return builder.endObject();
        }

        public static Match fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        String getQuery() {
            return this.query;
        }

        int getMaxGaps() {
            return this.maxGaps;
        }

        boolean isOrdered() {
            return this.ordered;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("query", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_gaps", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ordered", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Disjunction
    extends IntervalsSourceProvider {
        public static final String NAME = "any_of";
        private final List<IntervalsSourceProvider> subSources;
        private final IntervalFilter filter;
        private static final ConstructingObjectParser<Disjunction, Void> PARSER = new ConstructingObjectParser("any_of", args -> {
            List subSources = (List)args[0];
            IntervalFilter filter = (IntervalFilter)args[1];
            return new Disjunction(subSources, filter);
        });

        public Disjunction(List<IntervalsSourceProvider> subSources, IntervalFilter filter) {
            this.subSources = subSources;
            this.filter = filter;
        }

        public Disjunction(StreamInput in) throws IOException {
            this.subSources = in.readNamedWriteableCollectionAsList(IntervalsSourceProvider.class);
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext ctx, TextFamilyFieldType fieldType) throws IOException {
            ArrayList<IntervalsSource> sources = new ArrayList<IntervalsSource>();
            for (IntervalsSourceProvider provider : this.subSources) {
                sources.add(provider.getSource(ctx, fieldType));
            }
            IntervalsSource source = Intervals.or((IntervalsSource[])sources.toArray(new IntervalsSource[0]));
            if (this.filter == null) {
                return source;
            }
            return this.filter.filter(source, ctx, fieldType);
        }

        @Override
        public void extractFields(Set<String> fields) {
            for (IntervalsSourceProvider provider : this.subSources) {
                provider.extractFields(fields);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Disjunction that = (Disjunction)o;
            return Objects.equals(this.subSources, that.subSources) && Objects.equals(this.filter, that.filter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subSources, this.filter);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteableCollection(this.subSources);
            out.writeOptionalWriteable(this.filter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.startArray("intervals");
            for (IntervalsSourceProvider provider : this.subSources) {
                builder.startObject();
                provider.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            return builder.endObject();
        }

        public static Disjunction fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        List<IntervalsSourceProvider> getSubSources() {
            return this.subSources;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> IntervalsSourceProvider.parseInnerIntervals(p), new ParseField("intervals", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
        }
    }

    public static class Combine
    extends IntervalsSourceProvider {
        public static final String NAME = "all_of";
        private final List<IntervalsSourceProvider> subSources;
        private final boolean ordered;
        private final int maxGaps;
        private final IntervalFilter filter;
        static final ConstructingObjectParser<Combine, Void> PARSER = new ConstructingObjectParser("all_of", args -> {
            boolean ordered = args[0] != null && (Boolean)args[0] != false;
            List subSources = (List)args[1];
            Integer maxGaps = args[2] == null ? -1 : (Integer)args[2];
            IntervalFilter filter = (IntervalFilter)args[3];
            return new Combine(subSources, ordered, maxGaps, filter);
        });

        public Combine(List<IntervalsSourceProvider> subSources, boolean ordered, int maxGaps, IntervalFilter filter) {
            this.subSources = subSources;
            this.ordered = ordered;
            this.maxGaps = maxGaps;
            this.filter = filter;
        }

        public Combine(StreamInput in) throws IOException {
            this.ordered = in.readBoolean();
            this.subSources = in.readNamedWriteableCollectionAsList(IntervalsSourceProvider.class);
            this.maxGaps = in.readInt();
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext ctx, TextFamilyFieldType fieldType) throws IOException {
            ArrayList<IntervalsSource> ss = new ArrayList<IntervalsSource>();
            for (IntervalsSourceProvider provider : this.subSources) {
                ss.add(provider.getSource(ctx, fieldType));
            }
            IntervalsSource source = IntervalBuilder.combineSources(ss, this.maxGaps, this.ordered);
            if (this.filter != null) {
                return this.filter.filter(source, ctx, fieldType);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            for (IntervalsSourceProvider provider : this.subSources) {
                provider.extractFields(fields);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Combine combine = (Combine)o;
            return Objects.equals(this.subSources, combine.subSources) && this.ordered == combine.ordered && this.maxGaps == combine.maxGaps && Objects.equals(this.filter, combine.filter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subSources, this.ordered, this.maxGaps, this.filter);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.ordered);
            out.writeNamedWriteableCollection(this.subSources);
            out.writeInt(this.maxGaps);
            out.writeOptionalWriteable(this.filter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("ordered", this.ordered);
            builder.field("max_gaps", this.maxGaps);
            builder.startArray("intervals");
            for (IntervalsSourceProvider provider : this.subSources) {
                builder.startObject();
                provider.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            return builder.endObject();
        }

        public static Combine fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        List<IntervalsSourceProvider> getSubSources() {
            return this.subSources;
        }

        boolean isOrdered() {
            return this.ordered;
        }

        int getMaxGaps() {
            return this.maxGaps;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ordered", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> IntervalsSourceProvider.parseInnerIntervals(p), new ParseField("intervals", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_gaps", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
        }
    }

    public static class Prefix
    extends IntervalsSourceProvider {
        public static final String NAME = "prefix";
        private final String prefix;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Prefix, Void> PARSER = new ConstructingObjectParser("prefix", args -> {
            String term = (String)args[0];
            String analyzer = (String)args[1];
            String useField = (String)args[2];
            return new Prefix(term, analyzer, useField);
        });

        public Prefix(String prefix, String analyzer, String useField) {
            this.prefix = prefix;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Prefix(StreamInput in) throws IOException {
            this.prefix = in.readString();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) throws IOException {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            BytesRef prefixTerm = analyzer.normalize(fieldType.name(), this.prefix);
            IntervalsSource source = fieldType.prefixIntervals(prefixTerm, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Prefix prefix = (Prefix)o;
            return Objects.equals(this.prefix, prefix.prefix) && Objects.equals(this.analyzer, prefix.analyzer) && Objects.equals(this.useField, prefix.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.prefix, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.prefix);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field(NAME, this.prefix);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Prefix fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPrefix() {
            return this.prefix;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(NAME, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Wildcard
    extends IntervalsSourceProvider {
        public static final String NAME = "wildcard";
        private final String pattern;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Wildcard, Void> PARSER = new ConstructingObjectParser("wildcard", args -> {
            String term = (String)args[0];
            String analyzer = (String)args[1];
            String useField = (String)args[2];
            return new Wildcard(term, analyzer, useField);
        });

        public Wildcard(String pattern, String analyzer, String useField) {
            this.pattern = pattern;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Wildcard(StreamInput in) throws IOException {
            this.pattern = in.readString();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            BytesRef normalizedPattern = analyzer.normalize(fieldType.name(), this.pattern);
            IntervalsSource source = fieldType.wildcardIntervals(normalizedPattern, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Wildcard wildcard = (Wildcard)o;
            return Objects.equals(this.pattern, wildcard.pattern) && Objects.equals(this.analyzer, wildcard.analyzer) && Objects.equals(this.useField, wildcard.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("pattern", this.pattern);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Wildcard fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPattern() {
            return this.pattern;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("pattern", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Fuzzy
    extends IntervalsSourceProvider {
        public static final String NAME = "fuzzy";
        private final String term;
        private final int prefixLength;
        private final boolean transpositions;
        private final Fuzziness fuzziness;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Fuzzy, Void> PARSER = new ConstructingObjectParser("fuzzy", args -> {
            String term = (String)args[0];
            int prefixLength = args[1] == null ? 0 : (Integer)args[1];
            boolean transpositions = args[2] == null ? true : (Boolean)args[2];
            Fuzziness fuzziness = args[3] == null ? FuzzyQueryBuilder.DEFAULT_FUZZINESS : (Fuzziness)args[3];
            String analyzer = (String)args[4];
            String useField = (String)args[5];
            return new Fuzzy(term, prefixLength, transpositions, fuzziness, analyzer, useField);
        });

        public Fuzzy(String term, int prefixLength, boolean transpositions, Fuzziness fuzziness, String analyzer, String useField) {
            this.term = term;
            this.prefixLength = prefixLength;
            this.transpositions = transpositions;
            this.fuzziness = fuzziness;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Fuzzy(StreamInput in) throws IOException {
            this.term = in.readString();
            this.prefixLength = in.readVInt();
            this.transpositions = in.readBoolean();
            this.fuzziness = new Fuzziness(in);
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            String normalizedTerm = analyzer.normalize(fieldType.name(), this.term).utf8ToString();
            IntervalsSource source = fieldType.fuzzyIntervals(normalizedTerm, this.fuzziness.asDistance(this.term), this.prefixLength, this.transpositions, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fuzzy fuzzy = (Fuzzy)o;
            return this.prefixLength == fuzzy.prefixLength && this.transpositions == fuzzy.transpositions && Objects.equals(this.term, fuzzy.term) && Objects.equals(this.fuzziness, fuzzy.fuzziness) && Objects.equals(this.analyzer, fuzzy.analyzer) && Objects.equals(this.useField, fuzzy.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.term, this.prefixLength, this.transpositions, this.fuzziness, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeVInt(this.prefixLength);
            out.writeBoolean(this.transpositions);
            this.fuzziness.writeTo(out);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("term", this.term);
            builder.field("prefix_length", this.prefixLength);
            builder.field("transpositions", this.transpositions);
            this.fuzziness.toXContent(builder, params);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Fuzzy fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getTerm() {
            return this.term;
        }

        int getPrefixLength() {
            return this.prefixLength;
        }

        boolean isTranspositions() {
            return this.transpositions;
        }

        Fuzziness getFuzziness() {
            return this.fuzziness;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("term", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("prefix_length", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("transpositions", new String[0]));
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Fuzziness.parse(p), Fuzziness.FIELD, ObjectParser.ValueType.VALUE);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Regexp
    extends IntervalsSourceProvider
    implements VersionedNamedWriteable {
        public static final String NAME = "regexp";
        private final String pattern;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Regexp, Void> PARSER = new ConstructingObjectParser("regexp", args -> {
            String term = (String)args[0];
            String analyzer = (String)args[1];
            String useField = (String)args[2];
            return new Regexp(term, analyzer, useField);
        });

        public Regexp(String pattern, String analyzer, String useField) {
            this.pattern = pattern;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Regexp(StreamInput in) throws IOException {
            this.pattern = in.readString();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            BytesRef normalizedPattern = analyzer.normalize(fieldType.name(), this.pattern);
            IntervalsSource source = fieldType.regexpIntervals(normalizedPattern, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Regexp regexp = (Regexp)o;
            return Objects.equals(this.pattern, regexp.pattern) && Objects.equals(this.analyzer, regexp.analyzer) && Objects.equals(this.useField, regexp.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("pattern", this.pattern);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Regexp fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPattern() {
            return this.pattern;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("pattern", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Range
    extends IntervalsSourceProvider
    implements VersionedNamedWriteable {
        public static final String NAME = "range";
        private final String lowerTerm;
        private final String upperTerm;
        private final boolean includeLower;
        private final boolean includeUpper;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Range, Void> PARSER = new ConstructingObjectParser("range", args -> {
            String gte = (String)args[0];
            String gt = (String)args[1];
            String lte = (String)args[2];
            String lt = (String)args[3];
            if (gte == null && gt == null || gte != null && gt != null) {
                throw new IllegalArgumentException("Either [gte] or [gt], one of them must be provided");
            }
            if (lte == null && lt == null || lte != null && lt != null) {
                throw new IllegalArgumentException("Either [lte] or [lt], one of them must be provided");
            }
            boolean includeLower = gte != null;
            String lowerTerm = gte != null ? gte : gt;
            boolean includeUpper = lte != null;
            String upperTerm = lte != null ? lte : lt;
            String analyzer = (String)args[4];
            String useField = (String)args[5];
            return new Range(lowerTerm, upperTerm, includeLower, includeUpper, analyzer, useField);
        });

        public Range(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, String analyzer, String useField) {
            this.lowerTerm = lowerTerm;
            this.upperTerm = upperTerm;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Range(StreamInput in) throws IOException {
            this.lowerTerm = in.readString();
            this.upperTerm = in.readString();
            this.includeLower = in.readBoolean();
            this.includeUpper = in.readBoolean();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(SearchExecutionContext context, TextFamilyFieldType fieldType) {
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = IntervalsSourceProvider.useField(context.getFieldType(this.useField));
            }
            if (analyzer == null) {
                analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            }
            BytesRef normalizedLowerTerm = analyzer.normalize(fieldType.name(), this.lowerTerm);
            BytesRef normalizedUpperTerm = analyzer.normalize(fieldType.name(), this.upperTerm);
            IntervalsSource source = fieldType.rangeIntervals(normalizedLowerTerm, normalizedUpperTerm, this.includeLower, this.includeUpper, context);
            if (this.useField != null) {
                source = Intervals.fixField((String)this.useField, (IntervalsSource)source);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeLower == range.includeLower && this.includeUpper == range.includeUpper && Objects.equals(this.lowerTerm, range.lowerTerm) && Objects.equals(this.upperTerm, range.upperTerm) && Objects.equals(this.analyzer, range.analyzer) && Objects.equals(this.useField, range.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.lowerTerm, this.upperTerm, this.includeLower, this.includeUpper, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.lowerTerm);
            out.writeString(this.upperTerm);
            out.writeBoolean(this.includeLower);
            out.writeBoolean(this.includeUpper);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            if (this.includeLower) {
                builder.field("gte", this.lowerTerm);
            } else {
                builder.field("gt", this.lowerTerm);
            }
            if (this.includeUpper) {
                builder.field("lte", this.upperTerm);
            } else {
                builder.field("lt", this.upperTerm);
            }
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Range fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getLowerTerm() {
            return this.lowerTerm;
        }

        String getUpperTerm() {
            return this.upperTerm;
        }

        boolean getIncludeLower() {
            return this.includeLower;
        }

        boolean getIncludeUpper() {
            return this.includeUpper;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("gte", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("gt", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("lte", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("lt", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class IntervalFilter
    implements ToXContentObject,
    Writeable {
        public static final String NAME = "filter";
        private final String type;
        private final IntervalsSourceProvider filter;
        private final Script script;

        public IntervalFilter(IntervalsSourceProvider filter, String type) {
            this.filter = filter;
            this.type = type.toLowerCase(Locale.ROOT);
            this.script = null;
        }

        IntervalFilter(Script script) {
            this.script = script;
            this.type = "script";
            this.filter = null;
        }

        public IntervalFilter(StreamInput in) throws IOException {
            this.type = in.readString();
            this.filter = in.readOptionalNamedWriteable(IntervalsSourceProvider.class);
            this.script = in.readBoolean() ? new Script(in) : null;
        }

        public IntervalsSource filter(IntervalsSource input, SearchExecutionContext context, TextFamilyFieldType fieldType) throws IOException {
            if (this.script != null) {
                IntervalFilterScript ifs = context.compile(this.script, IntervalFilterScript.CONTEXT).newInstance();
                return new ScriptFilterSource(input, this.script.getIdOrCode(), ifs);
            }
            IntervalsSource filterSource = this.filter.getSource(context, fieldType);
            return switch (this.type) {
                case "containing" -> Intervals.containing((IntervalsSource)input, (IntervalsSource)filterSource);
                case "contained_by" -> Intervals.containedBy((IntervalsSource)input, (IntervalsSource)filterSource);
                case "not_containing" -> Intervals.notContaining((IntervalsSource)input, (IntervalsSource)filterSource);
                case "not_contained_by" -> Intervals.notContainedBy((IntervalsSource)input, (IntervalsSource)filterSource);
                case "overlapping" -> Intervals.overlapping((IntervalsSource)input, (IntervalsSource)filterSource);
                case "not_overlapping" -> Intervals.nonOverlapping((IntervalsSource)input, (IntervalsSource)filterSource);
                case "before" -> Intervals.before((IntervalsSource)input, (IntervalsSource)filterSource);
                case "after" -> Intervals.after((IntervalsSource)input, (IntervalsSource)filterSource);
                default -> throw new IllegalArgumentException("Unknown filter type [" + this.type + "]");
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntervalFilter that = (IntervalFilter)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.script, that.script) && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.filter, this.script);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeOptionalNamedWriteable(this.filter);
            if (this.script == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.script.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.filter != null) {
                builder.startObject(this.type);
                this.filter.toXContent(builder, params);
                builder.endObject();
            } else {
                builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
            }
            builder.endObject();
            return builder;
        }

        public static IntervalFilter fromXContent(XContentParser parser) throws IOException {
            if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            String type = parser.currentName();
            if (Script.SCRIPT_PARSE_FIELD.match(type, parser.getDeprecationHandler())) {
                Script script = Script.parse(parser);
                if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
                }
                return new IntervalFilter(script);
            }
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            IntervalsSourceProvider intervals = IntervalsSourceProvider.fromXContent(parser);
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            return new IntervalFilter(intervals, type);
        }

        String getType() {
            return this.type;
        }

        IntervalsSourceProvider getFilter() {
            return this.filter;
        }

        Script getScript() {
            return this.script;
        }
    }

    static class ScriptFilterSource
    extends FilteredIntervalsSource {
        final IntervalFilterScript script;
        IntervalFilterScript.Interval interval = new IntervalFilterScript.Interval();

        ScriptFilterSource(IntervalsSource in, String name, IntervalFilterScript script) {
            super("FILTER(" + name + ")", in);
            this.script = script;
        }

        protected boolean accept(IntervalIterator it) {
            this.interval.setIterator(it);
            return this.script.execute(this.interval);
        }
    }
}

