/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.vectors.BFloat16BinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.BinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.BitBinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.BitKnnDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.ByteBinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.ByteKnnDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.KnnDenseVectorDocValuesField;
import org.elasticsearch.search.DocValueFormat;

final class VectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final IndexVersion indexVersion;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final int dims;
    private final boolean indexed;

    VectorDVLeafFieldData(LeafReader reader, String field, IndexVersion indexVersion, DenseVectorFieldMapper.ElementType elementType, int dims, boolean indexed) {
        this.reader = reader;
        this.field = field;
        this.indexVersion = indexVersion;
        this.elementType = elementType;
        this.dims = dims;
        this.indexed = indexed;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        throw new IllegalArgumentException("String representation of doc values for vector fields is not supported");
    }

    @Override
    public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        try {
            if (this.indexed) {
                return switch (this.elementType) {
                    default -> throw new MatchException(null, null);
                    case DenseVectorFieldMapper.ElementType.BYTE -> new ByteKnnDenseVectorDocValuesField(this.reader.getByteVectorValues(this.field), name, this.dims);
                    case DenseVectorFieldMapper.ElementType.FLOAT, DenseVectorFieldMapper.ElementType.BFLOAT16 -> new KnnDenseVectorDocValuesField(this.reader.getFloatVectorValues(this.field), name, this.dims);
                    case DenseVectorFieldMapper.ElementType.BIT -> new BitKnnDenseVectorDocValuesField(this.reader.getByteVectorValues(this.field), name, this.dims);
                };
            }
            BinaryDocValues values = DocValues.getBinary(this.reader, this.field);
            return switch (this.elementType) {
                default -> throw new MatchException(null, null);
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteBinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new BinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims, this.indexVersion);
                case DenseVectorFieldMapper.ElementType.BFLOAT16 -> new BFloat16BinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims, this.indexVersion);
                case DenseVectorFieldMapper.ElementType.BIT -> new BitBinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims);
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for vector field!", e);
        }
    }

    @Override
    public FormattedDocValues getFormattedValues(DocValueFormat format) {
        return switch (this.elementType) {
            default -> throw new MatchException(null, null);
            case DenseVectorFieldMapper.ElementType.BYTE -> new ByteDocValues(this.dims);
            case DenseVectorFieldMapper.ElementType.BIT -> new ByteDocValues(this.dims / 8);
            case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatDocValues();
            case DenseVectorFieldMapper.ElementType.BFLOAT16 -> new BFloat16DocValues(this);
        };
    }

    private static boolean iteratorAdvanceExact(KnnVectorValues.DocIndexIterator iterator, int docId) throws IOException {
        if (iterator == null) {
            return false;
        }
        int currentDoc = iterator.docID();
        if (currentDoc == Integer.MAX_VALUE || docId < currentDoc) {
            return false;
        }
        return docId <= currentDoc || (currentDoc = iterator.advance(docId)) == docId;
    }

    private class ByteDocValues
    implements FormattedDocValues {
        private final int dims;
        private byte[] vector;
        private ByteVectorValues byteVectorValues;
        private KnnVectorValues.DocIndexIterator iterator;
        private BinaryDocValues binary;

        ByteDocValues(int dims) {
            this.dims = dims;
            this.vector = new byte[dims];
            try {
                if (VectorDVLeafFieldData.this.indexed) {
                    this.byteVectorValues = VectorDVLeafFieldData.this.reader.getByteVectorValues(VectorDVLeafFieldData.this.field);
                    this.iterator = this.byteVectorValues == null ? null : this.byteVectorValues.iterator();
                } else {
                    this.binary = DocValues.getBinary(VectorDVLeafFieldData.this.reader, VectorDVLeafFieldData.this.field);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            if (VectorDVLeafFieldData.this.indexed) {
                if (!VectorDVLeafFieldData.iteratorAdvanceExact(this.iterator, docId)) {
                    return false;
                }
                this.vector = this.byteVectorValues.vectorValue(this.iterator.index());
            } else {
                if (this.binary == null || !this.binary.advanceExact(docId)) {
                    return false;
                }
                BytesRef ref = this.binary.binaryValue();
                System.arraycopy(ref.bytes, ref.offset, this.vector, 0, this.dims);
            }
            return true;
        }

        @Override
        public int docValueCount() {
            return 1;
        }

        @Override
        public Object nextValue() {
            Byte[] vectorValue = new Byte[this.dims];
            for (int i = 0; i < this.dims; ++i) {
                vectorValue[i] = this.vector[i];
            }
            return vectorValue;
        }
    }

    private class FloatDocValues
    implements FormattedDocValues {
        private float[] vector;
        private FloatVectorValues floatVectorValues;
        private KnnVectorValues.DocIndexIterator iterator;
        private BinaryDocValues binary;

        FloatDocValues() {
            this.vector = new float[VectorDVLeafFieldData.this.dims];
            try {
                if (VectorDVLeafFieldData.this.indexed) {
                    this.floatVectorValues = VectorDVLeafFieldData.this.reader.getFloatVectorValues(VectorDVLeafFieldData.this.field);
                    this.iterator = this.floatVectorValues == null ? null : this.floatVectorValues.iterator();
                } else {
                    this.binary = DocValues.getBinary(VectorDVLeafFieldData.this.reader, VectorDVLeafFieldData.this.field);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            if (VectorDVLeafFieldData.this.indexed) {
                if (!VectorDVLeafFieldData.iteratorAdvanceExact(this.iterator, docId)) {
                    return false;
                }
                this.vector = this.floatVectorValues.vectorValue(this.iterator.index());
            } else {
                if (this.binary == null || !this.binary.advanceExact(docId)) {
                    return false;
                }
                BytesRef ref = this.binary.binaryValue();
                this.decodeDenseVector(VectorDVLeafFieldData.this.indexVersion, ref, this.vector);
            }
            return true;
        }

        void decodeDenseVector(IndexVersion indexVersion, BytesRef ref, float[] vector) {
            VectorEncoderDecoder.decodeDenseVector(indexVersion, ref, vector);
        }

        @Override
        public int docValueCount() {
            return 1;
        }

        @Override
        public Object nextValue() {
            return Arrays.copyOf(this.vector, this.vector.length);
        }
    }

    private class BFloat16DocValues
    extends FloatDocValues {
        private BFloat16DocValues(VectorDVLeafFieldData vectorDVLeafFieldData) {
        }

        @Override
        void decodeDenseVector(IndexVersion indexVersion, BytesRef vectorBR, float[] vector) {
            VectorEncoderDecoder.decodeBFloat16DenseVector(vectorBR, vector);
        }
    }
}

