/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.IndexOptions;
import org.elasticsearch.index.mapper.vectors.SyntheticVectorsPatchFieldLoader;
import org.elasticsearch.index.mapper.vectors.TokenPruningConfig;
import org.elasticsearch.index.mapper.vectors.XFeatureField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.inference.WeightedTokensUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;

public class SparseVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "sparse_vector";
    public static final String SPARSE_VECTOR_INDEX_OPTIONS = "index_options";
    static final String ERROR_MESSAGE_7X = "[sparse_vector] field type in old 7.x indices is allowed to contain [sparse_vector] fields, but they cannot be indexed or searched.";
    static final String ERROR_MESSAGE_8X = "The [sparse_vector] field type is not supported on indices created on versions 8.0 to 8.10.";
    static final IndexVersion PREVIOUS_SPARSE_VECTOR_INDEX_VERSION = IndexVersions.V_8_0_0;
    static final IndexVersion NEW_SPARSE_VECTOR_INDEX_VERSION = IndexVersions.NEW_SPARSE_VECTOR;
    static final IndexVersion SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION = IndexVersions.SPARSE_VECTOR_IN_FIELD_NAMES_SUPPORT;
    static final IndexVersion SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_VERSION = IndexVersions.SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_SUPPORT;
    static final IndexVersion SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_VERSION_8_X = IndexVersions.SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_SUPPORT_BACKPORT_8_X;
    public static final NodeFeature SPARSE_VECTOR_INDEX_OPTIONS_FEATURE = new NodeFeature("sparse_vector.index_options_supported");
    private static final ConstructingObjectParser<SparseVectorIndexOptions, Void> INDEX_OPTIONS_PARSER = new ConstructingObjectParser("index_options", args -> new SparseVectorIndexOptions((Boolean)args[0], (TokenPruningConfig)args[1]));
    public static final FieldMapper.TypeParser PARSER;
    private final boolean isExcludeSourceVectors;

    private static SparseVectorFieldMapper toType(FieldMapper in) {
        return (SparseVectorFieldMapper)in;
    }

    public SparseVectorIndexOptions getIndexOptions() {
        return this.fieldType().getIndexOptions();
    }

    private static SparseVectorIndexOptions parseIndexOptions(MappingParserContext context, Object propNode) {
        if (propNode == null) {
            return null;
        }
        Map<String, Object> indexOptionsMap = XContentMapValues.nodeMapValue(propNode, SPARSE_VECTOR_INDEX_OPTIONS);
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, indexOptionsMap, XContentType.JSON);
        try {
            return INDEX_OPTIONS_PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private SparseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean isExcludeSourceVectors) {
        super(simpleName, mappedFieldType, builderParams);
        assert (!isExcludeSourceVectors || this.fieldType().isStored());
        this.isExcludeSourceVectors = isExcludeSourceVectors;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.fieldType().isStored()) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new SparseVectorSyntheticFieldLoader(this.fullPath(), this.leafName()));
        }
        return super.syntheticSourceSupport();
    }

    @Override
    public SourceLoader.SyntheticVectorsLoader syntheticVectorsLoader() {
        if (this.isExcludeSourceVectors) {
            return new SyntheticVectorsPatchFieldLoader<SparseVectorSyntheticFieldLoader>(() -> new SparseVectorSyntheticFieldLoader(this.fullPath(), this.leafName()), SparseVectorSyntheticFieldLoader::copyAsMap);
        }
        return null;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.fieldType().indexVersionCreated, this.isExcludeSourceVectors).init(this);
    }

    @Override
    public SparseVectorFieldType fieldType() {
        return (SparseVectorFieldType)super.fieldType();
    }

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.indexSettings().getIndexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
            throw new UnsupportedOperationException(ERROR_MESSAGE_7X);
        }
        if (context.indexSettings().getIndexVersionCreated().before(NEW_SPARSE_VECTOR_INDEX_VERSION)) {
            throw new UnsupportedOperationException(ERROR_MESSAGE_8X);
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[sparse_vector] fields must be json objects, expected a START_OBJECT but got: " + String.valueOf((Object)context.parser().currentToken()));
        }
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        String feature = null;
        try {
            context.path().setWithinLeafObject(true);
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    feature = context.parser().currentName();
                } else if (token != XContentParser.Token.VALUE_NULL) {
                    if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                        FeatureField ff;
                        String key = this.fullPath() + "\\." + feature.replace(".", "\\.");
                        float value = context.parser().floatValue(true);
                        IndexableField currentField = context.doc().getByKey(key);
                        if (currentField == null) {
                            context.doc().addWithKey(key, new FeatureField(this.fullPath(), feature, value, this.fieldType().isStored()));
                        } else if (currentField instanceof FeatureField && (ff = (FeatureField)currentField).getFeatureValue() < value) {
                            ff.setFeatureValue(value);
                        }
                    } else {
                        throw new IllegalArgumentException("[sparse_vector] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + String.valueOf((Object)token));
                    }
                }
                token = context.parser().nextToken();
            }
            if (context.indexSettings().getIndexVersionCreated().onOrAfter(SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION)) {
                context.addToFieldNames(this.fieldType().name());
            }
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    private static boolean indexVersionSupportsDefaultPruningConfig(IndexVersion indexVersion) {
        return indexVersion.onOrAfter(SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_VERSION) || indexVersion.between(SPARSE_VECTOR_PRUNING_INDEX_OPTIONS_VERSION_8_X, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    static {
        INDEX_OPTIONS_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SparseVectorIndexOptions.PRUNE_FIELD_NAME);
        INDEX_OPTIONS_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TokenPruningConfig.PARSER, SparseVectorIndexOptions.PRUNING_CONFIG_FIELD_NAME);
        PARSER = new FieldMapper.TypeParser((n, c) -> {
            if (c.indexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
                deprecationLogger.warn(DeprecationCategory.MAPPINGS, CONTENT_TYPE, ERROR_MESSAGE_7X, new Object[0]);
            } else if (c.indexVersionCreated().before(NEW_SPARSE_VECTOR_INDEX_VERSION)) {
                throw new IllegalArgumentException(ERROR_MESSAGE_8X);
            }
            return new Builder((String)n, c.indexVersionCreated(), IndexSettings.INDEX_MAPPING_EXCLUDE_SOURCE_VECTORS_SETTING.get(c.getIndexSettings().getSettings()));
        }, SparseVectorFieldMapper.notInMultiFields(CONTENT_TYPE));
    }

    public static final class SparseVectorFieldType
    extends MappedFieldType {
        private final IndexVersion indexVersionCreated;
        private final SparseVectorIndexOptions indexOptions;

        public SparseVectorFieldType(IndexVersion indexVersionCreated, String name, boolean isStored, Map<String, String> meta) {
            this(indexVersionCreated, name, isStored, meta, null);
        }

        public SparseVectorFieldType(IndexVersion indexVersionCreated, String name, boolean isStored, Map<String, String> meta, @Nullable SparseVectorIndexOptions indexOptions) {
            super(name, IndexType.vectors(), isStored, meta);
            this.indexVersionCreated = indexVersionCreated;
            this.indexOptions = indexOptions;
        }

        public SparseVectorIndexOptions getIndexOptions() {
            return this.indexOptions;
        }

        @Override
        public String typeName() {
            return SparseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isVectorEmbedding() {
            return true;
        }

        @Override
        public TextSearchInfo getTextSearchInfo() {
            return TextSearchInfo.SIMPLE_MATCH_ONLY;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[sparse_vector] fields do not support sorting, scripting or aggregating");
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return FeatureField.newLinearQuery(this.name(), SparseVectorFieldType.indexedValueForSearch(value), 1.0f);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            if (context.getIndexSettings().getIndexVersionCreated().before(PREVIOUS_SPARSE_VECTOR_INDEX_VERSION)) {
                deprecationLogger.warn(DeprecationCategory.MAPPINGS, SparseVectorFieldMapper.CONTENT_TYPE, SparseVectorFieldMapper.ERROR_MESSAGE_7X, new Object[0]);
                return Queries.NO_DOCS_INSTANCE;
            }
            if (context.getIndexSettings().getIndexVersionCreated().before(SPARSE_VECTOR_IN_FIELD_NAMES_INDEX_VERSION)) {
                throw new IllegalArgumentException("[sparse_vector] fields do not support [exists] queries");
            }
            return super.existsQuery(context);
        }

        public Query finalizeSparseVectorQuery(SearchExecutionContext context, String fieldName, List<WeightedToken> queryVectors, Boolean shouldPruneTokensFromQuery, TokenPruningConfig tokenPruningConfigFromQuery) throws IOException {
            Boolean shouldPruneTokens = shouldPruneTokensFromQuery;
            TokenPruningConfig tokenPruningConfig = tokenPruningConfigFromQuery;
            if (this.indexOptions != null) {
                if (shouldPruneTokens == null && this.indexOptions.prune != null) {
                    shouldPruneTokens = this.indexOptions.prune;
                }
                if (tokenPruningConfig == null && this.indexOptions.pruningConfig != null) {
                    tokenPruningConfig = this.indexOptions.pruningConfig;
                }
            }
            return shouldPruneTokens != null && shouldPruneTokens != false ? WeightedTokensUtils.queryBuilderWithPrunedTokens(fieldName, tokenPruningConfig == null ? new TokenPruningConfig() : tokenPruningConfig, queryVectors, this, context) : WeightedTokensUtils.queryBuilderWithAllTokens(fieldName, queryVectors, this, context);
        }

        private static String indexedValueForSearch(Object value) {
            if (value instanceof BytesRef) {
                return ((BytesRef)value).utf8ToString();
            }
            return value.toString();
        }
    }

    public static class SparseVectorIndexOptions
    implements IndexOptions {
        public static final ParseField PRUNE_FIELD_NAME = new ParseField("prune", new String[0]);
        public static final ParseField PRUNING_CONFIG_FIELD_NAME = new ParseField("pruning_config", new String[0]);
        public static final SparseVectorIndexOptions DEFAULT_PRUNING_INDEX_OPTIONS = new SparseVectorIndexOptions(true, new TokenPruningConfig());
        final Boolean prune;
        final TokenPruningConfig pruningConfig;

        public SparseVectorIndexOptions(@Nullable Boolean prune, @Nullable TokenPruningConfig pruningConfig) {
            if (!(pruningConfig == null || prune != null && prune.booleanValue())) {
                throw new IllegalArgumentException("[index_options] field [" + PRUNING_CONFIG_FIELD_NAME.getPreferredName() + "] should only be set if [" + PRUNE_FIELD_NAME.getPreferredName() + "] is set to true");
            }
            this.prune = prune;
            this.pruningConfig = pruningConfig;
        }

        public static boolean isDefaultOptions(SparseVectorIndexOptions indexOptions, IndexVersion indexVersion) {
            SparseVectorIndexOptions defaultIndexOptions = SparseVectorFieldMapper.indexVersionSupportsDefaultPruningConfig(indexVersion) ? DEFAULT_PRUNING_INDEX_OPTIONS : null;
            return Objects.equals(indexOptions, defaultIndexOptions);
        }

        public static SparseVectorIndexOptions getDefaultIndexOptions(IndexVersion indexVersion) {
            return SparseVectorFieldMapper.indexVersionSupportsDefaultPruningConfig(indexVersion) ? DEFAULT_PRUNING_INDEX_OPTIONS : null;
        }

        public static SparseVectorIndexOptions parseFromMap(Map<String, Object> map) {
            if (map == null) {
                return null;
            }
            try {
                MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, map, XContentType.JSON);
                return INDEX_OPTIONS_PARSER.parse(parser, null);
            }
            catch (IOException ioEx) {
                throw new UncheckedIOException(ioEx);
            }
        }

        public Boolean getPrune() {
            return this.prune;
        }

        public TokenPruningConfig getPruningConfig() {
            return this.pruningConfig;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.prune != null) {
                builder.field(PRUNE_FIELD_NAME.getPreferredName(), this.prune);
            }
            if (this.pruningConfig != null) {
                builder.field(PRUNING_CONFIG_FIELD_NAME.getPreferredName(), this.pruningConfig);
            }
            builder.endObject();
            return builder;
        }

        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SparseVectorIndexOptions otherAsIndexOptions = (SparseVectorIndexOptions)other;
            return Objects.equals(this.prune, otherAsIndexOptions.prune) && Objects.equals(this.pruningConfig, otherAsIndexOptions.pruningConfig);
        }

        public final int hashCode() {
            return Objects.hash(this.prune, this.pruningConfig);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexVersionCreated;
        private final FieldMapper.Parameter<Boolean> stored;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<SparseVectorIndexOptions> indexOptions = new FieldMapper.Parameter<SparseVectorIndexOptions>("index_options", true, () -> null, (n, c, o) -> SparseVectorFieldMapper.parseIndexOptions(c, o), m -> SparseVectorFieldMapper.toType((FieldMapper)m).fieldType().indexOptions, XContentBuilder::field, Objects::toString).acceptsNull().setSerializerCheck(this::indexOptionsSerializerCheck);
        private final boolean isExcludeSourceVectors;

        public Builder(String name, IndexVersion indexVersionCreated, boolean isExcludeSourceVectors) {
            super(name);
            this.stored = FieldMapper.Parameter.boolParam("store", false, m -> SparseVectorFieldMapper.toType(m).fieldType().isStored(), () -> isExcludeSourceVectors);
            this.indexVersionCreated = indexVersionCreated;
            this.isExcludeSourceVectors = isExcludeSourceVectors;
        }

        public Builder setStored(boolean value) {
            this.stored.setValue(value);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.stored, this.meta, this.indexOptions};
        }

        @Override
        public SparseVectorFieldMapper build(MapperBuilderContext context) {
            SparseVectorIndexOptions builderIndexOptions = this.indexOptions.getValue();
            if (builderIndexOptions == null) {
                builderIndexOptions = SparseVectorIndexOptions.getDefaultIndexOptions(this.indexVersionCreated);
            }
            boolean isExcludeSourceVectorsFinal = this.isExcludeSourceVectors && !context.isSourceSynthetic() && this.stored.get() != false;
            return new SparseVectorFieldMapper(this.leafName(), new SparseVectorFieldType(this.indexVersionCreated, context.buildFullName(this.leafName()), this.stored.get(), this.meta.getValue(), builderIndexOptions), this.builderParams(this, context), isExcludeSourceVectorsFinal);
        }

        private boolean indexOptionsSerializerCheck(boolean includeDefaults, boolean isConfigured, SparseVectorIndexOptions value) {
            return includeDefaults || !SparseVectorIndexOptions.isDefaultOptions(value, this.indexVersionCreated);
        }

        public void setIndexOptions(SparseVectorIndexOptions sparseVectorIndexOptions) {
            this.indexOptions.setValue(sparseVectorIndexOptions);
        }
    }

    private static class SparseVectorSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private final String fullPath;
        private final String leafName;
        private TermsEnum termsDocEnum;
        private boolean hasValue;

        private SparseVectorSyntheticFieldLoader(String fullPath, String leafName) {
            this.fullPath = fullPath;
            this.leafName = leafName;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            TermQuery existsQuery = new TermQuery(new Term("_field_names", this.fullPath));
            IndexSearcher searcher = new IndexSearcher(leafReader);
            searcher.setQueryCache(null);
            Scorer scorer = searcher.createWeight(existsQuery, ScoreMode.COMPLETE_NO_SCORES, 0.0f).scorer(searcher.getLeafContexts().getFirst());
            if (scorer == null) {
                return docId -> false;
            }
            FieldInfo fieldInfos = leafReader.getFieldInfos().fieldInfo(this.fullPath);
            boolean hasTermVectors = fieldInfos != null && fieldInfos.hasTermVectors();
            return docId -> {
                this.termsDocEnum = null;
                if (scorer.iterator().docID() < docId) {
                    scorer.iterator().advance(docId);
                }
                if (scorer.iterator().docID() != docId) {
                    this.hasValue = false;
                    return false;
                }
                if (!hasTermVectors) {
                    this.hasValue = true;
                    return true;
                }
                Terms terms = leafReader.termVectors().get(docId, this.fullPath);
                if (terms != null) {
                    this.termsDocEnum = terms.iterator();
                    if (this.termsDocEnum.next() == null) {
                        this.termsDocEnum = null;
                    }
                }
                this.hasValue = true;
                return true;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            assert (this.hasValue);
            b.startObject(this.leafName);
            if (this.termsDocEnum != null) {
                PostingsEnum reuse = null;
                do {
                    reuse = this.termsDocEnum.postings(reuse);
                    reuse.nextDoc();
                    b.field(this.termsDocEnum.term().utf8ToString(), XFeatureField.decodeFeatureValue(reuse.freq()));
                } while (this.termsDocEnum.next() != null);
            }
            b.endObject();
        }

        private Map<String, Float> copyAsMap() throws IOException {
            assert (this.hasValue);
            if (this.termsDocEnum == null) {
                return Map.of();
            }
            LinkedHashMap<String, Float> tokenMap = new LinkedHashMap<String, Float>();
            PostingsEnum reuse = null;
            do {
                reuse = this.termsDocEnum.postings(reuse);
                reuse.nextDoc();
                tokenMap.put(this.termsDocEnum.term().utf8ToString(), Float.valueOf(XFeatureField.decodeFeatureValue(reuse.freq())));
            } while (this.termsDocEnum.next() != null);
            return tokenMap;
        }

        @Override
        public String fieldName() {
            return this.fullPath;
        }

        @Override
        public void reset() {
            this.termsDocEnum = null;
        }
    }
}

