/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.DenseVectorBlockLoaderProcessor;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class DenseVectorBlockLoader<B extends BlockLoader.Builder>
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;
    private final int dimensions;
    private final DenseVectorFieldMapper.DenseVectorFieldType fieldType;
    private final DenseVectorBlockLoaderProcessor<B> processor;

    public DenseVectorBlockLoader(String fieldName, int dimensions, DenseVectorFieldMapper.DenseVectorFieldType fieldType, DenseVectorBlockLoaderProcessor<B> processor) {
        this.fieldName = fieldName;
        this.dimensions = dimensions;
        this.fieldType = fieldType;
        this.processor = processor;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return this.processor.createBuilder(factory, expectedCount, this.dimensions);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        switch (this.fieldType.getElementType()) {
            case FLOAT: 
            case BFLOAT16: {
                FloatVectorValues floatVectorValues = context.reader().getFloatVectorValues(this.fieldName);
                if (floatVectorValues == null) break;
                if (this.fieldType.isNormalized()) {
                    NumericDocValues magnitudeDocValues = context.reader().getNumericDocValues(this.fieldType.name() + "._magnitude");
                    return new FloatDenseVectorNormalizedValuesBlockReader<B>(floatVectorValues, this.dimensions, this.processor, magnitudeDocValues);
                }
                return new FloatDenseVectorValuesBlockReader<B>(floatVectorValues, this.dimensions, this.processor);
            }
            case BYTE: {
                ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                if (byteVectorValues == null) break;
                return new ByteDenseVectorValuesBlockReader<B>(byteVectorValues, this.dimensions, this.processor);
            }
            case BIT: {
                ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                if (byteVectorValues == null) break;
                return new BitDenseVectorValuesBlockReader<B>(byteVectorValues, this.dimensions, this.processor);
            }
        }
        return new BlockLoader.ConstantNullsReader();
    }

    private static class FloatDenseVectorNormalizedValuesBlockReader<B extends BlockLoader.Builder>
    extends FloatDenseVectorValuesBlockReader<B> {
        private final NumericDocValues magnitudeDocValues;

        FloatDenseVectorNormalizedValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions, DenseVectorBlockLoaderProcessor<B> processor, NumericDocValues magnitudeDocValues) {
            super(floatVectorValues, dimensions, processor);
            this.magnitudeDocValues = magnitudeDocValues;
        }

        @Override
        protected void processCurrentVector(B builder) throws IOException {
            this.assertDimensions();
            float[] vector = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index());
            if (this.magnitudeDocValues != null && this.magnitudeDocValues.advanceExact(this.iterator.docID())) {
                float magnitude = Float.intBitsToFloat((int)this.magnitudeDocValues.longValue());
                int i = 0;
                while (i < vector.length) {
                    int n = i++;
                    vector[n] = vector[n] * magnitude;
                }
            }
            this.processor.process(vector, builder);
        }

        @Override
        public String toString() {
            return "FloatDenseVectorFromDocValues.Normalized." + this.processor.name();
        }
    }

    private static class FloatDenseVectorValuesBlockReader<B extends BlockLoader.Builder>
    extends AbstractVectorValuesReader<FloatVectorValues, B> {
        FloatDenseVectorValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions, DenseVectorBlockLoaderProcessor<B> processor) {
            super(floatVectorValues, processor, dimensions);
        }

        @Override
        protected void processCurrentVector(B builder) throws IOException {
            this.assertDimensions();
            float[] vector = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index());
            this.processor.process(vector, builder);
        }

        @Override
        public String toString() {
            return "FloatDenseVectorFromDocValues." + this.processor.name();
        }
    }

    private static class ByteDenseVectorValuesBlockReader<B extends BlockLoader.Builder>
    extends AbstractVectorValuesReader<ByteVectorValues, B> {
        ByteDenseVectorValuesBlockReader(ByteVectorValues byteVectorValues, int dimensions, DenseVectorBlockLoaderProcessor<B> processor) {
            super(byteVectorValues, processor, dimensions);
        }

        @Override
        protected void processCurrentVector(B builder) throws IOException {
            this.assertDimensions();
            byte[] vector = ((ByteVectorValues)this.vectorValues).vectorValue(this.iterator.index());
            this.processor.process(vector, builder);
        }

        @Override
        public String toString() {
            return "ByteDenseVectorFromDocValues." + this.processor.name();
        }
    }

    private static class BitDenseVectorValuesBlockReader<B extends BlockLoader.Builder>
    extends ByteDenseVectorValuesBlockReader<B> {
        BitDenseVectorValuesBlockReader(ByteVectorValues byteVectorValues, int dimensions, DenseVectorBlockLoaderProcessor<B> processor) {
            super(byteVectorValues, dimensions, processor);
        }

        @Override
        protected void assertDimensions() {
            assert (((ByteVectorValues)this.vectorValues).dimension() * 8 == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + ((ByteVectorValues)this.vectorValues).dimension() * 8;
        }

        @Override
        public String toString() {
            return "BitDenseVectorFromDocValues." + this.processor.name();
        }
    }

    private static abstract class AbstractVectorValuesReader<T extends KnnVectorValues, B extends BlockLoader.Builder>
    extends BlockDocValuesReader {
        protected final T vectorValues;
        protected final KnnVectorValues.DocIndexIterator iterator;
        protected final DenseVectorBlockLoaderProcessor<B> processor;
        protected final int dimensions;

        protected AbstractVectorValuesReader(T vectorValues, DenseVectorBlockLoaderProcessor<B> processor, int dimensions) {
            this.vectorValues = vectorValues;
            this.iterator = ((KnnVectorValues)vectorValues).iterator();
            this.processor = processor;
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (B builder = this.processor.createBuilder(factory, docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    this.read(docs.get(i), builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, builder);
        }

        protected void read(int doc, B builder) throws IOException {
            if (this.iterator.docID() > doc) {
                this.processor.appendNull(builder);
            } else if (this.iterator.docID() == doc || this.iterator.advance(doc) == doc) {
                this.processCurrentVector(builder);
            } else {
                this.processor.appendNull(builder);
            }
        }

        @Override
        public int docId() {
            return this.iterator.docID();
        }

        protected abstract void processCurrentVector(B var1) throws IOException;

        protected void assertDimensions() {
            assert (((KnnVectorValues)this.vectorValues).dimension() == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + ((KnnVectorValues)this.vectorValues).dimension();
        }
    }
}

